/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.internal.teneo;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.hibernate.internal.teneo.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.hibernate.cdo.CDOHelper;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.cfg.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeneoHibernateMappingProvider
extends HibernateMappingProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TeneoHibernateMappingProvider.class);
    private ExtensionManager extensionManager = ExtensionManagerFactory.getInstance().create();

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public HibernateStore getHibernateStore() {
        return (HibernateStore)super.getHibernateStore();
    }

    public void addMapping(Configuration configuration) {
        String mapping = this.generateMapping();
        if (TRACER.isEnabled()) {
            TRACER.trace("Generated hibernate mapping:");
            TRACER.trace(mapping);
        }
        configuration.addXML(mapping);
        if (TRACER.isEnabled()) {
            TRACER.trace("Added mapping to configuration");
        }
    }

    public String generateMapping() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Generating Hibernate Mapping");
        }
        Properties properties = HibernateUtil.getInstance().getPropertiesFromStore((IStore)this.getHibernateStore());
        List epacks = this.getHibernateStore().getPackageHandler().getEPackages();
        epacks.remove(EcorePackage.eINSTANCE);
        epacks.remove(EresourcePackage.eINSTANCE);
        EPackage[] ePackageArray = epacks.toArray(new EPackage[epacks.size()]);
        properties.put("teneo.mapping.also_map_as_class", "false");
        String hbm = CDOHelper.getInstance().generateMapping(ePackageArray, properties, this.extensionManager);
        hbm = hbm.replaceAll("_cont", "cont");
        return hbm;
    }

    protected List<EPackage> resolveSubPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        this.resolveSubPackages(ePackage, result);
        return result;
    }

    private void resolveSubPackages(EPackage ePackage, List<EPackage> result) {
        EPackage globalPackage = EPackage.Registry.INSTANCE.getEPackage(ePackage.getNsURI());
        if (globalPackage != null) {
            ePackage = globalPackage;
        }
        result.add(ePackage);
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            this.resolveSubPackages(subEPackage, result);
        }
    }
}

