/**
 * <copyright>
 * </copyright>
 *
 * $Id: TableGeneratorValidator.java,v 1.1 2007/02/08 23:12:34 mtaal Exp $
 */
package org.eclipse.emf.teneo.annotations.pannotation.validation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.teneo.annotations.pannotation.UniqueConstraint;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.annotations.pannotation.TableGenerator}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface TableGeneratorValidator {
	boolean validate();

	boolean validateName(String value);
	boolean validateTable(String value);
	boolean validateCatalog(String value);
	boolean validateSchema(String value);
	boolean validatePkColumnName(String value);
	boolean validateValueColumnName(String value);
	boolean validatePkColumnValue(String value);
	boolean validateInitialValue(int value);
	boolean validateAllocationSize(int value);
	boolean validateUniqueConstraints(EList<UniqueConstraint> value);
}
