/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionEvent;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionImpl;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORemoteSessionManagerImpl
extends Container<CDORemoteSession>
implements InternalCDORemoteSessionManager {
    private InternalCDOSession localSession;
    private boolean forceSubscription;
    private boolean subscribed;
    private Map<Integer, CDORemoteSession> remoteSessions = new HashMap<Integer, CDORemoteSession>();

    public CDORemoteSessionManagerImpl(InternalCDOSession localSession) {
        this.localSession = localSession;
    }

    @Override
    public InternalCDOSession getLocalSession() {
        return this.localSession;
    }

    @Override
    public synchronized CDORemoteSession[] getRemoteSessions() {
        Collection<CDORemoteSession> remoteSessions = this.subscribed ? this.remoteSessions.values() : this.localSession.getSessionProtocol().getRemoteSessions(this, false);
        return remoteSessions.toArray(new CDORemoteSession[remoteSessions.size()]);
    }

    public CDORemoteSession[] getElements() {
        return this.getRemoteSessions();
    }

    @Override
    public synchronized boolean isSubscribed() {
        return this.subscribed;
    }

    @Override
    public synchronized boolean isForceSubscription() {
        return this.forceSubscription;
    }

    @Override
    public synchronized void setForceSubscription(boolean forceSubscription) {
        this.forceSubscription = forceSubscription;
        if (forceSubscription && !this.subscribed) {
            IContainerEvent<CDORemoteSession> event = this.subscribe();
            this.fireEvent((IEvent)event);
        }
    }

    @Override
    public CDORemoteSession createRemoteSession(int sessionID, String userID, boolean subscribed) {
        CDORemoteSessionImpl remoteSession = new CDORemoteSessionImpl(this, sessionID, userID);
        remoteSession.setSubscribed(subscribed);
        return remoteSession;
    }

    @Override
    public synchronized void handleRemoteSessionOpened(int sessionID, String userID) {
        CDORemoteSession remoteSession = this.createRemoteSession(sessionID, userID, false);
        this.remoteSessions.put(sessionID, remoteSession);
        this.fireElementAddedEvent(remoteSession);
    }

    @Override
    public synchronized void handleRemoteSessionClosed(int sessionID) {
        CDORemoteSession remoteSession = this.remoteSessions.remove(sessionID);
        if (remoteSession != null) {
            this.fireElementRemovedEvent(remoteSession);
        }
    }

    @Override
    public synchronized void handleRemoteSessionSubscribed(int sessionID, final boolean subscribed) {
        final CDORemoteSessionImpl remoteSession = (CDORemoteSessionImpl)this.remoteSessions.get(sessionID);
        if (remoteSession != null) {
            remoteSession.setSubscribed(subscribed);
            this.fireEvent(new CDORemoteSessionEvent.SubscriptionChanged(){

                public INotifier getSource() {
                    return CDORemoteSessionManagerImpl.this;
                }

                public CDORemoteSession getRemoteSession() {
                    return remoteSession;
                }

                public boolean isSubscribed() {
                    return subscribed;
                }
            });
        }
    }

    protected synchronized void listenersEmptyChanged(boolean empty) {
        if (empty) {
            if (!this.forceSubscription) {
                IContainerEvent<CDORemoteSession> event = this.unsubscribe();
                this.fireEvent((IEvent)event);
            }
        } else if (!this.subscribed) {
            IContainerEvent<CDORemoteSession> event = this.subscribe();
            this.fireEvent((IEvent)event);
        }
    }

    private IContainerEvent<CDORemoteSession> subscribe() {
        List<CDORemoteSession> result = this.localSession.getSessionProtocol().getRemoteSessions(this, true);
        ContainerEvent event = new ContainerEvent((IContainer)this);
        for (CDORemoteSession remoteSession : result) {
            this.remoteSessions.put(remoteSession.getSessionID(), remoteSession);
            event.addDelta((Object)remoteSession, IContainerDelta.Kind.ADDED);
        }
        this.subscribed = true;
        return event;
    }

    private IContainerEvent<CDORemoteSession> unsubscribe() {
        this.localSession.getSessionProtocol().unsubscribeRemoteSessions();
        ContainerEvent event = new ContainerEvent((IContainer)this);
        for (CDORemoteSession remoteSession : this.remoteSessions.values()) {
            event.addDelta((Object)remoteSession, IContainerDelta.Kind.REMOVED);
        }
        this.remoteSessions.clear();
        this.subscribed = false;
        return event;
    }
}

