/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.internal.ui.ItemsProcessor;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.om.pref.OMPreferencesChangeEvent;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOEventHandler {
    private CDOView view;
    private TreeViewer treeViewer;
    private IListener sessionListener = new IListener(){

        public void notifyEvent(IEvent event) {
            ILifecycleEvent e;
            if (event instanceof IContainerEvent) {
                IContainerEvent e2 = (IContainerEvent)event;
                if (e2.getDeltaElement() == CDOEventHandler.this.view && e2.getDeltaKind() == IContainerDelta.Kind.REMOVED) {
                    CDOEventHandler.this.viewClosed();
                }
            } else if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                CDOEventHandler.this.viewClosed();
            }
        }
    };
    private IListener viewListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOViewInvalidationEvent) {
                CDOViewInvalidationEvent e = (CDOViewInvalidationEvent)event;
                CDOEventHandler.this.checkDetachedSelection(e.getDetachedObjects());
                CDOEventHandler.this.viewInvalidated(e.getDirtyObjects());
            } else if (event instanceof CDOTransactionFinishedEvent) {
                CDOEventHandler.this.refreshTreeViewer();
                CDOEventHandler.this.viewDirtyStateChanged();
            } else if (event instanceof CDOTransactionStartedEvent) {
                CDOEventHandler.this.viewDirtyStateChanged();
            } else if (event instanceof CDOTransactionConflictEvent) {
                CDOTransactionConflictEvent e = (CDOTransactionConflictEvent)event;
                CDOEventHandler.this.viewConflict(e.getConflictingObject(), e.isFirstConflict());
            }
        }
    };
    private IListener preferenceListener = new IListener(){

        public void notifyEvent(IEvent event) {
            OMPreferencesChangeEvent preferenceChangeEvent = (OMPreferencesChangeEvent)event;
            if (OM.PREF_EDITOR_AUTO_RELOAD.getName().equals(preferenceChangeEvent.getPreference().getName())) {
                if (((Boolean)preferenceChangeEvent.getNewValue()).booleanValue()) {
                    CDOEventHandler.this.refreshTreeViewer();
                }
            } else if (OM.PREF_LABEL_DECORATION.getName().equals(preferenceChangeEvent.getPreference().getName())) {
                try {
                    CDOEventHandler.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                PlatformUI.getWorkbench().getDecoratorManager().update("org.eclipse.emf.cdo.ui.cdolabeldecorator");
                            }
                            catch (Exception exception) {}
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    };

    private void checkDetachedSelection(final Set<?> detachedObjects) {
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IStructuredSelection selection = (IStructuredSelection)CDOEventHandler.this.treeViewer.getSelection();
                    List selectedElements = selection.toList();
                    for (Object object : selectedElements) {
                        if (!detachedObjects.contains(object)) continue;
                        CDOEventHandler.this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                }
                catch (Exception exception) {}
            }
        });
    }

    public CDOEventHandler(CDOView view, TreeViewer treeViewer) {
        this.view = view;
        this.treeViewer = treeViewer;
        this.wirePreferences();
        view.getSession().addListener(this.sessionListener);
        view.addListener(this.viewListener);
    }

    public void dispose() {
        if (this.view != null) {
            this.view.removeListener(this.viewListener);
            CDOSession session = this.view.getSession();
            if (session != null) {
                session.removeListener(this.sessionListener);
            }
        }
        this.unwirePreferences();
        this.view = null;
        this.treeViewer = null;
    }

    public CDOView getView() {
        return this.view;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public void refreshTreeViewer() {
        try {
            this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        CDOEventHandler.this.treeViewer.refresh(true);
                    }
                    catch (Exception exception) {}
                }
            });
        }
        catch (Exception exception) {}
    }

    public boolean isAutoReloadEnabled() {
        return (Boolean)OM.PREF_EDITOR_AUTO_RELOAD.getValue();
    }

    protected void wirePreferences() {
        OM.PREFS.addListener(this.preferenceListener);
    }

    protected void unwirePreferences() {
        OM.PREFS.removeListener(this.preferenceListener);
    }

    protected void viewInvalidated(Set<? extends CDOObject> dirtyObjects) {
        new ItemsProcessor(this.view){

            protected void processCDOObject(TreeViewer viewer, InternalCDOObject cdoObject) {
                CDOEventHandler.this.objectInvalidated(cdoObject);
                if (CDOEventHandler.this.isAutoReloadEnabled()) {
                    viewer.refresh((Object)cdoObject.cdoInternalInstance(), true);
                }
            }
        }.processCDOObjects(this.treeViewer, dirtyObjects);
    }

    protected void objectInvalidated(InternalCDOObject cdoObject) {
    }

    protected void viewDirtyStateChanged() {
    }

    protected void viewConflict(CDOObject conflictingObject, boolean firstConflict) {
    }

    protected void viewClosed() {
    }
}

