/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class RepositoryTimeIndication
extends CDOServerIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, RepositoryTimeIndication.class);
    private long indicated;

    public RepositoryTimeIndication(CDOServerProtocol protocol) {
        super(protocol, (short)24);
    }

    public RepositoryTimeIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.indicated = System.currentTimeMillis();
    }

    protected void responding(CDODataOutput out) throws IOException {
        long responded = System.currentTimeMillis();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing indicated: {0,date} {0,time}", new Object[]{this.indicated});
        }
        out.writeLong(this.indicated);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing responded: {0,date} {0,time}", new Object[]{responded});
        }
        out.writeLong(responded);
    }
}

