/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.mem.MEMStore;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreChunkReader;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStoreAccessor
extends LongIDStoreAccessor {
    private final IQueryHandler testQueryHandler = new IQueryHandler(){

        public void executeQuery(CDOQueryInfo info, IQueryContext queryContext) {
            ArrayList<1> filters = new ArrayList<1>();
            Object context = info.getParameters().get("context");
            Long sleep = (Long)info.getParameters().get("sleep");
            if (context != null && context instanceof EClass) {
                final EClass eClass = (EClass)context;
                filters.add(new Object(){

                    public boolean equals(Object obj) {
                        InternalCDORevision revision = (InternalCDORevision)obj;
                        return revision.getEClass().equals(eClass);
                    }
                });
            }
            for (InternalCDORevision revision : MEMStoreAccessor.this.getStore().getCurrentRevisions()) {
                if (sleep != null) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
                boolean valid = true;
                for (Object e : filters) {
                    if (e.equals(revision)) continue;
                    valid = false;
                    break;
                }
                if (valid && !queryContext.addResult(revision)) break;
            }
        }
    };
    private List<InternalCDORevision> newRevisions = new ArrayList<InternalCDORevision>();

    public MEMStoreAccessor(MEMStore store, ISession session) {
        super((Store)store, session);
    }

    public MEMStoreAccessor(MEMStore store, ITransaction transaction) {
        super((Store)store, transaction);
    }

    @Override
    public MEMStore getStore() {
        return (MEMStore)super.getStore();
    }

    @Override
    public MEMStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new MEMStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Override
    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return Collections.emptySet();
    }

    @Override
    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalCDORevision readRevision(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache) {
        InternalCDORevision storeRevision = this.getStore().getRevision(id);
        return storeRevision;
    }

    @Override
    public InternalCDORevision readRevisionByTime(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache, long timeStamp) {
        return this.getStore().getRevisionByTime(id, timeStamp);
    }

    @Override
    public InternalCDORevision readRevisionByVersion(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache, int version) {
        return this.getStore().getRevisionByVersion(id, version);
    }

    @Override
    public void commit(OMMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IStoreAccessor.CommitContext context, OMMonitor monitor) {
        MEMStore store;
        MEMStore mEMStore = store = this.getStore();
        synchronized (mEMStore) {
            super.write(context, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rollback(IStoreAccessor.CommitContext context) {
        MEMStore store;
        MEMStore mEMStore = store = this.getStore();
        synchronized (mEMStore) {
            for (InternalCDORevision revision : this.newRevisions) {
                store.rollbackRevision(revision);
            }
        }
    }

    @Override
    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
    }

    @Override
    protected void writeRevisions(InternalCDORevision[] revisions, OMMonitor monitor) {
        InternalCDORevision[] internalCDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            this.writeRevision(revision);
            ++n2;
        }
    }

    protected void writeRevision(InternalCDORevision revision) {
        this.newRevisions.add(revision);
        this.getStore().addRevision(revision);
    }

    @Override
    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, long created, OMMonitor monitor) {
        InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
        int n = revisionDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionDelta revisionDelta = internalCDORevisionDeltaArray[n2];
            this.writeRevisionDelta(revisionDelta, created);
            ++n2;
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta revisionDelta, long created) {
        InternalCDORevision revision = this.getStore().getRevision(revisionDelta.getID());
        if (revision.getVersion() != revisionDelta.getOriginVersion()) {
            throw new ConcurrentModificationException("Trying to update object " + revisionDelta.getID() + " that was already modified");
        }
        InternalCDORevision newRevision = (InternalCDORevision)revision.copy();
        revisionDelta.apply((CDORevision)newRevision);
        newRevision.setCreated(created);
        this.writeRevision(newRevision);
    }

    @Override
    protected void detachObjects(CDOID[] detachedObjects, long revised, OMMonitor monitor) {
        CDOID[] cDOIDArray = detachedObjects;
        int n = detachedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            this.detachObject(id);
            ++n2;
        }
    }

    protected void detachObject(CDOID id) {
        this.getStore().removeID(id);
    }

    @Override
    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        this.getStore().queryResources(context);
    }

    @Override
    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        if ("TEST".equals(info.getQueryLanguage())) {
            return this.testQueryHandler;
        }
        return null;
    }

    @Override
    public void refreshRevisions() {
    }

    @Override
    protected void doActivate() throws Exception {
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.newRevisions.clear();
    }

    @Override
    protected void doPassivate() throws Exception {
    }

    @Override
    protected void doUnpassivate() throws Exception {
    }
}

