/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCDOPackageUnit;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateEPackage;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.SystemInformation;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePackageHandler
extends Lifecycle {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernatePackageHandler.class);
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private static final String CDO_PACKAGE_UNIT_ENTITY_NAME = "CDOPackageUnit";
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private int nextPackageID;
    private int nextClassID;
    private int nextFeatureID;
    private Collection<InternalCDOPackageUnit> packageUnits = null;
    private HibernateStore hibernateStore;

    public HibernatePackageHandler(HibernateStore store) {
        this.hibernateStore = store;
    }

    public List<EPackage> getEPackages() {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        EPackage[] ePackageArray = this.getPackageRegistry().getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            ePackages.add(ePackage);
            ++n2;
        }
        return ePackages;
    }

    private InternalCDOPackageRegistry getPackageRegistry() {
        return (InternalCDOPackageRegistry)this.hibernateStore.getRepository().getPackageRegistry();
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Persisting new EPackages");
        }
        Session session = this.getSessionFactory().openSession();
        Transaction tx = session.beginTransaction();
        boolean err = true;
        boolean updated = false;
        try {
            try {
                InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
                int n = packageUnits.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                    session.saveOrUpdate(CDO_PACKAGE_UNIT_ENTITY_NAME, (Object)new HibernateCDOPackageUnit((CDOPackageUnit)packageUnit));
                    if (packageUnit.getPackageInfos().length > 0) {
                        HibernateEPackage hbEPackage = new HibernateEPackage();
                        String rootNSUri = packageUnit.getTopLevelPackageInfo().getPackageURI();
                        hbEPackage.setNsUri(rootNSUri);
                        CDOPackageRegistry registry = this.hibernateStore.getRepository().getPackageRegistry();
                        EPackage rootEPackage = registry.getEPackage(rootNSUri);
                        hbEPackage.setEPackageBlob(EMFUtil.getEPackageBytes((EPackage)rootEPackage, (boolean)true, (EPackage.Registry)registry));
                        session.saveOrUpdate((Object)hbEPackage);
                    }
                    updated = true;
                    ++n2;
                }
                tx.commit();
                err = false;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new Error(e);
            }
        }
        finally {
            if (err) {
                tx.rollback();
            }
            session.close();
        }
        if (updated) {
            this.reset();
            this.hibernateStore.reInitialize();
        }
    }

    public Collection<InternalCDOPackageUnit> getPackageUnits() {
        this.readPackageUnits();
        return this.packageUnits;
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        String nsUri = packageUnit.getTopLevelPackageInfo().getPackageURI();
        if (TRACER.isEnabled()) {
            TRACER.trace("Reading EPackages with root uri " + nsUri + " from db");
        }
        Session session = this.getSessionFactory().openSession();
        session.beginTransaction();
        try {
            Criteria criteria = session.createCriteria(HibernateEPackage.class);
            criteria.add((Criterion)Expression.eq((String)"nsUri", (Object)nsUri));
            List list = criteria.list();
            if (list.size() != 1) {
                throw new IllegalArgumentException("EPackage with uri " + nsUri + " not present in the db");
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Found " + list.size() + " EPackages in DB");
            }
            HibernateEPackage hbEPackage = (HibernateEPackage)list.get(0);
            if (TRACER.isEnabled()) {
                TRACER.trace("Read EPackage: " + nsUri);
            }
            EPackage rootEPackage = EMFUtil.createEPackage((String)nsUri, (byte[])hbEPackage.getEPackageBlob(), (boolean)true, (EPackage.Registry)this.hibernateStore.getRepository().getPackageRegistry());
            EPackage[] ePackageArray = EMFUtil.getAllPackages((EPackage)rootEPackage);
            return ePackageArray;
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    protected void readPackageUnits() {
        if (this.packageUnits == null || this.packageUnits.size() == 0) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Reading EPackages from db");
            }
            Session session = this.getSessionFactory().openSession();
            try {
                Criteria criteria = session.createCriteria(CDO_PACKAGE_UNIT_ENTITY_NAME);
                List list = criteria.list();
                if (TRACER.isEnabled()) {
                    TRACER.trace("Found " + list.size() + " CDOPackageUnits in DB");
                }
                this.packageUnits = list;
            }
            finally {
                session.close();
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Finished reading EPackages");
        }
    }

    void doDropSchema() {
        SchemaExport se = new SchemaExport(this.configuration);
        se.drop(false, true);
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.configuration.buildSessionFactory();
        }
        return this.sessionFactory;
    }

    public synchronized int getNextPackageID() {
        return this.nextPackageID++;
    }

    public synchronized int getNextClassID() {
        return this.nextClassID++;
    }

    public synchronized int getNextFeatureID() {
        return this.nextFeatureID++;
    }

    public void reset() {
        this.packageUnits = null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.initConfiguration();
        this.initSchema();
    }

    protected void doDeactivate() throws Exception {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        super.doDeactivate();
    }

    protected void initConfiguration() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Initializing configuration for CDO metadata");
        }
        InputStream in = null;
        try {
            try {
                in = OM.BUNDLE.getInputStream("/mappings/meta.hbm.xml");
                this.configuration = new Configuration();
                this.configuration.addInputStream(in);
                this.configuration.setProperties(HibernateUtil.getInstance().getPropertiesFromStore(this.hibernateStore));
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    SystemInformation getSystemInformation() {
        Session session = this.getSessionFactory().openSession();
        session.beginTransaction();
        try {
            SystemInformation systemInformation;
            Criteria c = session.createCriteria(SystemInformation.class);
            List l = c.list();
            if (l.size() == 0) {
                systemInformation = new SystemInformation();
                systemInformation.setFirstTime(true);
                systemInformation.setCreationTime(System.currentTimeMillis());
                session.saveOrUpdate((Object)systemInformation);
            } else {
                if (l.size() > 1) {
                    throw new IllegalStateException("More than one records in the cdo_system_information table, this is an illegal situation");
                }
                systemInformation = (SystemInformation)l.get(0);
                systemInformation.setFirstTime(false);
            }
            SystemInformation systemInformation2 = systemInformation;
            return systemInformation2;
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    protected void initSchema() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Updating db schema for Hibernate PackageHandler");
        }
        new SchemaUpdate(this.configuration).execute(true, true);
    }
}

