/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListIndexAffecting;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListTargetAdding;
import org.eclipse.emf.cdo.internal.common.revision.delta.InternalCDOFeatureDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOListFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOListFeatureDelta {
    private List<CDOFeatureDelta> featureDeltas = new ArrayList<CDOFeatureDelta>();
    private transient int[] cacheIndices;
    private transient IListTargetAdding[] cacheSources;
    private transient List<CDOFeatureDelta> notProcessedFeatureDelta;

    public CDOListFeatureDeltaImpl(EStructuralFeature feature) {
        super(feature);
    }

    public CDOListFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.featureDeltas.add(in.readCDOFeatureDelta(eClass));
            ++i;
        }
    }

    @Override
    public CDOListFeatureDelta copy() {
        CDOListFeatureDeltaImpl list = new CDOListFeatureDeltaImpl(this.getFeature());
        for (CDOFeatureDelta delta : this.featureDeltas) {
            list.add(((InternalCDOFeatureDelta)delta).copy());
        }
        return list;
    }

    @Override
    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeInt(this.featureDeltas.size());
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            out.writeCDOFeatureDelta(eClass, featureDelta);
        }
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.LIST;
    }

    @Override
    public List<CDOFeatureDelta> getListChanges() {
        return this.featureDeltas;
    }

    public Pair<IListTargetAdding[], int[]> reconstructAddedIndices() {
        this.reconstructAddedIndicesWithNoCopy();
        return new Pair((Object)((IListTargetAdding[])CDOListFeatureDeltaImpl.copyOf(this.cacheSources, this.cacheSources.length, this.cacheSources.getClass())), (Object)CDOListFeatureDeltaImpl.copyOf(this.cacheIndices, this.cacheIndices.length));
    }

    private void reconstructAddedIndicesWithNoCopy() {
        if (this.cacheIndices == null || this.notProcessedFeatureDelta != null) {
            Object[] newElements;
            int newCapacity;
            if (this.cacheIndices == null) {
                this.cacheIndices = new int[1 + this.featureDeltas.size()];
            } else if (this.cacheIndices.length <= 1 + this.featureDeltas.size()) {
                newCapacity = Math.max(10, this.cacheIndices.length * 3 / 2 + 1);
                newElements = new int[newCapacity];
                System.arraycopy(this.cacheIndices, 0, newElements, 0, this.cacheIndices.length);
                this.cacheIndices = newElements;
            }
            if (this.cacheSources == null) {
                this.cacheSources = new IListTargetAdding[1 + this.featureDeltas.size()];
            } else if (this.cacheSources.length <= 1 + this.featureDeltas.size()) {
                newCapacity = Math.max(10, this.cacheSources.length * 3 / 2 + 1);
                newElements = new IListTargetAdding[newCapacity];
                System.arraycopy(this.cacheSources, 0, newElements, 0, this.cacheSources.length);
                this.cacheSources = (IListTargetAdding[])newElements;
            }
            List<CDOFeatureDelta> featureDeltasToBeProcess = this.notProcessedFeatureDelta == null ? this.featureDeltas : this.notProcessedFeatureDelta;
            for (CDOFeatureDelta featureDelta : featureDeltasToBeProcess) {
                if (featureDelta instanceof IListIndexAffecting) {
                    IListIndexAffecting affecting = (IListIndexAffecting)((Object)featureDelta);
                    affecting.affectIndices(this.cacheSources, this.cacheIndices);
                }
                if (!(featureDelta instanceof IListTargetAdding)) continue;
                this.cacheIndices[0] = this.cacheIndices[0] + 1;
                this.cacheIndices[this.cacheIndices[0]] = ((IListTargetAdding)((Object)featureDelta)).getIndex();
                this.cacheSources[this.cacheIndices[0]] = (IListTargetAdding)((Object)featureDelta);
            }
            this.notProcessedFeatureDelta = null;
        }
    }

    private void cleanupWithNewDelta(CDOFeatureDelta featureDelta) {
        EStructuralFeature feature = this.getFeature();
        if ((feature instanceof EReference || FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) && featureDelta instanceof CDORemoveFeatureDelta) {
            int indexToRemove = ((CDORemoveFeatureDelta)featureDelta).getIndex();
            this.reconstructAddedIndicesWithNoCopy();
            int i = 1;
            while (i <= this.cacheIndices[0]) {
                int index = this.cacheIndices[i];
                if (indexToRemove == index) {
                    this.cacheSources[i].clear();
                    break;
                }
                ++i;
            }
        }
        if (this.cacheIndices != null) {
            if (this.notProcessedFeatureDelta == null) {
                this.notProcessedFeatureDelta = new ArrayList<CDOFeatureDelta>();
            }
            this.notProcessedFeatureDelta.add(featureDelta);
        }
    }

    public void add(CDOFeatureDelta featureDelta) {
        this.cleanupWithNewDelta(featureDelta);
        this.featureDeltas.add(featureDelta);
    }

    @Override
    public void apply(CDORevision revision) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            ((CDOFeatureDeltaImpl)featureDelta).apply(revision);
        }
    }

    @Override
    public void adjustReferences(CDOReferenceAdjuster adjuster) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(adjuster);
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    private static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

