/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCacheUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDORevisionResolverImpl
extends Lifecycle
implements CDORevisionResolver {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, CDORevisionResolverImpl.class);
    private CDORevisionCache cache;
    @ReflectUtil.ExcludeFromDump
    private Object loadAndAddLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private Object revisedLock = new Object();

    @Override
    public CDORevisionCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(CDORevisionCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean containsRevision(CDOID id) {
        return this.cache.getRevision(id) != null;
    }

    @Override
    public boolean containsRevisionByTime(CDOID id, long timeStamp) {
        return this.cache.getRevisionByTime(id, timeStamp) != null;
    }

    @Override
    public boolean containsRevisionByVersion(CDOID id, int version) {
        return this.cache.getRevisionByVersion(id, version) != null;
    }

    @Override
    public EClass getObjectType(CDOID id) {
        return this.cache.getObjectType(id);
    }

    public void revisedRevision(CDOID id, long timeStamp) {
        this.acquireAtomicRequestLock(this.revisedLock);
        try {
            InternalCDORevision revision = this.cache.getRevision(id);
            if (revision != null) {
                if (timeStamp == 0L) {
                    this.removeCachedRevision(revision.getID(), revision.getVersion());
                } else {
                    revision.setRevised(timeStamp - 1L);
                }
            }
        }
        finally {
            this.releaseAtomicRequestLock(this.revisedLock);
        }
    }

    public void revisedRevisionByVersion(CDOID id, int version, long timeStamp) {
        this.acquireAtomicRequestLock(this.revisedLock);
        try {
            InternalCDORevision revision = this.cache.getRevisionByVersion(id, version);
            if (revision != null) {
                if (timeStamp == 0L) {
                    this.removeCachedRevision(revision.getID(), revision.getVersion());
                } else {
                    revision.setRevised(timeStamp - 1L);
                }
            }
        }
        finally {
            this.releaseAtomicRequestLock(this.revisedLock);
        }
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, int referenceChunk) {
        return this.getRevision(id, referenceChunk, true);
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, int referenceChunk, boolean loadOnDemand) {
        this.acquireAtomicRequestLock(this.loadAndAddLock);
        try {
            InternalCDORevision revision = this.cache.getRevision(id);
            if (revision == null) {
                if (loadOnDemand) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Loading revision {0}", new Object[]{id});
                    }
                    revision = this.loadRevision(id, referenceChunk);
                    this.addCachedRevisionIfNotNull(revision);
                }
            } else {
                InternalCDORevision oldRevision = revision;
                if ((revision = this.verifyRevision(oldRevision, referenceChunk)) != oldRevision) {
                    this.addCachedRevisionIfNotNull(revision);
                }
            }
            InternalCDORevision internalCDORevision = revision;
            return internalCDORevision;
        }
        finally {
            this.releaseAtomicRequestLock(this.loadAndAddLock);
        }
    }

    @Override
    public InternalCDORevision getRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        return this.getRevisionByTime(id, referenceChunk, timeStamp, true);
    }

    @Override
    public InternalCDORevision getRevisionByTime(CDOID id, int referenceChunk, long timeStamp, boolean loadOnDemand) {
        this.acquireAtomicRequestLock(this.loadAndAddLock);
        try {
            InternalCDORevision revision = this.cache.getRevisionByTime(id, timeStamp);
            if (revision == null) {
                if (loadOnDemand) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Loading revision {0} by time {1,date} {1,time}", new Object[]{id, timeStamp});
                    }
                    revision = this.loadRevisionByTime(id, referenceChunk, timeStamp);
                    this.addCachedRevisionIfNotNull(revision);
                }
            } else {
                InternalCDORevision verified = this.verifyRevision(revision, referenceChunk);
                if (revision != verified) {
                    this.addCachedRevisionIfNotNull(verified);
                    revision = verified;
                }
            }
            InternalCDORevision internalCDORevision = revision;
            return internalCDORevision;
        }
        finally {
            this.releaseAtomicRequestLock(this.loadAndAddLock);
        }
    }

    @Override
    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, int referenceChunk, int version) {
        return this.getRevisionByVersion(id, referenceChunk, version, true);
    }

    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, int referenceChunk, int version, boolean loadOnDemand) {
        this.acquireAtomicRequestLock(this.loadAndAddLock);
        try {
            InternalCDORevision revision = this.cache.getRevisionByVersion(id, version);
            if (revision == null && loadOnDemand) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Loading revision {0} by version {1}", new Object[]{id, version});
                }
                revision = this.loadRevisionByVersion(id, referenceChunk, version);
                this.addCachedRevisionIfNotNull(revision);
            }
            InternalCDORevision internalCDORevision = revision;
            return internalCDORevision;
        }
        finally {
            this.releaseAtomicRequestLock(this.loadAndAddLock);
        }
    }

    @Override
    public List<CDORevision> getRevisions(Collection<CDOID> ids, int referenceChunk) {
        ArrayList<CDOID> missingIDs = new ArrayList<CDOID>(0);
        ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(ids.size());
        for (CDOID id : ids) {
            InternalCDORevision revision = this.getRevision(id, referenceChunk, false);
            revisions.add(revision);
            if (revision != null) continue;
            missingIDs.add(id);
        }
        if (!missingIDs.isEmpty()) {
            this.acquireAtomicRequestLock(this.loadAndAddLock);
            try {
                List<InternalCDORevision> missingRevisions = this.loadRevisions(missingIDs, referenceChunk);
                this.handleMissingRevisions(revisions, missingRevisions);
            }
            finally {
                this.releaseAtomicRequestLock(this.loadAndAddLock);
            }
        }
        return revisions;
    }

    @Override
    public List<CDORevision> getRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp, boolean loadMissingRevisions) {
        ArrayList<CDOID> missingIDs = loadMissingRevisions ? new ArrayList<CDOID>(0) : null;
        ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(ids.size());
        for (CDOID id : ids) {
            InternalCDORevision revision = this.getRevisionByTime(id, referenceChunk, timeStamp, false);
            revisions.add(revision);
            if (revision != null || missingIDs == null) continue;
            missingIDs.add(id);
        }
        if (missingIDs != null && !missingIDs.isEmpty()) {
            this.acquireAtomicRequestLock(this.loadAndAddLock);
            try {
                List<InternalCDORevision> missingRevisions = this.loadRevisionsByTime(missingIDs, referenceChunk, timeStamp);
                this.handleMissingRevisions(revisions, missingRevisions);
            }
            finally {
                this.releaseAtomicRequestLock(this.loadAndAddLock);
            }
        }
        return revisions;
    }

    @Override
    public CDOID getResourceID(CDOID folderID, String name, long timeStamp) {
        return this.cache.getResourceID(folderID, name, timeStamp);
    }

    public List<CDORevision> getCachedRevisions() {
        return this.cache.getRevisions();
    }

    private void addCachedRevisionIfNotNull(InternalCDORevision revision) {
        if (revision != null) {
            this.cache.addRevision(revision);
        }
    }

    public boolean addCachedRevision(InternalCDORevision revision) {
        if (revision != null) {
            return this.cache.addRevision(revision);
        }
        throw new IllegalArgumentException("revision == null");
    }

    public void removeCachedRevision(CDOID id, int version) {
        this.cache.removeRevision(id, version);
    }

    public void clearCache() {
        this.cache.clear();
    }

    protected InternalCDORevision verifyRevision(InternalCDORevision revision, int referenceChunk) {
        return revision;
    }

    protected abstract InternalCDORevision loadRevision(CDOID var1, int var2);

    protected abstract InternalCDORevision loadRevisionByTime(CDOID var1, int var2, long var3);

    protected abstract InternalCDORevision loadRevisionByVersion(CDOID var1, int var2, int var3);

    protected abstract List<InternalCDORevision> loadRevisions(Collection<CDOID> var1, int var2);

    protected abstract List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> var1, int var2, long var3);

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.cache == null) {
            this.cache = CDORevisionCacheUtil.createDefaultCache();
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.cache);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.cache);
        super.doDeactivate();
    }

    protected void acquireAtomicRequestLock(Object lockObject) {
    }

    protected void releaseAtomicRequestLock(Object lockObject) {
    }

    private void handleMissingRevisions(List<CDORevision> revisions, List<InternalCDORevision> missingRevisions) {
        Iterator<InternalCDORevision> it = missingRevisions.iterator();
        int i = 0;
        while (i < revisions.size()) {
            CDORevision revision = revisions.get(i);
            if (revision == null) {
                InternalCDORevision missingRevision = it.next();
                revisions.set(i, missingRevision);
                this.addCachedRevisionIfNotNull(missingRevision);
            }
            ++i;
        }
    }
}

