/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.DssTrace;

class Session {
    protected static final int INIT = 1;
    protected static final int ATTEXC = 2;
    protected static final int SECACC = 3;
    protected static final int CHKSEC = 4;
    protected static final int CLOSED = 5;
    protected static final int DRDA_SESSION = 1;
    protected static final int CMD_SESSION = 2;
    private static final String TRACENAME_PREFIX = "Server";
    private static final String TRACENAME_SUFFIX = ".trace";
    protected Socket clientSocket;
    protected int connNum;
    protected InputStream sessionInput;
    protected OutputStream sessionOutput;
    protected String traceFileName;
    protected boolean traceOn;
    protected int state;
    protected int sessionType;
    protected String drdaID;
    protected DssTrace dssTrace;
    protected AppRequester appRequester;
    protected Database database;
    protected int qryinsid;
    protected LocalizedResource langUtil;
    private Hashtable dbtable;

    protected Session(int n, Socket socket, String string, boolean bl) throws IOException {
        this.connNum = n;
        this.clientSocket = socket;
        this.traceOn = bl;
        if (bl) {
            this.dssTrace = new DssTrace();
        }
        this.dbtable = new Hashtable();
        this.initialize(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws SQLException {
        try {
            try {
                this.sessionInput.close();
                this.sessionOutput.close();
                this.clientSocket.close();
                if (this.dbtable != null) {
                    Enumeration enumeration = this.dbtable.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Database)enumeration.nextElement()).close();
                    }
                }
                Object var3_3 = null;
                this.state = 5;
                this.dbtable = null;
                this.database = null;
            }
            catch (IOException iOException) {
                Object var3_4 = null;
                this.state = 5;
                this.dbtable = null;
                this.database = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.state = 5;
            this.dbtable = null;
            this.database = null;
            throw throwable;
        }
    }

    protected void initTrace(String string) {
        this.traceFileName = string != null ? string + "/" + TRACENAME_PREFIX + this.connNum + TRACENAME_SUFFIX : TRACENAME_PREFIX + this.connNum + TRACENAME_SUFFIX;
        this.traceOn = true;
        if (this.dssTrace == null) {
            this.dssTrace = new DssTrace();
        }
        this.dssTrace.startComBufferTrace(this.traceFileName);
    }

    protected void setTraceOn(String string) {
        if (this.traceOn) {
            return;
        }
        this.initTrace(string);
    }

    protected boolean isTraceOn() {
        return this.traceOn;
    }

    protected int getConnNum() {
        return this.connNum;
    }

    protected void setTraceOff() {
        if (!this.traceOn) {
            return;
        }
        this.traceOn = false;
        if (this.traceFileName != null) {
            this.dssTrace.stopComBufferTrace();
        }
    }

    protected void addDatabase(Database database) {
        this.dbtable.put(database.dbName, database);
    }

    protected Database getDatabase(String string) {
        return (Database)this.dbtable.get(string);
    }

    protected int getRequiredSecurityCodepoint() {
        switch (this.state) {
            case 2: {
                return 4205;
            }
            case 3: {
                return 4206;
            }
        }
        return -1;
    }

    protected boolean requiresSecurityCodepoint() {
        return this.getRequiredSecurityCodepoint() != -1;
    }

    protected void setState(int n) {
        this.state = n;
    }

    private void initialize(String string) throws IOException {
        this.sessionInput = this.clientSocket.getInputStream();
        this.sessionOutput = this.clientSocket.getOutputStream();
        if (this.traceOn) {
            this.initTrace(string);
        }
        this.state = 1;
    }

    protected String buildRuntimeInfo(String string, LocalizedResource localizedResource) {
        String string2 = "";
        string2 = string2 + string + localizedResource.getTextMessage("DRDA_RuntimeInfoSessionNumber.I") + this.connNum + "\n";
        if (this.database == null) {
            return string2;
        }
        string2 = string2 + this.database.buildRuntimeInfo(string, localizedResource);
        string2 = string2 + "\n";
        return string2;
    }

    private String getStateString(int n) {
        switch (n) {
            case 1: {
                return "INIT";
            }
            case 2: {
                return "ATTEXC";
            }
            case 5: {
                return "CLOSED";
            }
        }
        return "UNKNOWN_STATE";
    }

    private String getTypeString(int n) {
        switch (n) {
            case 1: {
                return "DRDA_SESSION";
            }
            case 2: {
                return "CMD_SESSION";
            }
        }
        return "UNKNOWN_TYPE";
    }
}

