/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultToStringUserType
implements UserType,
ParameterizedType {
    private static final int[] SQL_TYPES = new int[]{12};
    private EFactory eFactory;
    private EDataType eDataType;
    private EPackage.Registry registry = PackageRegistryProvider.getInstance().getPackageRegistry();

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return this.eDataType.getInstanceClass();
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) {
        String data = this.eFactory.convertToString(this.eDataType, value);
        return this.eFactory.createFromString(this.eDataType, data);
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass().isArray() && y.getClass().isArray()) {
            return this.equalArrays(x, y);
        }
        return x.equals(y);
    }

    private boolean equalArrays(Object os1, Object os2) {
        int l1 = Array.getLength(os1);
        if (l1 != Array.getLength(os2)) {
            return false;
        }
        int i = 0;
        while (i < l1) {
            Object o1 = Array.get(os1, i);
            Object o2 = Array.get(os2, i);
            if (o1 == null ? o2 != null : !o1.equals(o2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor sessionImplementor, Object owner) throws SQLException {
        String data = resultSet.getString(names[0]);
        if (data == null) {
            return null;
        }
        return this.eFactory.createFromString(this.eDataType, data);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index, SessionImplementor sessionImplementor) throws SQLException {
        String pvalue = null;
        if (value != null) {
            pvalue = this.eFactory.convertToString(this.eDataType, value);
        }
        if (pvalue != null) {
            statement.setString(index, pvalue);
        } else {
            statement.setNull(index, 12);
        }
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object assemble(Serializable cachedValue, Object owner) {
        return cachedValue;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }

    public void setParameterValues(Properties properties) {
        String ePackageNsUri = properties.getProperty("epackage");
        if (ePackageNsUri == null || ePackageNsUri.length() == 0) {
            throw new IllegalArgumentException("Could not find custom UserType property epackage");
        }
        EPackage epackage = this.registry.getEPackage(ePackageNsUri);
        if (epackage == null) {
            throw new IllegalArgumentException("Could not find ePackage using nsuri " + ePackageNsUri);
        }
        this.eFactory = epackage.getEFactoryInstance();
        String edatatypeName = properties.getProperty("edatatype");
        if (edatatypeName == null) {
            throw new IllegalArgumentException("Could not find custom UserType property edatatype");
        }
        EClassifier eclassifier = epackage.getEClassifier(edatatypeName);
        if (!(eclassifier instanceof EDataType)) {
            if (eclassifier == null) {
                throw new IllegalArgumentException("Missing attribute " + edatatypeName + " in package implementation " + epackage.getName());
            }
            throw new IllegalArgumentException("Found property of type " + eclassifier.getClass().getName() + " when an EDataType was expected.");
        }
        this.eDataType = (EDataType)eclassifier;
    }
}

