/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceFileProvider;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.hibernate.EMFInterceptor;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbEntityManagerWrapper;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.auditing.AuditProcessHandler;
import org.eclipse.emf.teneo.hibernate.mapper.MappingUtil;
import org.eclipse.emf.teneo.hibernate.mapping.EMFInitializeCollectionEventListener;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVGenericIDUserType;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.boot.internal.SettingsImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbEntityDataStore
extends HbDataStore
implements EntityManagerFactory {
    private static Log log = LogFactory.getLog(HbEntityDataStore.class);
    private EntityManagerFactory entityManagerFactory;
    private Configuration ejb3Configuration;
    private AuditProcessHandler auditProcessHandler;

    @Override
    public void initialize() {
        this.setAuditHandler(null);
        if (this.ejb3Configuration != null && this.isResetConfigurationOnInitialization()) {
            this.ejb3Configuration = null;
        }
        MappingUtil.registerHbExtensions((ExtensionManager)this.getExtensionManager());
        try {
            PackageRegistryProvider.getInstance().setThreadPackageRegistry(this.getPackageRegistry());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing EJB3 Hb Entity DataStore");
            }
            if (this.getEPackages() == null) {
                throw new HbMapperException("EPackages are not set");
            }
            this.setInterceptor(null);
            this.mapModel();
            this.setPropertiesInConfiguration();
            this.initializeDataStore();
            if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
                this.entityManagerFactory.close();
            }
            this.entityManagerFactory = this.buildEntityManagerFactory();
            HbHelper.INSTANCE.register(this);
            this.setInitialized(true);
            this.setEventListeners();
        }
        finally {
            PackageRegistryProvider.getInstance().setThreadPackageRegistry(null);
        }
    }

    @Override
    protected void buildMappings() {
        this.getConfiguration().buildMappings();
    }

    @Override
    protected void setEventListeners() {
        EMFInitializeCollectionEventListener eventListener = (EMFInitializeCollectionEventListener)((Object)this.getExtensionManager().getExtension(EMFInitializeCollectionEventListener.class));
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf instanceof WrappedEntityManagerFactory) {
            emf = ((WrappedEntityManagerFactory)emf).getDelegate();
        }
        ServiceRegistryImplementor serviceRegistry = ((EntityManagerFactoryImpl)emf).getSessionFactory().getServiceRegistry();
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.appendListeners(EventType.INIT_COLLECTION, (Object[])new InitializeCollectionEventListener[]{eventListener});
        if (this.isAuditing()) {
            this.auditProcessHandler = (AuditProcessHandler)this.getExtensionManager().getExtension(AuditProcessHandler.class);
            this.auditProcessHandler.setDataStore(this);
            eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{this.auditProcessHandler});
            eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{this.auditProcessHandler});
            eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{this.auditProcessHandler});
            eventListenerRegistry.appendListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{this.auditProcessHandler});
        }
    }

    @Override
    public AuditProcessHandler getAuditProcessHandler() {
        return this.auditProcessHandler;
    }

    @Override
    protected void setInterceptor() {
        if (this.getInterceptor() != null) {
            return;
        }
        Interceptor interceptor = this.getHbContext().createInterceptor(this.getHibernateConfiguration(), this.getEntityNameStrategy());
        if (interceptor instanceof EMFInterceptor) {
            ((EMFInterceptor)interceptor).setDataStore(this);
        }
        this.getConfiguration().setInterceptor(interceptor);
        this.setInterceptor(interceptor);
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected void setPropertiesInConfiguration() {
        Properties properties = this.getDataStoreProperties();
        if (properties != null) {
            this.setDefaultProperties(properties);
            if (!properties.containsKey("hibernate.ejb.metamodel.generation")) {
                properties.setProperty("hibernate.ejb.metamodel.generation", "disabled");
            }
            this.getConfiguration().addProperties(properties);
        }
    }

    protected void mapModel() {
        if (this.getPersistenceOptions().isUseMappingFile() || this.getPersistenceOptions().getMappingFilePath() != null) {
            String[] fileList;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Searching hbm files in class paths of epackages");
            }
            String[] stringArray = fileList = this.getMappingFileList();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                PersistenceFileProvider pfp;
                InputStream is;
                String element = stringArray[n2];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding file " + element + " to Hibernate Configuration"));
                }
                if ((is = (pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class)).getFileContent(this.getClass(), element)) == null) {
                    throw new HbStoreException("Path to mapping file: " + element + " does not exist!");
                }
                this.getConfiguration().addInputStream(is);
                ++n2;
            }
        } else {
            this.setMappingXML(this.mapEPackages());
            boolean hasEAVMapping = false;
            block3: for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
                for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                    if (aClass.getEavMapping() == null) continue;
                    hasEAVMapping = true;
                    continue block3;
                }
            }
            if (hasEAVMapping) {
                try {
                    InputStream is;
                    PersistenceFileProvider pfp;
                    if (this.getPersistenceOptions().getEAVMappingFile() != null) {
                        pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class);
                        is = pfp.getFileContent(this.getClass(), this.getPersistenceOptions().getEAVMappingFile());
                        this.getConfiguration().addInputStream(this.processEAV(is));
                        is.close();
                    } else {
                        pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class);
                        is = pfp.getFileContent(EAVGenericIDUserType.class, "eav.hbm.xml");
                        this.getConfiguration().addInputStream(this.processEAV(is));
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            StringBufferInputStream is = new StringBufferInputStream(this.getMappingXML());
            System.err.println(this.getMappingXML());
            this.getConfiguration().addInputStream((InputStream)is);
        }
    }

    protected InputStream processEAV(InputStream is) {
        return new StringBufferInputStream(this.processEAVMapping(is));
    }

    private void applyTransactionProperties(SettingsImpl settings) {
        PersistenceUnitTransactionType txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType((Object)this.getConfiguration().getProperty("javax.persistence.transactionType"));
        if (txnType == null) {
            txnType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        settings.setTransactionType(txnType);
    }

    protected EntityManagerFactory buildEntityManagerFactory() {
        SessionFactoryImpl sfi = (SessionFactoryImpl)this.getConfiguration().buildSessionFactory();
        SettingsImpl settings = new SettingsImpl();
        this.applyTransactionProperties(settings);
        EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl("teneo", (SessionFactoryImplementor)sfi, settings, (Map)this.getConfiguration().getProperties(), this.getConfiguration());
        return new WrappedEntityManagerFactory((EntityManagerFactory)emf);
    }

    @Override
    public void close() {
        if (this.isInitialized()) {
            if (this.getEntityManagerFactory().isOpen()) {
                this.getEntityManagerFactory().close();
            }
            this.entityManagerFactory = null;
            this.setInitialized(false);
            HbHelper.INSTANCE.deRegisterDataStore(this);
        }
        this.ejb3Configuration = null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        assert (this.entityManagerFactory != null);
        return this.entityManagerFactory;
    }

    @Override
    public SessionWrapper createSessionWrapper() {
        return new HbEntityManagerWrapper(this);
    }

    public Configuration getConfiguration() {
        if (this.ejb3Configuration == null) {
            this.ejb3Configuration = this.createConfiguration();
        }
        return this.ejb3Configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.ejb3Configuration = configuration;
    }

    @Override
    public Configuration getHibernateConfiguration() {
        return this.getConfiguration();
    }

    @Override
    public Iterator<?> getClassMappings() {
        return this.getConfiguration().getClassMappings();
    }

    @Override
    public SessionFactory getSessionFactory() {
        EntityManagerFactoryImpl entityManagerFactoryImpl = this.getEntityManagerFactory() instanceof WrappedEntityManagerFactory ? (EntityManagerFactoryImpl)((WrappedEntityManagerFactory)this.getEntityManagerFactory()).getDelegate() : (EntityManagerFactoryImpl)this.getEntityManagerFactory();
        return entityManagerFactoryImpl.getSessionFactory();
    }

    public EntityManager createEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }

    public EntityManager createEntityManager(Map arg0) {
        return this.getEntityManagerFactory().createEntityManager(arg0);
    }

    public boolean isOpen() {
        return this.getEntityManagerFactory().isOpen();
    }

    public Cache getCache() {
        return this.getEntityManagerFactory().getCache();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEntityManagerFactory().getMetamodel();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getEntityManagerFactory().getPersistenceUnitUtil();
    }

    public Map<String, Object> getProperties() {
        return this.getEntityManagerFactory().getProperties();
    }

    public <T> void addNamedEntityGraph(String arg0, EntityGraph<T> arg1) {
        this.getEntityManagerFactory().addNamedEntityGraph(arg0, arg1);
    }

    public void addNamedQuery(String arg0, Query arg1) {
        this.getEntityManagerFactory().addNamedQuery(arg0, arg1);
    }

    public EntityManager createEntityManager(SynchronizationType arg0) {
        return this.getEntityManagerFactory().createEntityManager(arg0);
    }

    public EntityManager createEntityManager(SynchronizationType arg0, Map arg1) {
        return this.getEntityManagerFactory().createEntityManager(arg0, arg1);
    }

    public <T> T unwrap(Class<T> arg0) {
        return (T)this.getEntityManagerFactory().unwrap(arg0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WrappedEntityManager
    implements EntityManager {
        private EntityManager delegateEntityManager;

        public WrappedEntityManager(EntityManager em) {
            this.delegateEntityManager = em;
        }

        public void clear() {
            this.delegateEntityManager.clear();
        }

        public void close() {
            if (this.delegateEntityManager.isOpen()) {
                this.delegateEntityManager.close();
            }
        }

        public boolean contains(Object arg0) {
            return this.delegateEntityManager.contains(arg0);
        }

        public <T> TypedQuery<T> createNamedQuery(String arg0, Class<T> arg1) {
            return this.delegateEntityManager.createNamedQuery(arg0, arg1);
        }

        public Query createNamedQuery(String arg0) {
            return this.delegateEntityManager.createNamedQuery(arg0);
        }

        public Query createNativeQuery(String arg0, Class arg1) {
            return this.delegateEntityManager.createNativeQuery(arg0, arg1);
        }

        public Query createNativeQuery(String arg0, String arg1) {
            return this.delegateEntityManager.createNativeQuery(arg0, arg1);
        }

        public Query createNativeQuery(String arg0) {
            return this.delegateEntityManager.createNativeQuery(arg0);
        }

        public <T> TypedQuery<T> createQuery(CriteriaQuery<T> arg0) {
            return this.delegateEntityManager.createQuery(arg0);
        }

        public <T> TypedQuery<T> createQuery(String arg0, Class<T> arg1) {
            return this.delegateEntityManager.createQuery(arg0, arg1);
        }

        public Query createQuery(String arg0) {
            return this.delegateEntityManager.createQuery(arg0);
        }

        public void detach(Object arg0) {
            this.delegateEntityManager.detach(arg0);
        }

        public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
            return (T)this.delegateEntityManager.find(arg0, arg1, arg2, arg3);
        }

        public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2) {
            return (T)this.delegateEntityManager.find(arg0, arg1, arg2);
        }

        public <T> T find(Class<T> arg0, Object arg1, Map<String, Object> arg2) {
            return (T)this.delegateEntityManager.find(arg0, arg1, arg2);
        }

        public <T> T find(Class<T> arg0, Object arg1) {
            return (T)this.delegateEntityManager.find(arg0, arg1);
        }

        public void flush() {
            this.delegateEntityManager.flush();
        }

        public CriteriaBuilder getCriteriaBuilder() {
            return this.delegateEntityManager.getCriteriaBuilder();
        }

        public Object getDelegate() {
            return this.delegateEntityManager.getDelegate();
        }

        public EntityManagerFactory getEntityManagerFactory() {
            return this.delegateEntityManager.getEntityManagerFactory();
        }

        public FlushModeType getFlushMode() {
            return this.delegateEntityManager.getFlushMode();
        }

        public LockModeType getLockMode(Object arg0) {
            return this.delegateEntityManager.getLockMode(arg0);
        }

        public Metamodel getMetamodel() {
            return this.delegateEntityManager.getMetamodel();
        }

        public Map<String, Object> getProperties() {
            return this.delegateEntityManager.getProperties();
        }

        public <T> T getReference(Class<T> arg0, Object arg1) {
            return (T)this.delegateEntityManager.getReference(arg0, arg1);
        }

        public EntityTransaction getTransaction() {
            return this.delegateEntityManager.getTransaction();
        }

        public boolean isOpen() {
            return this.delegateEntityManager.isOpen();
        }

        public void joinTransaction() {
            this.delegateEntityManager.joinTransaction();
        }

        public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
            this.delegateEntityManager.lock(arg0, arg1, arg2);
        }

        public void lock(Object arg0, LockModeType arg1) {
            this.delegateEntityManager.lock(arg0, arg1);
        }

        public <T> T merge(T arg0) {
            return (T)this.delegateEntityManager.merge(arg0);
        }

        public void persist(Object arg0) {
            this.delegateEntityManager.persist(arg0);
        }

        public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
            this.delegateEntityManager.refresh(arg0, arg1, arg2);
        }

        public void refresh(Object arg0, LockModeType arg1) {
            this.delegateEntityManager.refresh(arg0, arg1);
        }

        public void refresh(Object arg0, Map<String, Object> arg1) {
            this.delegateEntityManager.refresh(arg0, arg1);
        }

        public void refresh(Object arg0) {
            this.delegateEntityManager.refresh(arg0);
        }

        public void remove(Object arg0) {
            this.delegateEntityManager.remove(arg0);
        }

        public void setFlushMode(FlushModeType arg0) {
            this.delegateEntityManager.setFlushMode(arg0);
        }

        public void setProperty(String arg0, Object arg1) {
            this.delegateEntityManager.setProperty(arg0, arg1);
        }

        public <T> T unwrap(Class<T> arg0) {
            return (T)this.delegateEntityManager.unwrap(arg0);
        }

        public EntityManager getDelegateEntityManager() {
            return this.delegateEntityManager;
        }

        public void setDelegateEntityManager(EntityManager delegateEntityManager) {
            this.delegateEntityManager = delegateEntityManager;
        }

        public <T> EntityGraph<T> createEntityGraph(Class<T> arg0) {
            return this.delegateEntityManager.createEntityGraph(arg0);
        }

        public EntityGraph<?> createEntityGraph(String arg0) {
            return this.delegateEntityManager.createEntityGraph(arg0);
        }

        public StoredProcedureQuery createNamedStoredProcedureQuery(String arg0) {
            return this.delegateEntityManager.createNamedStoredProcedureQuery(arg0);
        }

        public Query createQuery(CriteriaUpdate arg0) {
            return this.delegateEntityManager.createQuery(arg0);
        }

        public Query createQuery(CriteriaDelete arg0) {
            return this.delegateEntityManager.createQuery(arg0);
        }

        public StoredProcedureQuery createStoredProcedureQuery(String arg0) {
            return this.delegateEntityManager.createStoredProcedureQuery(arg0);
        }

        public StoredProcedureQuery createStoredProcedureQuery(String arg0, Class ... arg1) {
            return this.delegateEntityManager.createStoredProcedureQuery(arg0, arg1);
        }

        public StoredProcedureQuery createStoredProcedureQuery(String arg0, String ... arg1) {
            return this.delegateEntityManager.createStoredProcedureQuery(arg0, arg1);
        }

        public EntityGraph<?> getEntityGraph(String arg0) {
            return this.delegateEntityManager.getEntityGraph(arg0);
        }

        public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> arg0) {
            return this.delegateEntityManager.getEntityGraphs(arg0);
        }

        public boolean isJoinedToTransaction() {
            return this.delegateEntityManager.isJoinedToTransaction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WrappedEntityManagerFactory
    implements EntityManagerFactory {
        private EntityManagerFactory delegate;

        public WrappedEntityManagerFactory(EntityManagerFactory emf) {
            this.delegate = emf;
        }

        public EntityManagerFactory getDelegate() {
            return this.delegate;
        }

        public void setDelegate(EntityManagerFactory delegate) {
            this.delegate = delegate;
        }

        public void close() {
            this.delegate.close();
        }

        public EntityManager createEntityManager() {
            EntityManager em = this.delegate.createEntityManager();
            return new WrappedEntityManager(em);
        }

        public EntityManager createEntityManager(Map map) {
            EntityManager em = this.delegate.createEntityManager(map);
            return new WrappedEntityManager(em);
        }

        public Cache getCache() {
            return this.delegate.getCache();
        }

        public CriteriaBuilder getCriteriaBuilder() {
            return this.delegate.getCriteriaBuilder();
        }

        public Metamodel getMetamodel() {
            return this.delegate.getMetamodel();
        }

        public PersistenceUnitUtil getPersistenceUnitUtil() {
            return this.delegate.getPersistenceUnitUtil();
        }

        public Map<String, Object> getProperties() {
            return this.delegate.getProperties();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public <T> void addNamedEntityGraph(String arg0, EntityGraph<T> arg1) {
            this.delegate.addNamedEntityGraph(arg0, arg1);
        }

        public void addNamedQuery(String arg0, Query arg1) {
            this.delegate.addNamedQuery(arg0, arg1);
        }

        public EntityManager createEntityManager(SynchronizationType arg0) {
            return this.delegate.createEntityManager(arg0);
        }

        public EntityManager createEntityManager(SynchronizationType arg0, Map arg1) {
            return this.delegate.createEntityManager(arg0, arg1);
        }

        public <T> T unwrap(Class<T> arg0) {
            return (T)this.delegate.unwrap(arg0);
        }
    }
}

