/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.resource;

import java.util.Hashtable;
import javax.jdo.PersistenceManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.jpox.JpoxDataStore;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;

public class PMController {
    private static Log log = LogFactory.getLog(PMController.class);
    private static Hashtable pmControllers = new Hashtable();
    protected PersistenceManager pm;
    protected JpoxDataStore jpoxDataStore;

    public static synchronized void registerPMController(String name, PMController sc) {
        if (pmControllers.get(name) != null) {
            throw new JpoxStoreException("There is already a pm controller registered with the name: " + name);
        }
        log.debug((Object)("Registering pm controller: " + name));
        pmControllers.put(name, sc);
    }

    public static synchronized void deRegisterPMController(String name) {
        if (pmControllers.get(name) == null) {
            throw new JpoxStoreException("There is no pm controller registered with the name: " + name);
        }
        log.debug((Object)("De-Registering pm controller: " + name));
        pmControllers.remove(name);
    }

    public static synchronized PMController getPMController(String name) {
        return (PMController)pmControllers.get(name);
    }

    public JpoxDataStore getJpoxDataStore() {
        return this.jpoxDataStore;
    }

    public void setJpoxDataStore(JpoxDataStore jpoxDataStore) {
        this.jpoxDataStore = jpoxDataStore;
    }

    public PersistenceManager getPM() {
        if (this.pm == null) {
            this.pm = this.jpoxDataStore.getPMF().getPersistenceManager();
        }
        return this.pm;
    }
}

