/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.tests.nodes.NodeEnum;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class IndividualMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void testAttributeMonoChange2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMonoChangeLeft();
        Resource right = this.input.getAttributeMonoChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoChange2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMonoChangeLeft();
        Resource right = this.input.getAttributeMonoChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"originValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoChange3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoChangeLeft();
        Resource right = this.input.getAttributeMonoChangeRight();
        Resource origin = this.input.getAttributeMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMonoChange2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMonoEEnumChangeLeft();
        Resource right = this.input.getAttributeMonoEEnumChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singlevalueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root", (String)"singlevalueEEnumAttribute", (Object)((Object)NodeEnum.A), (Object)((Object)NodeEnum.B))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)((Object)NodeEnum.B), (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMonoChange2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMonoEEnumChangeLeft();
        Resource right = this.input.getAttributeMonoEEnumChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singlevalueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root", (String)"singlevalueEEnumAttribute", (Object)((Object)NodeEnum.A), (Object)((Object)NodeEnum.B))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)((Object)NodeEnum.A), (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMonoChange3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoEEnumChangeLeft();
        Resource right = this.input.getAttributeMonoEEnumChangeRight();
        Resource origin = this.input.getAttributeMonoEEnumChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singlevalueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root", (String)"singlevalueEEnumAttribute", (Object)((Object)NodeEnum.A), (Object)((Object)NodeEnum.B))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)((Object)NodeEnum.B), (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMonoChange3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoEEnumChangeLeft();
        Resource right = this.input.getAttributeMonoEEnumChangeRight();
        Resource origin = this.input.getAttributeMonoEEnumChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singlevalueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root", (String)"singlevalueEEnumAttribute", (Object)((Object)NodeEnum.A), (Object)((Object)NodeEnum.B))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)((Object)NodeEnum.A), (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMonoChange3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoEEnumChangeRight();
        Resource right = this.input.getAttributeMonoEEnumChangeLeft();
        Resource origin = this.input.getAttributeMonoEEnumChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singlevalueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root", (String)"singlevalueEEnumAttribute", (Object)((Object)NodeEnum.A), (Object)((Object)NodeEnum.B))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)((Object)NodeEnum.A), (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMonoChange3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoEEnumChangeRight();
        Resource right = this.input.getAttributeMonoEEnumChangeLeft();
        Resource origin = this.input.getAttributeMonoEEnumChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singlevalueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root", (String)"singlevalueEEnumAttribute", (Object)((Object)NodeEnum.A), (Object)((Object)NodeEnum.B))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)((Object)NodeEnum.B), (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoChange3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoChangeLeft();
        Resource right = this.input.getAttributeMonoChangeRight();
        Resource origin = this.input.getAttributeMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"originValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoChange3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoChangeRight();
        Resource right = this.input.getAttributeMonoChangeLeft();
        Resource origin = this.input.getAttributeMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"originValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoChange3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoChangeRight();
        Resource right = this.input.getAttributeMonoChangeLeft();
        Resource origin = this.input.getAttributeMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoSet2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMonoSetLeft();
        Resource right = this.input.getAttributeMonoSetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", null, (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoSet2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMonoSetLeft();
        Resource right = this.input.getAttributeMonoSetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", null, (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoSet3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoSetLeft();
        Resource right = this.input.getAttributeMonoSetRight();
        Resource origin = this.input.getAttributeMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", null, (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoSet3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoSetLeft();
        Resource right = this.input.getAttributeMonoSetRight();
        Resource origin = this.input.getAttributeMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", null, (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoSet3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoSetRight();
        Resource right = this.input.getAttributeMonoSetLeft();
        Resource origin = this.input.getAttributeMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", null, (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoSet3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoSetRight();
        Resource right = this.input.getAttributeMonoSetLeft();
        Resource origin = this.input.getAttributeMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", null, (Object)"leftValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoUnset2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMonoUnsetLeft();
        Resource right = this.input.getAttributeMonoUnsetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoUnset2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMonoUnsetLeft();
        Resource right = this.input.getAttributeMonoUnsetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"originValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoUnset3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoUnsetLeft();
        Resource right = this.input.getAttributeMonoUnsetRight();
        Resource origin = this.input.getAttributeMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoUnset3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoUnsetLeft();
        Resource right = this.input.getAttributeMonoUnsetRight();
        Resource origin = this.input.getAttributeMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"originValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoUnset3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMonoUnsetRight();
        Resource right = this.input.getAttributeMonoUnsetLeft();
        Resource origin = this.input.getAttributeMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"originValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMonoUnset3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMonoUnsetRight();
        Resource right = this.input.getAttributeMonoUnsetLeft();
        Resource origin = this.input.getAttributeMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMultiAdd2WayLtR() throws IOException {
        Resource left = this.input.getAttributeEEnumMultiAddLeft();
        Resource right = this.input.getAttributeEEnumMultiAddRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        String featureName = "multiValueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.A))));
        Diff diff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.B))));
        Diff diff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.C))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff2).copyLeftToRight(diff2, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff3).copyLeftToRight(diff3, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof List));
        Assert.assertEquals((Object)featureValue, (Object)Lists.newArrayList((Object[])new NodeEnum[]{NodeEnum.A, NodeEnum.B, NodeEnum.C}));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMultiAdd2WayRtL() throws IOException {
        Resource left = this.input.getAttributeEEnumMultiAddLeft();
        Resource right = this.input.getAttributeEEnumMultiAddRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        String featureName = "multiValueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.A))));
        Diff diff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.B))));
        Diff diff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.C))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff2).copyRightToLeft(diff2, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff3).copyRightToLeft(diff3, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMultiAdd3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeEEnumMultiAddLeft();
        Resource right = this.input.getAttributeEEnumMultiAddRight();
        Resource origin = this.input.getAttributeEEnumMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        String featureName = "multiValueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.A))));
        Diff diff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.B))));
        Diff diff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.C))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff2).copyLeftToRight(diff2, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff3).copyLeftToRight(diff3, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).containsAll(Lists.newArrayList((Object[])new NodeEnum[]{NodeEnum.A, NodeEnum.B, NodeEnum.C})));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMultiAdd3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeEEnumMultiAddLeft();
        Resource right = this.input.getAttributeEEnumMultiAddRight();
        Resource origin = this.input.getAttributeEEnumMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        String featureName = "multiValueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.A))));
        Diff diff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.B))));
        Diff diff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.C))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff2).copyRightToLeft(diff2, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff3).copyRightToLeft(diff3, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).isEmpty());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMultiAdd3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeEEnumMultiAddRight();
        Resource right = this.input.getAttributeEEnumMultiAddLeft();
        Resource origin = this.input.getAttributeEEnumMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        String featureName = "multiValueEEnumAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.A))));
        Diff diff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.B))));
        Diff diff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.C))));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff2).copyLeftToRight(diff2, (Monitor)new BasicMonitor());
        this.mergerRegistry.getHighestRankingMerger(diff3).copyLeftToRight(diff3, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).isEmpty());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeEEnumMultiAdd3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiAddRight();
        Resource right = this.input.getAttributeMultiAddLeft();
        Resource origin = this.input.getAttributeMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiAdd2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMultiAddLeft();
        Resource right = this.input.getAttributeMultiAddRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiAdd2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMultiAddLeft();
        Resource right = this.input.getAttributeMultiAddRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiAdd3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMultiAddLeft();
        Resource right = this.input.getAttributeMultiAddRight();
        Resource origin = this.input.getAttributeMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiAdd3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiAddLeft();
        Resource right = this.input.getAttributeMultiAddRight();
        Resource origin = this.input.getAttributeMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiAdd3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMultiAddRight();
        Resource right = this.input.getAttributeMultiAddLeft();
        Resource origin = this.input.getAttributeMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiAdd3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiAddRight();
        Resource right = this.input.getAttributeMultiAddLeft();
        Resource origin = this.input.getAttributeMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiDel2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMultiDelLeft();
        Resource right = this.input.getAttributeMultiDelRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiDel2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMultiDelLeft();
        Resource right = this.input.getAttributeMultiDelRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiDel3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMultiDelLeft();
        Resource right = this.input.getAttributeMultiDelRight();
        Resource origin = this.input.getAttributeMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains("value1"));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiDel3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiDelLeft();
        Resource right = this.input.getAttributeMultiDelRight();
        Resource origin = this.input.getAttributeMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiDel3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMultiDelRight();
        Resource right = this.input.getAttributeMultiDelLeft();
        Resource origin = this.input.getAttributeMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removedFromAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains("value1"));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiDel3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiDelRight();
        Resource right = this.input.getAttributeMultiDelLeft();
        Resource origin = this.input.getAttributeMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removedFromAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains("value1"));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiMove2WayLtR() throws IOException {
        Resource left = this.input.getAttributeMultiMoveLeft();
        Resource right = this.input.getAttributeMultiMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents((List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiMove2WayRtL() throws IOException {
        Resource left = this.input.getAttributeMultiMoveLeft();
        Resource right = this.input.getAttributeMultiMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents((List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiMove3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMultiMoveLeft();
        Resource right = this.input.getAttributeMultiMoveRight();
        Resource origin = this.input.getAttributeMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents((List)targetFeatureValue, (List)sourceFeatureValue);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiMove3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiMoveLeft();
        Resource right = this.input.getAttributeMultiMoveRight();
        Resource origin = this.input.getAttributeMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(origin, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents((List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiMove3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getAttributeMultiMoveRight();
        Resource right = this.input.getAttributeMultiMoveLeft();
        Resource origin = this.input.getAttributeMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.movedInAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(origin, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents((List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testAttributeMultiMove3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getAttributeMultiMoveRight();
        Resource right = this.input.getAttributeMultiMoveLeft();
        Resource origin = this.input.getAttributeMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.movedInAttribute((String)"root.origin", (String)"multiValuedAttribute", (Object)"value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents((List)targetFeatureValue, (List)sourceFeatureValue);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeft();
        Resource right = this.input.getReferenceMonoChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.originValue", (String)"root.targetValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "targetValue");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeft();
        Resource right = this.input.getReferenceMonoChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.originValue", (String)"root.targetValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "originValue");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeft();
        Resource right = this.input.getReferenceMonoChangeRight();
        Resource origin = this.input.getReferenceMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.originValue", (String)"root.targetValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "targetValue");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeft();
        Resource right = this.input.getReferenceMonoChangeRight();
        Resource origin = this.input.getReferenceMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.originValue", (String)"root.targetValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "originValue");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoChangeRight();
        Resource right = this.input.getReferenceMonoChangeLeft();
        Resource origin = this.input.getReferenceMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.originValue", (String)"root.targetValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "originValue");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoChangeRight();
        Resource right = this.input.getReferenceMonoChangeLeft();
        Resource origin = this.input.getReferenceMonoChangeOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.originValue", (String)"root.targetValue")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "targetValue");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeft();
        Resource right = this.input.getReferenceMonoSetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", null, (String)"root.left")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "left");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeft();
        Resource right = this.input.getReferenceMonoSetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", null, (String)"root.left")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeft();
        Resource right = this.input.getReferenceMonoSetRight();
        Resource origin = this.input.getReferenceMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", null, (String)"root.left")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "left");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeft();
        Resource right = this.input.getReferenceMonoSetRight();
        Resource origin = this.input.getReferenceMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", null, (String)"root.left")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoSetRight();
        Resource right = this.input.getReferenceMonoSetLeft();
        Resource origin = this.input.getReferenceMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", null, (String)"root.left")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoSetRight();
        Resource right = this.input.getReferenceMonoSetLeft();
        Resource origin = this.input.getReferenceMonoSetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", null, (String)"root.left")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "left");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeft();
        Resource right = this.input.getReferenceMonoUnsetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.target", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeft();
        Resource right = this.input.getReferenceMonoUnsetRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.target", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeft();
        Resource right = this.input.getReferenceMonoUnsetRight();
        Resource origin = this.input.getReferenceMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.target", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeft();
        Resource right = this.input.getReferenceMonoUnsetRight();
        Resource origin = this.input.getReferenceMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.target", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetRight();
        Resource right = this.input.getReferenceMonoUnsetLeft();
        Resource origin = this.input.getReferenceMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.target", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertSame((Object)targetNode, (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetRight();
        Resource right = this.input.getReferenceMonoUnsetLeft();
        Resource origin = this.input.getReferenceMonoUnsetOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.origin", (String)"singleValuedReference", (String)"root.target", null)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        Assert.assertNull((Object)originNode.eGet(feature));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMultiAddLeft();
        Resource right = this.input.getReferenceMultiAddRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMultiAddLeft();
        Resource right = this.input.getReferenceMultiAddRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiAddLeft();
        Resource right = this.input.getReferenceMultiAddRight();
        Resource origin = this.input.getReferenceMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains(targetNode));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiAddLeft();
        Resource right = this.input.getReferenceMultiAddRight();
        Resource origin = this.input.getReferenceMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiAddRight();
        Resource right = this.input.getReferenceMultiAddLeft();
        Resource origin = this.input.getReferenceMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiAddRight();
        Resource right = this.input.getReferenceMultiAddLeft();
        Resource origin = this.input.getReferenceMultiAddOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.addedToReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains(targetNode));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMultiDelLeft();
        Resource right = this.input.getReferenceMultiDelRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMultiDelLeft();
        Resource right = this.input.getReferenceMultiDelRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiDelLeft();
        Resource right = this.input.getReferenceMultiDelRight();
        Resource origin = this.input.getReferenceMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains(targetNode));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiDelLeft();
        Resource right = this.input.getReferenceMultiDelRight();
        Resource origin = this.input.getReferenceMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removedFromReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiDelRight();
        Resource right = this.input.getReferenceMultiDelLeft();
        Resource origin = this.input.getReferenceMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removedFromReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(right, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).contains(targetNode));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiDelRight();
        Resource right = this.input.getReferenceMultiDelLeft();
        Resource origin = this.input.getReferenceMultiDelOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removedFromReference((String)"root.origin", (String)"multiValuedReference", (String)"root.target")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject originNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)originNode);
        EObject targetNode = this.getNodeNamed(left, "target");
        Assert.assertNotNull((Object)targetNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object featureValue = originNode.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertFalse((boolean)((Collection)featureValue).contains(targetNode));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeft();
        Resource right = this.input.getReferenceMultiMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInReference((String)"root.origin", (String)"multiValuedReference", (String)"root.value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents(comparison, (List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeft();
        Resource right = this.input.getReferenceMultiMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInReference((String)"root.origin", (String)"multiValuedReference", (String)"root.value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents(comparison, (List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeft();
        Resource right = this.input.getReferenceMultiMoveRight();
        Resource origin = this.input.getReferenceMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInReference((String)"root.origin", (String)"multiValuedReference", (String)"root.value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents(comparison, (List)targetFeatureValue, (List)sourceFeatureValue);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeft();
        Resource right = this.input.getReferenceMultiMoveRight();
        Resource origin = this.input.getReferenceMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.movedInReference((String)"root.origin", (String)"multiValuedReference", (String)"root.value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(origin, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents(comparison, (List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiMoveRight();
        Resource right = this.input.getReferenceMultiMoveLeft();
        Resource origin = this.input.getReferenceMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.movedInReference((String)"root.origin", (String)"multiValuedReference", (String)"root.value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(origin, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents(comparison, (List)targetFeatureValue, (List)sourceFeatureValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiMoveRight();
        Resource right = this.input.getReferenceMultiMoveLeft();
        Resource origin = this.input.getReferenceMultiMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.movedInReference((String)"root.origin", (String)"multiValuedReference", (String)"root.value1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(left, "origin");
        Assert.assertNotNull((Object)targetNode);
        EObject sourceNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)sourceNode);
        EStructuralFeature feature = targetNode.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        Object targetFeatureValue = targetNode.eGet(feature);
        Object sourceFeatureValue = sourceNode.eGet(feature);
        Assert.assertTrue((boolean)(targetFeatureValue instanceof List));
        Assert.assertTrue((boolean)(sourceFeatureValue instanceof List));
        IndividualMergeTest.assertEqualContents(comparison, (List)targetFeatureValue, (List)sourceFeatureValue);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceContainmentMultiMove2WayLtR() throws IOException {
        Resource left = this.input.getReferenceContainmentMultiMoveLeft();
        Resource right = this.input.getReferenceContainmentMultiMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "containmentRef1";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.moved((String)"root.value2", (String)"containmentRef1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "value2");
        Assert.assertNotNull((Object)targetNode);
        EObject targetContainerNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)targetContainerNode);
        Assert.assertEquals((Object)targetContainerNode, (Object)targetNode.eContainer());
        EObject sourceNode = this.getNodeNamed(left, "value2");
        Assert.assertNotNull((Object)sourceNode);
        EObject sourceContainerNode = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)sourceContainerNode);
        Assert.assertEquals((Object)sourceContainerNode, (Object)sourceNode.eContainer());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceContainmentMultiMove2WayRtL() throws IOException {
        Resource left = this.input.getReferenceContainmentMultiMoveLeft();
        Resource right = this.input.getReferenceContainmentMultiMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "containmentRef1";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.moved((String)"root.value2", (String)"containmentRef1")));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject targetNode = this.getNodeNamed(right, "value2");
        Assert.assertNotNull((Object)targetNode);
        EObject targetContainerNode = this.getNodeNamed(right, "value3");
        Assert.assertNotNull((Object)targetContainerNode);
        Assert.assertEquals((Object)targetContainerNode, (Object)targetNode.eContainer());
        EObject sourceNode = this.getNodeNamed(left, "value2");
        Assert.assertNotNull((Object)sourceNode);
        EObject sourceContainerNode = this.getNodeNamed(left, "value3");
        Assert.assertNotNull((Object)sourceContainerNode);
        Assert.assertEquals((Object)sourceContainerNode, (Object)sourceNode.eContainer());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceDifferentContainmentMove3Way() throws IOException {
        Resource left = this.input.getReferenceDifferentContainmentMoveLeft();
        Resource right = this.input.getReferenceDifferentContainmentMoveRight();
        Resource origin = this.input.getReferenceDifferentContainmentMoveOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        for (Diff diff : differences) {
            this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        }
        scope = new DefaultComparisonScope((Notifier)right, (Notifier)origin, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    private static <T> void assertEqualContents(List<T> list1, List<T> list2) {
        int size = list1.size();
        Assert.assertEquals((long)size, (long)list2.size());
        int i = 0;
        while (i < size) {
            T object1 = list1.get(i);
            T object2 = list2.get(i);
            Assert.assertEquals(object1, object2);
            ++i;
        }
    }

    private static <T extends EObject> void assertEqualContents(Comparison comparison, List<T> list1, List<T> list2) {
        int size = list1.size();
        Assert.assertEquals((long)size, (long)list2.size());
        boolean list2IsOrigin = false;
        int i = 0;
        while (i < size) {
            EObject eObject1 = (EObject)list1.get(i);
            EObject eObject2 = (EObject)list2.get(i);
            Match match = comparison.getMatch(eObject1);
            if (match.getLeft() == eObject1) {
                if (i == 0) {
                    if (match.getOrigin() == eObject2) {
                        list2IsOrigin = true;
                    } else {
                        Assert.assertSame((Object)match.getRight(), (Object)eObject2);
                    }
                } else if (list2IsOrigin) {
                    Assert.assertSame((Object)match.getOrigin(), (Object)eObject2);
                } else {
                    Assert.assertSame((Object)match.getRight(), (Object)eObject2);
                }
            } else {
                Assert.assertSame((Object)match.getRight(), (Object)eObject1);
                if (i == 0) {
                    if (match.getOrigin() == eObject2) {
                        list2IsOrigin = true;
                    } else {
                        Assert.assertSame((Object)match.getLeft(), (Object)eObject2);
                    }
                } else if (list2IsOrigin) {
                    Assert.assertSame((Object)match.getOrigin(), (Object)eObject2);
                } else {
                    Assert.assertSame((Object)match.getLeft(), (Object)eObject2);
                }
            }
            ++i;
        }
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

