/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.SubMatchIterator;

public class DiffTreeIterator
implements Iterator<Diff> {
    private final TreeIterator<Match> subMatchIterator;
    private Iterator<Diff> diffIterator;
    private Match current;
    private Diff nextDiff;
    private Predicate<? super Diff> filter = Predicates.alwaysTrue();
    private Predicate<? super Match> pruningFilter = Predicates.alwaysFalse();

    public DiffTreeIterator(Match start) {
        this.current = start;
        this.subMatchIterator = new SubMatchIterator(start);
        this.diffIterator = start.getDifferences().iterator();
    }

    public void setFilter(Predicate<? super Diff> filter) {
        this.filter = filter;
    }

    public void setPruningFilter(Predicate<? super Match> pruningFilter) {
        this.pruningFilter = pruningFilter;
    }

    @Override
    public boolean hasNext() {
        if (this.nextDiff != null) {
            return true;
        }
        if (!this.diffIterator.hasNext()) {
            this.computeNextMatch();
        }
        while (this.nextDiff == null && this.diffIterator.hasNext()) {
            Diff next = this.diffIterator.next();
            if (!this.filter.apply((Object)next)) continue;
            this.nextDiff = next;
        }
        return this.nextDiff != null;
    }

    private void computeNextMatch() {
        Match old = this.current;
        while (this.current == old && this.subMatchIterator.hasNext()) {
            Match next = (Match)this.subMatchIterator.next();
            if (this.pruningFilter.apply((Object)next)) {
                this.subMatchIterator.prune();
                continue;
            }
            this.current = next;
            this.diffIterator = this.current.getDifferences().iterator();
        }
    }

    @Override
    public Diff next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Diff next = this.nextDiff;
        this.nextDiff = null;
        return next;
    }

    @Override
    public void remove() {
        this.diffIterator.remove();
    }
}

