/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.edit.provider;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.uml2.internal.provider.decorator.ForwardingItemProviderAdapterDecorator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.junit.Assert;

public class StereotypedElementItemProviderTestUtil {
    private static final Function<Stereotype, String> TO_NAME_FUNCTION = new Function<Stereotype, String>(){

        public String apply(Stereotype input) {
            return input.getName();
        }
    };

    public static void checkIconAndLabel(AdapterFactory stereotypedElementItemProviderDecorator, HashMap<String, String> expectedStaticIcons, Resource resource) {
        TreeIterator resourceContentIterator = resource.getAllContents();
        while (resourceContentIterator.hasNext()) {
            EObject eObject = (EObject)resourceContentIterator.next();
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)stereotypedElementItemProviderDecorator.adapt((Notifier)eObject, IItemLabelProvider.class);
            if (!(eObject instanceof Element)) continue;
            if (!((Element)eObject).getAppliedStereotypes().isEmpty()) {
                Element element = (Element)eObject;
                EList appliedStereotypes = element.getAppliedStereotypes();
                String expectedLabel = StereotypedElementItemProviderTestUtil.buildExpectedLabelOnStereotypedElement((List<Stereotype>)appliedStereotypes, element);
                Assert.assertEquals((Object)expectedLabel, (Object)itemLabelProvider.getText((Object)eObject));
                List<String> actualIcons = StereotypedElementItemProviderTestUtil.getIconsLocation(itemLabelProvider.getImage((Object)eObject));
                Assert.assertEquals((long)1L, (long)actualIcons.size());
                Assert.assertEquals((String)("Wrong icon for stereotypes :" + StereotypedElementItemProviderTestUtil.generateExpectedIconKey((List<Stereotype>)appliedStereotypes)), (Object)StereotypedElementItemProviderTestUtil.getExpectedIcon((List<Stereotype>)appliedStereotypes, expectedStaticIcons), (Object)actualIcons.get(0));
                continue;
            }
            Assert.assertNotNull((Object)itemLabelProvider);
            Assert.assertTrue((String)("Wrong item provider for object " + itemLabelProvider.getText((Object)eObject)), (boolean)(itemLabelProvider instanceof ForwardingItemProviderAdapterDecorator));
        }
    }

    private static String getExpectedIcon(List<Stereotype> stereotypes, Map<String, String> expectedIconsMap) {
        return expectedIconsMap.get(StereotypedElementItemProviderTestUtil.generateExpectedIconKey(stereotypes));
    }

    private static String generateExpectedIconKey(List<Stereotype> stereotypes) {
        return Joiner.on((char)',').join(Iterables.transform(stereotypes, TO_NAME_FUNCTION));
    }

    public static List<String> getIconsLocation(Object icon) {
        ArrayList result = Lists.newArrayList();
        if (icon instanceof ComposedImage) {
            for (Object image : ((ComposedImage)icon).getImages()) {
                result.addAll(StereotypedElementItemProviderTestUtil.getIconsLocation(image));
            }
        } else if (icon instanceof URL) {
            String file = ((URL)icon).getFile();
            String[] segment = file.split("/");
            result.add(segment[segment.length - 1]);
        }
        return result;
    }

    private static String buildExpectedLabelOnStereotypedElement(List<Stereotype> stereotypes, Element elem) {
        StringBuilder labelBuilder = new StringBuilder();
        String stereotypesLabel = Joiner.on((char)',').join(Iterables.transform(stereotypes, TO_NAME_FUNCTION));
        labelBuilder.append('<').append(stereotypesLabel).append('>');
        if (elem instanceof NamedElement) {
            labelBuilder.append(' ').append(((NamedElement)elem).getName());
        }
        return labelBuilder.toString();
    }
}

