/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.association;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.AssociationChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.association.data.AssociationInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChangeAssociationTest
extends AbstractUMLTest {
    private AssociationInputData input = new AssociationInputData();

    @BeforeClass
    public static void setupClass() {
        ChangeAssociationTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        ChangeAssociationTest.resetRegistries();
    }

    @Test
    public void testA20UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLA20UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRA20UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA21UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLA21UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testMergeLtRA21UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA20UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLA20UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRA20UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA21UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLA21UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testMergeLtRA21UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)8L, (long)differences.size());
        Predicate addPropertyClass2Description = null;
        Predicate addRefAssociationInPropertyClass2Description = null;
        Predicate addRefTypeInPropertyClass2Description = null;
        Predicate<? super Diff> addLiteralIntegerInClass2Description = null;
        Predicate<? super Diff> addUnlimitedNaturalInClass2Description = null;
        Predicate addPropertyClass2InAssociationDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addPropertyClass2Description = EMFComparePredicates.removedFromReference((String)"model.class1_class0_0", (String)"ownedEnd", (String)"model.class1_class0_0.Class2");
            addRefAssociationInPropertyClass2Description = EMFComparePredicates.changedReference((String)"model.class1_class0_0.Class2", (String)"association", (String)"model.class1_class0_0", null);
            addRefTypeInPropertyClass2Description = EMFComparePredicates.changedReference((String)"model.class1_class0_0.Class2", (String)"type", (String)"model.Class2", null);
            addLiteralIntegerInClass2Description = ChangeAssociationTest.removedLowerValueIn("model.class1_class0_0.Class2");
            addUnlimitedNaturalInClass2Description = ChangeAssociationTest.removedUpperValueIn("model.class1_class0_0.Class2");
            addPropertyClass2InAssociationDescription = EMFComparePredicates.removedFromReference((String)"model.class1_class0_0", (String)"memberEnd", (String)"model.class1_class0_0.Class2");
        } else {
            addPropertyClass2Description = EMFComparePredicates.addedToReference((String)"model.class1_class0_0", (String)"ownedEnd", (String)"model.class1_class0_0.Class2");
            addRefAssociationInPropertyClass2Description = EMFComparePredicates.changedReference((String)"model.class1_class0_0.Class2", (String)"association", null, (String)"model.class1_class0_0");
            addRefTypeInPropertyClass2Description = EMFComparePredicates.changedReference((String)"model.class1_class0_0.Class2", (String)"type", null, (String)"model.Class2");
            addLiteralIntegerInClass2Description = ChangeAssociationTest.addedLowerValueIn("model.class1_class0_0.Class2");
            addUnlimitedNaturalInClass2Description = ChangeAssociationTest.addedUpperValueIn("model.class1_class0_0.Class2");
            addPropertyClass2InAssociationDescription = EMFComparePredicates.addedToReference((String)"model.class1_class0_0", (String)"memberEnd", (String)"model.class1_class0_0.Class2");
        }
        Diff addPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addPropertyClass2Description);
        Diff addRefAssociationInPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefAssociationInPropertyClass2Description);
        Diff addRefTypeInPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefTypeInPropertyClass2Description);
        Diff addLiteralIntegerInClass2 = (Diff)Iterators.find(differences.iterator(), addLiteralIntegerInClass2Description);
        Diff addUnlimitedNaturalInClass2 = (Diff)Iterators.find(differences.iterator(), addUnlimitedNaturalInClass2Description);
        Diff addPropertyClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addPropertyClass2InAssociationDescription);
        Assert.assertNotNull((Object)addPropertyClass2);
        Assert.assertNotNull((Object)addRefAssociationInPropertyClass2);
        Assert.assertNotNull((Object)addRefTypeInPropertyClass2);
        Assert.assertNotNull((Object)addLiteralIntegerInClass2);
        Assert.assertNotNull((Object)addUnlimitedNaturalInClass2);
        Assert.assertNotNull((Object)addPropertyClass2InAssociation);
        Assert.assertEquals((long)0L, (long)ChangeAssociationTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(AssociationChange.class)));
        Diff changeUMLAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(AssociationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)), null);
        Assert.assertNull((Object)changeUMLAssociation);
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addPropertyClass2.getRequires().size());
            Assert.assertEquals((long)1L, (long)addRefAssociationInPropertyClass2.getRequires().size());
            Assert.assertTrue((boolean)addRefAssociationInPropertyClass2.getRequires().contains((Object)addPropertyClass2));
            Assert.assertEquals((long)1L, (long)addRefTypeInPropertyClass2.getRequires().size());
            Assert.assertTrue((boolean)addRefTypeInPropertyClass2.getRequires().contains((Object)addPropertyClass2));
            Assert.assertEquals((long)1L, (long)addLiteralIntegerInClass2.getRequires().size());
            Assert.assertTrue((boolean)addLiteralIntegerInClass2.getRequires().contains((Object)addPropertyClass2));
            Assert.assertEquals((long)1L, (long)addUnlimitedNaturalInClass2.getRequires().size());
            Assert.assertTrue((boolean)addUnlimitedNaturalInClass2.getRequires().contains((Object)addPropertyClass2));
        } else {
            Assert.assertEquals((long)5L, (long)addPropertyClass2.getRequires().size());
            Assert.assertTrue((boolean)addPropertyClass2.getRequires().contains((Object)addLiteralIntegerInClass2));
            Assert.assertTrue((boolean)addPropertyClass2.getRequires().contains((Object)addUnlimitedNaturalInClass2));
            Assert.assertTrue((boolean)addPropertyClass2.getRequires().contains((Object)addRefAssociationInPropertyClass2));
            Assert.assertTrue((boolean)addPropertyClass2.getRequires().contains((Object)addRefTypeInPropertyClass2));
            Assert.assertTrue((boolean)addPropertyClass2.getRequires().contains((Object)addPropertyClass2InAssociation));
            Assert.assertEquals((long)0L, (long)addRefAssociationInPropertyClass2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefTypeInPropertyClass2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addLiteralIntegerInClass2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUnlimitedNaturalInClass2.getRequires().size());
        }
        this.testIntersections(comparison);
    }

    private static Predicate<? super Diff> addedLowerValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"lowerValue")});
    }

    private static Predicate<? super Diff> addedUpperValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"upperValue")});
    }

    private static Predicate<? super Diff> removedLowerValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"lowerValue")});
    }

    private static Predicate<? super Diff> removedUpperValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"upperValue")});
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

