/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.framework;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.tests.framework.AbstractMatchValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.junit.Assert;

public class IdentifierMatchValidator
extends AbstractMatchValidator {
    private Map<String, Match> idToMatch = Maps.newHashMap();

    @Override
    public void validate(Comparison comparison) {
        super.validate(comparison);
        this.idToMatch.clear();
    }

    @Override
    protected void validateMatch(Match match) {
        EObject left = match.getLeft();
        EObject right = match.getRight();
        EObject origin = match.getOrigin();
        String referenceID = left != null ? this.getID(left) : (right != null ? this.getID(right) : this.getID(origin));
        Assert.assertFalse((boolean)this.idToMatch.containsKey(referenceID));
        this.idToMatch.put(referenceID, match);
        if (left != null && right != null && origin != null) {
            Assert.assertEquals((Object)this.getID(left), (Object)this.getID(right));
            Assert.assertEquals((Object)this.getID(left), (Object)this.getID(origin));
        } else if (left != null && right != null) {
            Assert.assertEquals((Object)this.getID(left), (Object)this.getID(right));
        } else if (left != null && origin != null) {
            Assert.assertEquals((Object)this.getID(left), (Object)this.getID(origin));
        } else if (right != null && origin != null) {
            Assert.assertEquals((Object)this.getID(right), (Object)this.getID(origin));
        }
    }

    protected String getID(EObject eObject) {
        Resource eObjectResource;
        String identifier = EcoreUtil.getID((EObject)eObject);
        if (identifier == null && (eObjectResource = eObject.eResource()) instanceof XMIResource) {
            identifier = ((XMIResource)eObjectResource).getID(eObject);
        }
        return identifier;
    }
}

