/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.conflict.data.ConflictInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.junit.Assert;
import org.junit.Test;

public class ConflictDetectionTest {
    private ConflictInputData input = new ConflictInputData();

    private static Predicate<? super Diff> setOfReference(String qualifiedName, String referenceName, String addedQualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)addedQualifiedName, (boolean)false)});
    }

    @Test
    public void testA1UseCaseForAttribute() throws IOException {
        Resource left = this.input.getA1AttributeLeft();
        Resource origin = this.input.getA1AttributeOrigin();
        Resource right = this.input.getA1AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", (Object)"left");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testA1UseCaseForReference() throws IOException {
        Resource left = this.input.getA1ReferenceLeft();
        Resource origin = this.input.getA1ReferenceOrigin();
        Resource right = this.input.getA1ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)3L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftReferenceDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", (String)"root.left");
        Predicate rightReferenceDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftReferenceDiffDescription));
        Diff rightReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiffDescription));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Assert.assertNotNull((Object)leftReferenceDiff);
        Assert.assertNotNull((Object)rightReferenceDiff);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)3L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDeleteDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testA2UseCaseForAttribute() throws IOException {
        Resource left = this.input.getA2AttributeLeft();
        Resource origin = this.input.getA2AttributeOrigin();
        Resource right = this.input.getA2AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", null, (Object)"left");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testA2UseCaseForReference() throws IOException {
        Resource left = this.input.getA2ReferenceLeft();
        Resource origin = this.input.getA2ReferenceOrigin();
        Resource right = this.input.getA2ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", null, (String)"root.left");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testA3UseCaseForAttribute() throws IOException {
        Resource left = this.input.getA3AttributeLeft();
        Resource origin = this.input.getA3AttributeOrigin();
        Resource right = this.input.getA3AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertTrue((boolean)conflicts.isEmpty());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", null);
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
    }

    @Test
    public void testA3UseCaseForReference() throws IOException {
        Resource left = this.input.getA3ReferenceLeft();
        Resource origin = this.input.getA3ReferenceOrigin();
        Resource right = this.input.getA3ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)3L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftReferenceDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Predicate rightReferenceDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftReferenceDiffDescription));
        Diff rightReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiffDescription));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Assert.assertNotNull((Object)leftReferenceDiff);
        Assert.assertNotNull((Object)rightReferenceDiff);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightReferenceDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        Assert.assertNull((Object)rightDeleteDiff.getConflict());
    }

    @Test
    public void testB1UseCaseForAttribute() throws IOException {
        Resource left = this.input.getB1AttributeLeft();
        Resource origin = this.input.getB1AttributeOrigin();
        Resource right = this.input.getB1AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", (Object)"left");
        Predicate rightDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", (Object)"right");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB1UseCaseForReference() throws IOException {
        Resource left = this.input.getB1ReferenceLeft();
        Resource origin = this.input.getB1ReferenceOrigin();
        Resource right = this.input.getB1ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", (String)"root.left");
        Predicate rightDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", (String)"root.right");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB2UseCaseForAttribute() throws IOException {
        Resource left = this.input.getB2AttributeLeft();
        Resource origin = this.input.getB2AttributeOrigin();
        Resource right = this.input.getB2AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", (Object)"left");
        Predicate rightDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", null);
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB2UseCaseForReference() throws IOException {
        Resource left = this.input.getB2ReferenceLeft();
        Resource origin = this.input.getB2ReferenceOrigin();
        Resource right = this.input.getB2ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", (String)"root.left");
        Predicate rightDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB3UseCaseForAttribute() throws IOException {
        Resource left = this.input.getB3AttributeLeft();
        Resource origin = this.input.getB3AttributeOrigin();
        Resource right = this.input.getB3AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", null, (Object)"left");
        Predicate rightDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", null, (Object)"right");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB3UseCaseForReference() throws IOException {
        Resource left = this.input.getB3ReferenceLeft();
        Resource origin = this.input.getB3ReferenceOrigin();
        Resource right = this.input.getB3ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", null, (String)"root.left");
        Predicate rightDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", null, (String)"root.right");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB3UseCaseForContainmentReference() throws IOException {
        Resource left = this.input.getB3ContainmentReferenceLeft();
        Resource origin = this.input.getB3ContainmentReferenceOrigin();
        Resource right = this.input.getB3ContainmentReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate<? super Diff> leftDiffDescription = ConflictDetectionTest.setOfReference("root.conflictHolder", "singleValueContainment", "root.conflictHolder.newleft");
        Predicate<? super Diff> rightDiffDescription = ConflictDetectionTest.setOfReference("root.conflictHolder", "singleValueContainment", "root.conflictHolder.newright");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB4UseCaseForAttribute() throws IOException {
        Resource left = this.input.getB4AttributeLeft();
        Resource origin = this.input.getB4AttributeOrigin();
        Resource right = this.input.getB4AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", null);
        Predicate rightDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", (Object)"right");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB4UseCaseForReference() throws IOException {
        Resource left = this.input.getB4ReferenceLeft();
        Resource origin = this.input.getB4ReferenceOrigin();
        Resource right = this.input.getB4ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Predicate rightDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", (String)"root.right");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testB5UseCaseForAttribute() throws IOException {
        Resource left = this.input.getB5AttributeLeft();
        Resource origin = this.input.getB5AttributeOrigin();
        Resource right = this.input.getB5AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", null, (Object)"leftAndRight");
        Predicate rightDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", null, (Object)"leftAndRight");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testB5UseCaseForReference() throws IOException {
        Resource left = this.input.getB5ReferenceLeft();
        Resource origin = this.input.getB5ReferenceOrigin();
        Resource right = this.input.getB5ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", null, (String)"root.leftAndRight");
        Predicate rightDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", null, (String)"root.leftAndRight");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testB6UseCaseForAttribute() throws IOException {
        Resource left = this.input.getB6AttributeLeft();
        Resource origin = this.input.getB6AttributeOrigin();
        Resource right = this.input.getB6AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", null);
        Predicate rightDiffDescription = EMFComparePredicates.changedAttribute((String)"root.conflictHolder", (String)"singleValuedAttribute", (Object)"origin", null);
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testB6UseCaseForReference() throws IOException {
        Resource left = this.input.getB6ReferenceLeft();
        Resource origin = this.input.getB6ReferenceOrigin();
        Resource right = this.input.getB6ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Predicate rightDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", (String)"root.origin", null);
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testC1UseCaseForAttribute() throws IOException {
        Resource left = this.input.getC1AttributeLeft();
        Resource origin = this.input.getC1AttributeOrigin();
        Resource right = this.input.getC1AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.addedToAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"left1");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testC1UseCaseForReference() throws IOException {
        Resource left = this.input.getC1ReferenceLeft();
        Resource origin = this.input.getC1ReferenceOrigin();
        Resource right = this.input.getC1ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)5L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftReferenceDiffDescription = EMFComparePredicates.addedToReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.left1");
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Predicate rightReferenceDiff1Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightReferenceDiff2Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin2");
        Predicate rightReferenceDiff3Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin3");
        Diff leftReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftReferenceDiffDescription));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Diff rightReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff1Description));
        Diff rightReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff2Description));
        Diff rightReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff3Description));
        Assert.assertNotNull((Object)leftReferenceDiff);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Assert.assertNotNull((Object)rightReferenceDiff1);
        Assert.assertNotNull((Object)rightReferenceDiff2);
        Assert.assertNotNull((Object)rightReferenceDiff3);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDeleteDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testC2UseCaseForAttribute() throws IOException {
        Resource left = this.input.getC2AttributeLeft();
        Resource origin = this.input.getC2AttributeOrigin();
        Resource right = this.input.getC2AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertTrue((boolean)conflicts.isEmpty());
        Predicate leftDiffDescription = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
    }

    @Test
    public void testC2UseCaseForReference() throws IOException {
        Resource left = this.input.getC2ReferenceLeft();
        Resource origin = this.input.getC2ReferenceOrigin();
        Resource right = this.input.getC2ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)5L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftReferenceDiffDescription = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Predicate rightReferenceDiff1Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightReferenceDiff2Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin2");
        Predicate rightReferenceDiff3Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin3");
        Diff leftReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftReferenceDiffDescription));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Diff rightReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff1Description));
        Diff rightReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff2Description));
        Diff rightReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff3Description));
        Assert.assertNotNull((Object)leftReferenceDiff);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Assert.assertNotNull((Object)rightReferenceDiff1);
        Assert.assertNotNull((Object)rightReferenceDiff2);
        Assert.assertNotNull((Object)rightReferenceDiff3);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightReferenceDiff1));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        Assert.assertNull((Object)rightDeleteDiff.getConflict());
    }

    @Test
    public void testC3UseCaseForAttribute() throws IOException {
        Resource left = this.input.getC3AttributeLeft();
        Resource origin = this.input.getC3AttributeOrigin();
        Resource right = this.input.getC3AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.addedToAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"left1");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testC3UseCaseForReference() throws IOException {
        Resource left = this.input.getC3ReferenceLeft();
        Resource origin = this.input.getC3ReferenceOrigin();
        Resource right = this.input.getC3ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftReferenceDiffDescription = EMFComparePredicates.addedToReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.left1");
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftReferenceDiffDescription));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Assert.assertNotNull((Object)leftReferenceDiff);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDeleteDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testC4UseCaseForAttribute() throws IOException {
        Resource left = this.input.getC4AttributeLeft();
        Resource origin = this.input.getC4AttributeOrigin();
        Resource right = this.input.getC4AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)4L, (long)differences.size());
        Assert.assertTrue((boolean)conflicts.isEmpty());
        Predicate leftAttributeDiff1Description = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate leftAttributeDiff2Description = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin2");
        Predicate leftAttributeDiff3Description = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin3");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftAttributeDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftAttributeDiff1Description));
        Diff leftAttributeDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftAttributeDiff2Description));
        Diff leftAttributeDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftAttributeDiff3Description));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftAttributeDiff1);
        Assert.assertNotNull((Object)leftAttributeDiff2);
        Assert.assertNotNull((Object)leftAttributeDiff3);
        Assert.assertNotNull((Object)rightDiff);
    }

    @Test
    public void testC4UseCaseForReference() throws IOException {
        Resource left = this.input.getC4ReferenceLeft();
        Resource origin = this.input.getC4ReferenceOrigin();
        Resource right = this.input.getC4ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)7L, (long)differences.size());
        Assert.assertEquals((long)3L, (long)conflicts.size());
        Predicate referenceDiff1Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate referenceDiff2Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin2");
        Predicate referenceDiff3Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin3");
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)referenceDiff1Description));
        Diff leftReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)referenceDiff2Description));
        Diff leftReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)referenceDiff3Description));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Diff rightReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)referenceDiff1Description));
        Diff rightReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)referenceDiff2Description));
        Diff rightReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)referenceDiff3Description));
        Assert.assertNotNull((Object)leftReferenceDiff1);
        Assert.assertNotNull((Object)leftReferenceDiff2);
        Assert.assertNotNull((Object)leftReferenceDiff3);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Assert.assertNotNull((Object)rightReferenceDiff1);
        Assert.assertNotNull((Object)rightReferenceDiff2);
        Assert.assertNotNull((Object)rightReferenceDiff3);
        Conflict conflict1 = leftReferenceDiff1.getConflict();
        Assert.assertNotNull((Object)conflict1);
        Assert.assertEquals((long)2L, (long)conflict1.getDifferences().size());
        Assert.assertTrue((boolean)conflict1.getDifferences().contains((Object)leftReferenceDiff1));
        Assert.assertTrue((boolean)conflict1.getDifferences().contains((Object)rightReferenceDiff1));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict1.getKind());
        Conflict conflict2 = leftReferenceDiff2.getConflict();
        Assert.assertNotNull((Object)conflict2);
        Assert.assertEquals((long)2L, (long)conflict2.getDifferences().size());
        Assert.assertTrue((boolean)conflict2.getDifferences().contains((Object)leftReferenceDiff2));
        Assert.assertTrue((boolean)conflict2.getDifferences().contains((Object)rightReferenceDiff2));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict2.getKind());
        Conflict conflict3 = leftReferenceDiff3.getConflict();
        Assert.assertNotNull((Object)conflict3);
        Assert.assertEquals((long)2L, (long)conflict3.getDifferences().size());
        Assert.assertTrue((boolean)conflict3.getDifferences().contains((Object)leftReferenceDiff3));
        Assert.assertTrue((boolean)conflict3.getDifferences().contains((Object)rightReferenceDiff3));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict3.getKind());
        Assert.assertNull((Object)rightDeleteDiff.getConflict());
    }

    @Test
    public void testC5UseCaseForAttribute() throws IOException {
        Resource left = this.input.getC5AttributeLeft();
        Resource origin = this.input.getC5AttributeOrigin();
        Resource right = this.input.getC5AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.movedInAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testC5UseCaseForReference() throws IOException {
        Resource left = this.input.getC5ReferenceLeft();
        Resource origin = this.input.getC5ReferenceOrigin();
        Resource right = this.input.getC5ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)5L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftReferenceDiffDescription = EMFComparePredicates.movedInReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightDeleteDiffDescription = EMFComparePredicates.removed((String)"root.conflictHolder");
        Predicate rightReferenceDiff1Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightReferenceDiff2Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin2");
        Predicate rightReferenceDiff3Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin2");
        Diff leftReferenceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftReferenceDiffDescription));
        Diff rightDeleteDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDeleteDiffDescription));
        Diff rightReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff1Description));
        Diff rightReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff2Description));
        Diff rightReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightReferenceDiff3Description));
        Assert.assertNotNull((Object)leftReferenceDiff);
        Assert.assertNotNull((Object)rightDeleteDiff);
        Assert.assertNotNull((Object)rightReferenceDiff1);
        Assert.assertNotNull((Object)rightReferenceDiff2);
        Assert.assertNotNull((Object)rightReferenceDiff3);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)3L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftReferenceDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDeleteDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightReferenceDiff1));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD1UseCaseForAttribute() throws IOException {
        Resource left = this.input.getD1AttributeLeft();
        Resource origin = this.input.getD1AttributeOrigin();
        Resource right = this.input.getD1AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate rightDiffDescription = EMFComparePredicates.movedInAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD1UseCaseForReference() throws IOException {
        Resource left = this.input.getD1ReferenceLeft();
        Resource origin = this.input.getD1ReferenceOrigin();
        Resource right = this.input.getD1ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightDiffDescription = EMFComparePredicates.movedInReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD2UseCaseForAttribute() throws IOException {
        Resource left = this.input.getD2AttributeLeft();
        Resource origin = this.input.getD2AttributeOrigin();
        Resource right = this.input.getD2AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.movedInAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate rightDiffDescription = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD2UseCaseForReference() throws IOException {
        Resource left = this.input.getD2ReferenceLeft();
        Resource origin = this.input.getD2ReferenceOrigin();
        Resource right = this.input.getD2ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.movedInReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightDiffDescription = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD3UseCaseForAttribute() throws IOException {
        Resource left = this.input.getD3AttributeLeft();
        Resource origin = this.input.getD3AttributeOrigin();
        Resource right = this.input.getD3AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.movedInAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate rightDiffDescription = EMFComparePredicates.movedInAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD3UseCaseForReference() throws IOException {
        Resource left = this.input.getD3ReferenceLeft();
        Resource origin = this.input.getD3ReferenceOrigin();
        Resource right = this.input.getD3ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.movedInReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate rightDiffDescription = EMFComparePredicates.movedInReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testD4UseCaseForAttribute() throws IOException {
        Resource left = this.input.getD4AttributeLeft();
        Resource origin = this.input.getD4AttributeOrigin();
        Resource right = this.input.getD4AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)6L, (long)differences.size());
        Assert.assertEquals((long)3L, (long)conflicts.size());
        Predicate AttributeDiff1Description = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Predicate AttributeDiff2Description = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin2");
        Predicate AttributeDiff3Description = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin3");
        Diff leftAttributeDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)AttributeDiff1Description));
        Diff leftAttributeDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)AttributeDiff2Description));
        Diff leftAttributeDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)AttributeDiff3Description));
        Diff rightAttributeDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)AttributeDiff1Description));
        Diff rightAttributeDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)AttributeDiff2Description));
        Diff rightAttributeDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)AttributeDiff3Description));
        Assert.assertNotNull((Object)leftAttributeDiff1);
        Assert.assertNotNull((Object)leftAttributeDiff2);
        Assert.assertNotNull((Object)leftAttributeDiff3);
        Assert.assertNotNull((Object)rightAttributeDiff1);
        Assert.assertNotNull((Object)rightAttributeDiff2);
        Assert.assertNotNull((Object)rightAttributeDiff3);
        Conflict conflict1 = (Conflict)conflicts.get(0);
        EList conflictDiffs1 = conflict1.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiffs1.size());
        Assert.assertTrue((boolean)conflictDiffs1.contains(leftAttributeDiff1));
        Assert.assertTrue((boolean)conflictDiffs1.contains(rightAttributeDiff1));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict1.getKind());
        Conflict conflict2 = (Conflict)conflicts.get(1);
        EList conflictDiffs2 = conflict2.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiffs2.size());
        Assert.assertTrue((boolean)conflictDiffs2.contains(leftAttributeDiff2));
        Assert.assertTrue((boolean)conflictDiffs2.contains(rightAttributeDiff2));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict2.getKind());
        Conflict conflict3 = (Conflict)conflicts.get(2);
        EList conflictDiffs3 = conflict3.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiffs3.size());
        Assert.assertTrue((boolean)conflictDiffs3.contains(leftAttributeDiff3));
        Assert.assertTrue((boolean)conflictDiffs3.contains(rightAttributeDiff3));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict3.getKind());
    }

    @Test
    public void testD4UseCaseForReference() throws IOException {
        Resource left = this.input.getD4ReferenceLeft();
        Resource origin = this.input.getD4ReferenceOrigin();
        Resource right = this.input.getD4ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)6L, (long)differences.size());
        Assert.assertEquals((long)3L, (long)conflicts.size());
        Predicate referenceDiff1Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Predicate referenceDiff2Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin2");
        Predicate referenceDiff3Description = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin3");
        Diff leftReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)referenceDiff1Description));
        Diff leftReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)referenceDiff2Description));
        Diff leftReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)referenceDiff3Description));
        Diff rightReferenceDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)referenceDiff1Description));
        Diff rightReferenceDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)referenceDiff2Description));
        Diff rightReferenceDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)referenceDiff3Description));
        Assert.assertNotNull((Object)leftReferenceDiff1);
        Assert.assertNotNull((Object)leftReferenceDiff2);
        Assert.assertNotNull((Object)leftReferenceDiff3);
        Assert.assertNotNull((Object)rightReferenceDiff1);
        Assert.assertNotNull((Object)rightReferenceDiff2);
        Assert.assertNotNull((Object)rightReferenceDiff3);
        Conflict conflict1 = (Conflict)conflicts.get(0);
        EList conflictDiffs1 = conflict1.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiffs1.size());
        Assert.assertTrue((boolean)conflictDiffs1.contains(leftReferenceDiff1));
        Assert.assertTrue((boolean)conflictDiffs1.contains(rightReferenceDiff1));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict1.getKind());
        Conflict conflict2 = (Conflict)conflicts.get(1);
        EList conflictDiffs2 = conflict2.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiffs2.size());
        Assert.assertTrue((boolean)conflictDiffs2.contains(leftReferenceDiff2));
        Assert.assertTrue((boolean)conflictDiffs2.contains(rightReferenceDiff2));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict2.getKind());
        Conflict conflict3 = (Conflict)conflicts.get(2);
        EList conflictDiffs3 = conflict3.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiffs3.size());
        Assert.assertTrue((boolean)conflictDiffs3.contains(leftReferenceDiff3));
        Assert.assertTrue((boolean)conflictDiffs3.contains(rightReferenceDiff3));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict3.getKind());
    }

    @Test
    public void testD5UseCaseForAttribute() throws IOException {
        Resource left = this.input.getD5AttributeLeft();
        Resource origin = this.input.getD5AttributeOrigin();
        Resource right = this.input.getD5AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate diffDescription = EMFComparePredicates.removedFromAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)diffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)diffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testD5UseCaseForReference() throws IOException {
        Resource left = this.input.getD5ReferenceLeft();
        Resource origin = this.input.getD5ReferenceOrigin();
        Resource right = this.input.getD5ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate diffDescription = EMFComparePredicates.removedFromReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)diffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)diffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testD6UseCaseForAttribute() throws IOException {
        Resource left = this.input.getD6AttributeLeft();
        Resource origin = this.input.getD6AttributeOrigin();
        Resource right = this.input.getD6AttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate diffDescription = EMFComparePredicates.movedInAttribute((String)"root.conflictHolder", (String)"multiValuedAttribute", (Object)"origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)diffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)diffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testD6UseCaseForReference() throws IOException {
        Resource left = this.input.getD6ReferenceLeft();
        Resource origin = this.input.getD6ReferenceOrigin();
        Resource right = this.input.getD6ReferenceRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate diffDescription = EMFComparePredicates.movedInReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)diffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)diffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Test
    public void testE1UseCase() throws IOException {
        Resource left = this.input.getE1Left();
        Resource origin = this.input.getE1Origin();
        Resource right = this.input.getE1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.changedReference((String)"root.conflictHolder", (String)"singleValuedReference", null, (String)"root.origin");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.origin");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testE2UseCase() throws IOException {
        Resource left = this.input.getE2Left();
        Resource origin = this.input.getE2Origin();
        Resource right = this.input.getE2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.addedToReference((String)"root.conflictHolder", (String)"multiValuedReference", (String)"root.origin");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.origin");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testE3UseCase() throws IOException {
        Resource left = this.input.getE3Left();
        Resource origin = this.input.getE3Origin();
        Resource right = this.input.getE3Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)3L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
    }

    @Test
    public void testFUseCase() throws IOException {
        Resource left = this.input.getFLeft();
        Resource origin = this.input.getFOrigin();
        Resource right = this.input.getFRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.moved((String)"root.conflictHolder.origin", (String)"containmentRef2");
        Predicate rightDiffDescription = EMFComparePredicates.moved((String)"root.conflictHolder.origin", (String)"containmentRef3");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testGUseCase() throws IOException {
        Resource left = this.input.getGLeft();
        Resource origin = this.input.getGOrigin();
        Resource right = this.input.getGRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.moved((String)"root.leftContainer.conflictNode", (String)"containmentRef1");
        Predicate rightDiffDescription = EMFComparePredicates.moved((String)"root.rightContainer.conflictNode", (String)"containmentRef1");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testH1UseCase() throws IOException {
        Resource left = this.input.getH1Left();
        Resource origin = this.input.getH1Origin();
        Resource right = this.input.getH1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.moved((String)"root.left.conflictNode", (String)"singleValueContainment");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.left");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testH2UseCase() throws IOException {
        Resource left = this.input.getH2Left();
        Resource origin = this.input.getH2Origin();
        Resource right = this.input.getH2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)2L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Predicate leftDiffDescription = EMFComparePredicates.moved((String)"root.leftContainer.conflictNode", (String)"containmentRef1");
        Predicate rightDiffDescription = EMFComparePredicates.removed((String)"root.leftContainer");
        Diff leftDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiffDescription));
        Diff rightDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiffDescription));
        Assert.assertNotNull((Object)leftDiff);
        Assert.assertNotNull((Object)rightDiff);
        Conflict conflict = (Conflict)conflicts.get(0);
        EList conflictDiff = conflict.getDifferences();
        Assert.assertEquals((long)2L, (long)conflictDiff.size());
        Assert.assertTrue((boolean)conflictDiff.contains(leftDiff));
        Assert.assertTrue((boolean)conflictDiff.contains(rightDiff));
        Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
    }

    @Test
    public void testIUseCase() throws IOException {
        Resource left = this.input.getILeft();
        Resource origin = this.input.getIOrigin();
        Resource right = this.input.getIRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)5L, (long)differences.size());
        Assert.assertEquals((long)1L, (long)conflicts.size());
        Conflict soleConflict = (Conflict)conflicts.get(0);
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)soleConflict.getKind());
    }

    @Test
    public void testJUseCase() throws IOException {
        Resource left = this.input.getJLeft();
        Resource origin = this.input.getJOrigin();
        Resource right = this.input.getJRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)5L, (long)differences.size());
        Assert.assertEquals((long)2L, (long)conflicts.size());
        for (Conflict conflict : conflicts) {
            Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
            Assert.assertEquals((long)2L, (long)conflict.getDifferences().size());
        }
    }

    @Test
    public void testK1UseCase() throws IOException {
        Resource left = this.input.getK1Left();
        Resource origin = this.input.getK1Origin();
        Resource right = this.input.getK1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)6L, (long)differences.size());
        Assert.assertEquals((long)2L, (long)conflicts.size());
        Iterable realConflicts = Iterables.filter((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
        Iterable pseudoConflicts = Iterables.filter((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)realConflicts));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)pseudoConflicts));
    }

    @Test
    public void testK2UseCase() throws IOException {
        Resource left = this.input.getK2Left();
        Resource origin = this.input.getK2Origin();
        Resource right = this.input.getK2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)8L, (long)differences.size());
        Assert.assertEquals((long)3L, (long)conflicts.size());
        Iterable realConflicts = Iterables.filter((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
        Iterable pseudoConflicts = Iterables.filter((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)realConflicts));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)pseudoConflicts));
    }

    @Test
    public void testK3UseCase() throws IOException {
        Resource left = this.input.getK3Left();
        Resource origin = this.input.getK3Origin();
        Resource right = this.input.getK3Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)6L, (long)differences.size());
        Assert.assertEquals((long)3L, (long)conflicts.size());
        Iterable realConflicts = Iterables.filter((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
        Iterable pseudoConflicts = Iterables.filter((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)realConflicts));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)pseudoConflicts));
    }

    @Test
    public void testK4UseCase() throws IOException {
        Resource left = this.input.getK4Left();
        Resource origin = this.input.getK4Origin();
        Resource right = this.input.getK4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)4L, (long)differences.size());
        Assert.assertEquals((long)2L, (long)conflicts.size());
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)((Conflict)conflicts.get(0)).getKind());
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)((Conflict)conflicts.get(1)).getKind());
    }

    @Test
    public void testComplexUseCase() throws IOException {
        Resource left = this.input.getComplexLeft();
        Resource origin = this.input.getComplexOrigin();
        Resource right = this.input.getComplexRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)12L, (long)differences.size());
        Assert.assertEquals((long)5L, (long)conflicts.size());
        Predicate leftDiff1Description = EMFComparePredicates.added((String)"Root.Node8");
        Predicate leftDiff2Description = EMFComparePredicates.added((String)"Root.Node9");
        Predicate leftDiff3Description = EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1");
        Predicate leftDiff4Description = EMFComparePredicates.added((String)"Root.Node0");
        Predicate leftDiff5Description = EMFComparePredicates.removed((String)"Root.Node5");
        Predicate leftDiff6Description = EMFComparePredicates.removed((String)"Root.Node6");
        Predicate leftDiff7Description = EMFComparePredicates.removed((String)"Root.Node7");
        Predicate rightDiff8Description = EMFComparePredicates.moved((String)"Root.Node6", (String)"containmentRef1");
        Predicate rightDiff9Description = EMFComparePredicates.added((String)"Root.Node9");
        Predicate rightDiff10Description = EMFComparePredicates.added((String)"Root.Node0");
        Predicate rightDiff11Description = EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1");
        Predicate rightDiff12Description = EMFComparePredicates.removed((String)"Root.Node5");
        Diff leftDiff1 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff1Description));
        Diff leftDiff2 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff2Description));
        Diff leftDiff3 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff3Description));
        Diff leftDiff4 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff4Description));
        Diff leftDiff5 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff5Description));
        Diff leftDiff6 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff6Description));
        Diff leftDiff7 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)leftDiff7Description));
        Diff rightDiff8 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiff8Description));
        Diff rightDiff9 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiff9Description));
        Diff rightDiff10 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiff10Description));
        Diff rightDiff11 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiff11Description));
        Diff rightDiff12 = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)rightDiff12Description));
        Assert.assertNotNull((Object)leftDiff1);
        Assert.assertNotNull((Object)leftDiff2);
        Assert.assertNotNull((Object)leftDiff3);
        Assert.assertNotNull((Object)leftDiff4);
        Assert.assertNotNull((Object)leftDiff5);
        Assert.assertNotNull((Object)leftDiff6);
        Assert.assertNotNull((Object)leftDiff7);
        Assert.assertNotNull((Object)rightDiff8);
        Assert.assertNotNull((Object)rightDiff9);
        Assert.assertNotNull((Object)rightDiff10);
        Assert.assertNotNull((Object)rightDiff11);
        Assert.assertNotNull((Object)rightDiff12);
        for (Conflict conflict : conflicts) {
            EList conflictDiffs = conflict.getDifferences();
            Assert.assertEquals((long)2L, (long)conflictDiffs.size());
            if (conflictDiffs.contains(leftDiff6)) {
                Assert.assertTrue((boolean)conflictDiffs.contains(rightDiff8));
                Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
                continue;
            }
            if (conflictDiffs.contains(leftDiff2)) {
                Assert.assertTrue((boolean)conflictDiffs.contains(rightDiff9));
                Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
                continue;
            }
            if (conflictDiffs.contains(leftDiff4)) {
                Assert.assertTrue((boolean)conflictDiffs.contains(rightDiff10));
                Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
                continue;
            }
            if (conflictDiffs.contains(leftDiff3)) {
                Assert.assertTrue((boolean)conflictDiffs.contains(rightDiff11));
                Assert.assertSame((Object)ConflictKind.REAL, (Object)conflict.getKind());
                continue;
            }
            if (conflictDiffs.contains(leftDiff5)) {
                Assert.assertTrue((boolean)conflictDiffs.contains(rightDiff12));
                Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
                continue;
            }
            Assert.fail((String)"unexpected conflict");
        }
    }

    @Test
    public void testDanglingRACTest() throws Exception {
        ResourceSet rsAncestor = this.input.getRACDanglingConflictAncestorModel();
        ResourceSet rsLeft = this.input.getRACDanglingConflictLeftModel();
        ResourceSet rsRight = this.input.getRACDanglingConflictRightModel();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)rsLeft, (Notifier)rsRight, (Notifier)rsAncestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)5L, (long)differences.size());
        Assert.assertEquals((long)2L, (long)conflicts.size());
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))));
        Iterable nonConflictingDiffs = Iterables.filter((Iterable)differences, (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO})));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nonConflictingDiffs));
        Diff nonConflictingDiff = (Diff)nonConflictingDiffs.iterator().next();
        Assert.assertTrue((boolean)(nonConflictingDiff instanceof ResourceAttachmentChange));
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)nonConflictingDiff.getSource());
        Assert.assertTrue((boolean)((ResourceAttachmentChange)nonConflictingDiff).getResourceURI().endsWith("fragment.nodes"));
    }
}

