/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.compare.ide.ui.tests.egit.fixture.GitTestRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.variants.IResourceVariant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class VariantsTestCase
extends CompareGitTestCase {
    protected final String INITIAL_CONTENT_1 = "some content for the first file";
    protected final String INITIAL_CONTENT_2 = "some content for the second file";
    protected static final String MASTER = "refs/heads/master";
    protected static final String BRANCH = "refs/heads/branch";
    protected Repository repo;
    protected IProject iProject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.iProject = this.project.getProject();
        this.repo = RepositoryMapping.getMapping((IProject)this.iProject).getRepository();
        try (Git git = new Git(this.repo);){
            git.commit().setAuthor("JUnit", "junit@jgit.org").setMessage("Initial commit").call();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.repository.disconnect(this.iProject);
        this.repo = null;
        super.tearDown();
    }

    protected RevCommit setContentsAndCommit(GitTestRepository testRepository, IFile targetFile, String newContents, String commitMessage) throws Exception {
        targetFile.setContents((InputStream)new ByteArrayInputStream(newContents.getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
        testRepository.addToIndex((IResource)targetFile);
        return testRepository.commit(commitMessage);
    }

    protected void assertContentEquals(IResourceVariant variant, String expectedContents) throws Exception {
        this.assertContentEquals(variant.getStorage((IProgressMonitor)new NullProgressMonitor()), expectedContents);
    }

    protected void assertContentEquals(IStorage storage, String expectedContents) throws Exception {
        try (Scanner scanner = new Scanner(storage.getContents());){
            scanner.useDelimiter("\\A");
            String fileContent = "";
            if (scanner.hasNext()) {
                fileContent = scanner.next();
            }
            Assert.assertEquals((Object)expectedContents, (Object)fileContent);
        }
    }
}

