/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeConflictingRunnable;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractMergeRunnableTest;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.junit.Test;

public class MergeConflictingRunnableTest
extends AbstractMergeRunnableTest {
    private Diff leftDelete;
    private Diff leftAdd;
    private Diff rightDelete;
    private Diff rightAdd;

    @Test
    public void testThatNoDiffIsMergedInRightToLeftAcceptIfNotConflicting() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setupAndAssertThatNoDiffIsMergedIfNotConflicting(false, mergeMode);
    }

    @Test
    public void testThatNoDiffIsMergedInRightToLeftRejectIfNotConflicting() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setupAndAssertThatNoDiffIsMergedIfNotConflicting(false, mergeMode);
    }

    @Test
    public void testThatNoDiffIsMergedInRightToLeftIfNotConflicting() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setupAndAssertThatNoDiffIsMergedIfNotConflicting(false, mergeMode);
    }

    @Test
    public void testThatNoDiffIsMergedInLeftToRightIfNotConflicting() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setupAndAssertThatNoDiffIsMergedIfNotConflicting(true, mergeMode);
    }

    private void setupAndAssertThatNoDiffIsMergedIfNotConflicting(boolean isLeftToRight, MergeMode mergeMode) {
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        MergeConflictingRunnable sut = this.newMergeConflictingRunnable(mergeMode);
        for (Diff diff : Lists.newArrayList((Object[])new Diff[]{this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd})) {
            sut.merge((List)Lists.newArrayList((Object[])new Diff[]{diff}), isLeftToRight, (IMerger.Registry)this.mergerRegistry);
            this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd, this.rightDelete, this.rightAdd);
            this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.rightAdd);
        }
    }

    @Test
    public void testMergeRightToLeftAcceptWithConflict() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeConflictingRunnable sut = this.newMergeConflictingRunnable(mergeMode);
        sut.merge((List)Lists.newArrayList((Object[])new Diff[]{this.rightDelete}), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.rightAdd);
    }

    @Test
    public void testMergeRightToLeftRejectWithConflict() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeConflictingRunnable sut = this.newMergeConflictingRunnable(mergeMode);
        sut.merge((List)Lists.newArrayList((Object[])new Diff[]{this.rightDelete}), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMarkedAsMerged(this.leftDelete);
        this.verifyHasBeenMarkedAsDiscarded(this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.leftAdd, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithConflict() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeConflictingRunnable sut = this.newMergeConflictingRunnable(mergeMode);
        sut.merge((List)Lists.newArrayList((Object[])new Diff[]{this.rightDelete}), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete, this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.rightAdd);
    }

    @Test
    public void testMergeRightToLeftWithConflict() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeConflictingRunnable sut = this.newMergeConflictingRunnable(mergeMode);
        sut.merge((List)Lists.newArrayList((Object[])new Diff[]{this.rightDelete}), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.rightAdd);
    }

    private void setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide() {
        this.leftDelete = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.DELETE, "leftDelete");
        this.leftAdd = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.ADD, "leftAdd");
        this.rightDelete = this.mockReferenceChange(DifferenceSource.RIGHT, DifferenceKind.DELETE, "rightDelete");
        this.rightAdd = this.mockReferenceChange(DifferenceSource.RIGHT, DifferenceKind.ADD, "rightAdd");
        this.addDifferencesToMockComparison(this.leftDelete, this.leftAdd, this.rightDelete, this.rightAdd);
        this.setThreeWayComparison();
    }

    private MergeConflictingRunnable newMergeConflictingRunnable(MergeMode mergeMode) {
        boolean isRightEditable;
        boolean isLeftEditable;
        switch (mergeMode) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                isLeftEditable = true;
                isRightEditable = true;
                break;
            }
            case ACCEPT: 
            case REJECT: {
                isLeftEditable = true;
                isRightEditable = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new MergeConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer((IMerger.Registry)this.mergerRegistry));
    }
}

