/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.emf.compare.egit.internal.storage.IndexResourceVariant;
import org.eclipse.emf.compare.egit.internal.storage.TreeParserResourceVariant;
import org.eclipse.emf.compare.ide.ui.tests.merge.VariantsTestCase;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.team.core.variants.IResourceVariant;
import org.junit.Assert;
import org.junit.Test;

public class ResourceVariantTest
extends VariantsTestCase {
    private static final String BASE_BRANCH = "base";
    private static final String BRANCH_CHANGE = "branch changes\n";
    private static final String MASTER_CHANGE = "master changes\n";

    @Test
    public void testIndexVariants() throws Exception {
        IndexResourceVariant variant;
        DirCacheEntry entry;
        File file1 = this.repository.createFile(this.iProject, "file1");
        File file2 = this.repository.createFile(this.iProject, "file2");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        this.setupUnconflictingBranches();
        List<String> possibleNames = Arrays.asList(iFile1.getName(), iFile2.getName());
        DirCache cache = this.repo.readDirCache();
        int i = 0;
        while (i < cache.getEntryCount()) {
            entry = cache.getEntry(i);
            variant = IndexResourceVariant.create((Repository)this.repo, (DirCacheEntry)entry);
            Assert.assertEquals((Object)entry.getObjectId().getName(), (Object)variant.getContentIdentifier());
            Assert.assertTrue((boolean)possibleNames.contains(variant.getName()));
            Assert.assertEquals((Object)entry.getObjectId(), (Object)variant.getObjectId());
            Assert.assertEquals((long)entry.getRawMode(), (long)variant.getRawMode());
            if (iFile1.getName().equals(variant.getName())) {
                this.assertContentEquals((IResourceVariant)variant, "some content for the first filemaster changes\n");
            } else {
                this.assertContentEquals((IResourceVariant)variant, "some content for the second filemaster changes\n");
            }
            ++i;
        }
        this.repository.checkoutBranch("refs/heads/branch");
        cache = this.repo.readDirCache();
        i = 0;
        while (i < cache.getEntryCount()) {
            entry = cache.getEntry(i);
            variant = IndexResourceVariant.create((Repository)this.repo, (DirCacheEntry)entry);
            Assert.assertEquals((Object)entry.getObjectId().getName(), (Object)variant.getContentIdentifier());
            Assert.assertTrue((boolean)possibleNames.contains(variant.getName()));
            Assert.assertEquals((Object)entry.getObjectId(), (Object)variant.getObjectId());
            Assert.assertEquals((long)entry.getRawMode(), (long)variant.getRawMode());
            if (iFile1.getName().equals(variant.getName())) {
                this.assertContentEquals((IResourceVariant)variant, "branch changes\nsome content for the first file");
            } else {
                this.assertContentEquals((IResourceVariant)variant, "branch changes\nsome content for the second file");
            }
            ++i;
        }
    }

    @Test
    public void testIndexVariantsConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.setupConflictingBranches();
        new MergeOperation(this.repo, "refs/heads/branch").execute(null);
        DirCache cache = this.repo.readDirCache();
        Assert.assertEquals((long)5L, (long)cache.getEntryCount());
        int i = 0;
        while (i < cache.getEntryCount()) {
            DirCacheEntry entry = cache.getEntry(i);
            IndexResourceVariant variant = IndexResourceVariant.create((Repository)this.repo, (DirCacheEntry)entry);
            Assert.assertEquals((Object)entry.getObjectId().getName(), (Object)variant.getContentIdentifier());
            Assert.assertEquals((Object)entry.getObjectId(), (Object)variant.getObjectId());
            Assert.assertEquals((long)entry.getRawMode(), (long)variant.getRawMode());
            if (iFile1.getName().equals(variant.getName())) {
                switch (entry.getStage()) {
                    case 1: {
                        this.assertContentEquals((IResourceVariant)variant, "some content for the first file");
                        break;
                    }
                    case 2: {
                        this.assertContentEquals((IResourceVariant)variant, "some content for the first filemaster changes\n");
                        break;
                    }
                    case 3: {
                        this.assertContentEquals((IResourceVariant)variant, "branch changes\nsome content for the first file");
                        break;
                    }
                    default: {
                        Assert.fail((String)("Unexpected entry stage " + entry.getStage() + " in the index for file " + entry.getPathString()));
                        break;
                    }
                }
            } else {
                switch (entry.getStage()) {
                    case 2: {
                        this.assertContentEquals((IResourceVariant)variant, "some content for the second filemaster changes\n");
                        break;
                    }
                    case 3: {
                        this.assertContentEquals((IResourceVariant)variant, "branch changes\nsome content for the second file");
                        break;
                    }
                    default: {
                        Assert.fail((String)("Unexpected entry stage " + entry.getStage() + " in the index for file " + entry.getPathString()));
                    }
                }
            }
            ++i;
        }
    }

    @Test
    public void testTreeWalkBranchVariants() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.setupUnconflictingBranches();
        ObjectId baseId = this.repo.resolve("refs/heads/branch");
        RevWalk walk = new RevWalk(this.repo);
        TreeWalk tw = new TreeWalk(this.repo);
        try {
            tw.addTree((AnyObjectId)walk.parseTree((AnyObjectId)baseId));
            while (tw.next()) {
                TreeParserResourceVariant variant = TreeParserResourceVariant.create((Repository)this.repo, (CanonicalTreeParser)((CanonicalTreeParser)tw.getTree(0, CanonicalTreeParser.class)), null);
                Assert.assertEquals((Object)tw.getObjectId(0).getName(), (Object)variant.getContentIdentifier());
                Assert.assertEquals((Object)tw.getObjectId(0), (Object)variant.getObjectId());
                Assert.assertEquals((long)tw.getRawMode(0), (long)variant.getRawMode());
                if (iFile1.getName().equals(variant.getName())) {
                    this.assertContentEquals((IResourceVariant)variant, "branch changes\nsome content for the first file");
                } else if (!tw.isSubtree()) {
                    this.assertContentEquals((IResourceVariant)variant, "branch changes\nsome content for the second file");
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        finally {
            walk.close();
            tw.close();
        }
    }

    @Test
    public void testTreeWalkMasterVariants() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.setupUnconflictingBranches();
        ObjectId baseId = this.repo.resolve("refs/heads/master");
        RevWalk walk = new RevWalk(this.repo);
        TreeWalk tw = new TreeWalk(this.repo);
        try {
            tw.addTree((AnyObjectId)walk.parseTree((AnyObjectId)baseId));
            while (tw.next()) {
                TreeParserResourceVariant variant = TreeParserResourceVariant.create((Repository)this.repo, (CanonicalTreeParser)((CanonicalTreeParser)tw.getTree(0, CanonicalTreeParser.class)), null);
                Assert.assertEquals((Object)tw.getObjectId(0).getName(), (Object)variant.getContentIdentifier());
                Assert.assertEquals((Object)tw.getObjectId(0), (Object)variant.getObjectId());
                Assert.assertEquals((long)tw.getRawMode(0), (long)variant.getRawMode());
                if (iFile1.getName().equals(variant.getName())) {
                    this.assertContentEquals((IResourceVariant)variant, "some content for the first filemaster changes\n");
                } else if (!tw.isSubtree()) {
                    this.assertContentEquals((IResourceVariant)variant, "some content for the second filemaster changes\n");
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        finally {
            walk.close();
            tw.close();
        }
    }

    @Test
    public void testTreeWalkBaseVariants() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.setupUnconflictingBranches();
        ObjectId baseId = this.repo.resolve(BASE_BRANCH);
        RevWalk walk = new RevWalk(this.repo);
        TreeWalk tw = new TreeWalk(this.repo);
        try {
            tw.addTree((AnyObjectId)walk.parseTree((AnyObjectId)baseId));
            while (tw.next()) {
                TreeParserResourceVariant variant = TreeParserResourceVariant.create((Repository)this.repo, (CanonicalTreeParser)((CanonicalTreeParser)tw.getTree(0, CanonicalTreeParser.class)), null);
                Assert.assertEquals((Object)tw.getObjectId(0).getName(), (Object)variant.getContentIdentifier());
                Assert.assertEquals((Object)tw.getObjectId(0), (Object)variant.getObjectId());
                Assert.assertEquals((long)tw.getRawMode(0), (long)variant.getRawMode());
                if (iFile1.getName().equals(variant.getName())) {
                    this.assertContentEquals((IResourceVariant)variant, "some content for the first file");
                } else if (!tw.isSubtree()) {
                    Assert.fail((String)"file2 shouldn't exist in our base.");
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        finally {
            walk.close();
            tw.close();
        }
    }

    private void setupUnconflictingBranches() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        File file2 = this.repository.createFile(this.iProject, "file2");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.repository.appendContentAndCommit(this.iProject, file1, "some content for the first file", "first file - initial commit");
        this.repository.createBranch("refs/heads/master", BASE_BRANCH);
        this.repository.createAndCheckoutBranch("refs/heads/master", "refs/heads/branch");
        this.setContentsAndCommit(this.repository, iFile1, "branch changes\nsome content for the first file", "branch commit");
        this.repository.appendContentAndCommit(this.iProject, file2, "branch changes\nsome content for the second file", "second file - initial commit - branch");
        this.repository.checkoutBranch("refs/heads/master");
        this.setContentsAndCommit(this.repository, iFile1, "some content for the first filemaster changes\n", "master commit - file1");
        this.repository.appendContentAndCommit(this.iProject, file2, "some content for the second filemaster changes\n", "second file - initial commit - master");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void setupConflictingBranches() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        File file2 = this.repository.createFile(this.iProject, "file2");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.repository.appendContentAndCommit(this.iProject, file1, "some content for the first file", "first file - initial commit");
        this.repository.createAndCheckoutBranch("refs/heads/master", "refs/heads/branch");
        this.setContentsAndCommit(this.repository, iFile1, "branch changes\nsome content for the first file", "branch commit");
        this.repository.appendContentAndCommit(this.iProject, file2, "branch changes\nsome content for the second file", "second file - initial commit - branch");
        this.repository.checkoutBranch("refs/heads/master");
        this.setContentsAndCommit(this.repository, iFile1, "some content for the first filemaster changes\n", "master commit - file1");
        this.repository.appendContentAndCommit(this.iProject, file2, "some content for the second filemaster changes\n", "second file - initial commit - master");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }
}

