/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.tests.unit.LogicalModelGraphTest;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class LocalResolutionTest
extends LogicalModelGraphTest {
    protected static final String PROJECT2_NAME = "Project-2";
    protected TestProject project2;
    protected IFile iFile1;
    protected IFile iFile2;
    private CrossReferenceResolutionScope originalResolutionScope;
    protected final CrossReferenceResolutionScope scopeToUse;
    protected final Set<? extends Set<URI>> expectedGraph;
    protected final Set<String> expectedTraversal;

    public LocalResolutionTest(CrossReferenceResolutionScope scopeToUse, Set<? extends Set<URI>> uriSets, Set<String> traversalPaths) {
        this.scopeToUse = scopeToUse;
        this.expectedGraph = uriSets;
        this.expectedTraversal = traversalPaths;
    }

    protected abstract void setUpModel() throws Exception;

    @Test
    public void test() throws Exception {
        LogicalModelGraphTest.ResolvingResult result = this.resolveTraversalOf(this.iFile1);
        Set<Set<URI>> subGraphs = result.getSubGraphs();
        Assert.assertEquals((long)this.expectedGraph.size(), (long)subGraphs.size());
        Assert.assertTrue((boolean)subGraphs.containsAll(this.expectedGraph));
        StorageTraversal traversal = result.getTraversal();
        Assert.assertEquals((long)this.expectedTraversal.size(), (long)traversal.getStorages().size());
        for (IStorage storage : traversal.getStorages()) {
            Assert.assertTrue((boolean)this.expectedTraversal.contains(storage.getFullPath().toString()));
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        String stringValue = store.getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        this.originalResolutionScope = CrossReferenceResolutionScope.valueOf((String)stringValue);
        this.project2 = new TestProject(PROJECT2_NAME);
        super.setUp();
        this.setUpModel();
        this.setResolutionScope(this.scopeToUse);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EMFModelProvider emfModelProvider = (EMFModelProvider)ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider").getModelProvider();
        emfModelProvider.clear();
        this.setResolutionScope(this.originalResolutionScope);
        this.iFile1 = null;
        this.iFile2 = null;
        this.project2.dispose();
        super.tearDown();
    }
}

