/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.tests;

import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.WrapperItemDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemRegistryTest {
    private IItemRegistry<IMatchEngine.Factory> registry;

    @Before
    public void setUp() {
        this.registry = new ItemRegistry();
    }

    private IItemDescriptor<IMatchEngine.Factory> createDescriptor(String id, int rank, IMatchEngine.Factory instance) {
        return new WrapperItemDescriptor("Fake label " + id, "Fake description " + id, rank, id, (Object)instance);
    }

    @Test
    public void testAdd() {
        String id = "fakeID";
        IItemDescriptor<IMatchEngine.Factory> instance = this.createDescriptor(id, 1, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        IItemDescriptor oldValue = this.registry.add(instance);
        Assert.assertEquals((long)this.registry.getItemDescriptors().size(), (long)1L);
        Assert.assertSame((Object)this.registry.getItemDescriptor(id), instance);
        Assert.assertSame((Object)this.registry.getHighestRankingDescriptor(), instance);
        Assert.assertNull((Object)oldValue);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNull() {
        this.registry.add(null);
    }

    @Test
    public void testSameID() {
        String id = "fakeID";
        IItemDescriptor<IMatchEngine.Factory> instance1 = this.createDescriptor(id, 1, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        this.registry.add(instance1);
        IItemDescriptor<IMatchEngine.Factory> instance2 = this.createDescriptor(id, 2, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        IItemDescriptor oldValue = this.registry.add(instance2);
        Assert.assertTrue((oldValue == instance1 ? 1 : 0) != 0);
        Assert.assertTrue((this.registry.getItemDescriptor(id) == instance2 ? 1 : 0) != 0);
        Assert.assertTrue((this.registry.getItemDescriptors().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetHighestRankingItem() {
        this.registry.add(this.createDescriptor("Id-10", -10, (IMatchEngine.Factory)new MatchEngineFactoryImpl()));
        this.registry.add(this.createDescriptor("Id0", 0, (IMatchEngine.Factory)new MatchEngineFactoryImpl()));
        this.registry.add(this.createDescriptor("Id10", 10, (IMatchEngine.Factory)new MatchEngineFactoryImpl()));
        IItemDescriptor<IMatchEngine.Factory> higherRankedInstance = this.createDescriptor("Id100", 100, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        this.registry.add(higherRankedInstance);
        Assert.assertTrue((this.registry.getHighestRankingDescriptor() == higherRankedInstance ? 1 : 0) != 0);
    }

    @Test
    public void testGetHighestRankingItemEmptyRegistry() {
        Assert.assertTrue((this.registry.getHighestRankingDescriptor() == null ? 1 : 0) != 0);
    }

    @Test
    public void testHighestRankingItemEqualRank() {
        IItemDescriptor<IMatchEngine.Factory> instance1 = this.createDescriptor("Id1", 10, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        this.registry.add(instance1);
        IItemDescriptor<IMatchEngine.Factory> instance2 = this.createDescriptor("Id2", 10, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        this.registry.add(instance2);
        IItemDescriptor highestRankedElement = this.registry.getHighestRankingDescriptor();
        Assert.assertTrue((highestRankedElement == instance2 || highestRankedElement == instance1 ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        String id = "fakeID";
        IItemDescriptor<IMatchEngine.Factory> instance = this.createDescriptor(id, 1, (IMatchEngine.Factory)new MatchEngineFactoryImpl());
        this.registry.add(instance);
        IItemDescriptor oldValue = this.registry.remove(id);
        Assert.assertTrue((oldValue == instance ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.registry.getItemDescriptors().isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNull() {
        this.registry.remove(null);
    }

    @Test
    public void testRemoveWrongElementId() {
        String id = "fakeID";
        IItemDescriptor oldValue = this.registry.remove(id);
        Assert.assertTrue((oldValue == null ? 1 : 0) != 0);
    }

    @Test
    public void testClearRegistry() {
        this.registry.add(this.createDescriptor("Id-10", -10, (IMatchEngine.Factory)new MatchEngineFactoryImpl()));
        this.registry.add(this.createDescriptor("Id0", 0, (IMatchEngine.Factory)new MatchEngineFactoryImpl()));
        this.registry.add(this.createDescriptor("Id10", 10, (IMatchEngine.Factory)new MatchEngineFactoryImpl()));
        this.registry.clear();
        Assert.assertTrue((boolean)this.registry.getItemDescriptors().isEmpty());
    }
}

