/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.profiles;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.ProfileApplicationChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.tests.AbstractDynamicProfileTest;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.profiles.data.dynamic.DynamicProfileInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPackage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DynamicProfileTest
extends AbstractDynamicProfileTest {
    private DynamicProfileInputData input = new DynamicProfileInputData();

    @BeforeClass
    public static void setupClass() {
        DynamicProfileTest.initEPackageNsURIToProfileLocationMap();
    }

    @AfterClass
    public static void teardownClass() {
        DynamicProfileTest.resetEPackageNsURIToProfileLocationMap();
    }

    @Test
    public void testDynamicA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLDynamicA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRDynamicA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testDynamicA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLDynamicA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testMergeLtRDynamicA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testDynamicA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLDynamicA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRDynamicA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testDynamicA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLDynamicA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testMergeLtRDynamicA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testA2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Test
    public void testA3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Resource origin = this.input.getA3Origin();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        MatcherAssert.assertThat((String)"Comparison not cancelled", (Object)comparison.getDifferences(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)comparison.getDiagnostic().getSeverity(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(4)));
    }

    @Test
    public void testA4UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Resource origin = this.input.getA4Origin();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        MatcherAssert.assertThat((String)"Comparison cancelled", (Object)comparison.getDifferences(), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        Iterable leftDiffs = Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Iterable rightDiffs = Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Diff leftPA = (Diff)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)leftDiffs, (Predicate)Predicates.instanceOf(ProfileApplicationChange.class)));
        MatcherAssert.assertThat((Object)leftPA.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Diff rightPA = (Diff)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)rightDiffs, (Predicate)Predicates.instanceOf(ProfileApplicationChange.class)));
        MatcherAssert.assertThat((Object)rightPA.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Set<Conflict> conflicts = this.getConflicts(leftPA);
        MatcherAssert.assertThat((String)"Left profile application not conflicting", conflicts, (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((String)"Left and right profile applications not conflicting exactly", this.getConflicts(rightPA), (Matcher)CoreMatchers.is(conflicts));
        MatcherAssert.assertThat((String)"Some profile application conflicts is real", conflicts, (Matcher)CoreMatchers.everyItem(this.conflictIs(ConflictKind.PSEUDO)));
        Diff leftSA = (Diff)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)leftDiffs, (Predicate)Predicates.instanceOf(StereotypeApplicationChange.class)));
        MatcherAssert.assertThat((Object)leftSA.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Diff rightSA = (Diff)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)rightDiffs, (Predicate)Predicates.instanceOf(StereotypeApplicationChange.class)));
        MatcherAssert.assertThat((Object)rightSA.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
    }

    @Test
    public void testA5UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Resource origin = this.input.getA5Origin();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        MatcherAssert.assertThat((String)"Comparison not cancelled", (Object)comparison.getDifferences(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)comparison.getDiagnostic().getSeverity(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(4)));
    }

    private Set<Conflict> getConflicts(Diff diff) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        result.addAll((Iterable)Optional.fromNullable((Object)diff.getConflict()).asSet());
        for (Diff refining : diff.getRefinedBy()) {
            result.addAll(this.getConflicts(refining));
        }
        return result.build();
    }

    private Matcher<Conflict> conflictIs(final ConflictKind kind) {
        return new CustomTypeSafeMatcher<Conflict>(String.format("%s conflict", kind)){

            protected boolean matchesSafely(Conflict item) {
                return item.getKind() == kind;
            }
        };
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        Predicate addProfileApplicationDescription = null;
        Predicate addAppliedProfileInProfileApplicationDescription = null;
        Predicate addUMLAnnotationDescription = null;
        Predicate addReferencesInUMLAnnotationDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), DynamicProfileTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), DynamicProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), DynamicProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
        } else {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), DynamicProfileTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), DynamicProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), DynamicProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
        }
        addAppliedProfileInProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"appliedProfile")});
        Diff addProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addProfileApplicationDescription);
        Diff addAppliedProfileInProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addAppliedProfileInProfileApplicationDescription);
        Diff addUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addUMLAnnotationDescription);
        Diff addReferencesInUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addReferencesInUMLAnnotationDescription);
        Assert.assertNotNull((Object)addProfileApplication);
        Assert.assertNotNull((Object)addAppliedProfileInProfileApplication);
        Assert.assertNotNull((Object)addUMLAnnotation);
        Assert.assertNotNull((Object)addReferencesInUMLAnnotation);
        Assert.assertEquals((long)1L, (long)DynamicProfileTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(ProfileApplicationChange.class)));
        Diff addUMLProfileApplication = null;
        addUMLProfileApplication = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLProfileApplication);
        Assert.assertEquals((long)4L, (long)addUMLProfileApplication.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addReferencesInUMLAnnotation));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addAppliedProfileInProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addUMLAnnotation));
        Assert.assertEquals((long)0L, (long)addUMLProfileApplication.getRequires().size());
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addProfileApplication.getRequires().size());
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addProfileApplication));
            Assert.assertEquals((long)1L, (long)addReferencesInUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addReferencesInUMLAnnotation.getRequires().contains((Object)addUMLAnnotation));
        } else {
            Assert.assertEquals((long)2L, (long)addProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addAppliedProfileInProfileApplication));
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addUMLAnnotation));
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addReferencesInUMLAnnotation));
            Assert.assertEquals((long)0L, (long)addReferencesInUMLAnnotation.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

