/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import java.util.ArrayList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.tests.unit.AbstractCompareTest;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class ComparisonTest
extends AbstractCompareTest {
    @Test
    public void testMatchedResources() {
        EReference feature = ComparePackage.eINSTANCE.getComparison_MatchedResources();
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        MatchResource matchedResourcesValue = CompareFactory.eINSTANCE.createMatchResource();
        ArrayList<MatchResource> listMatchedResources = new ArrayList<MatchResource>(1);
        listMatchedResources.add(matchedResourcesValue);
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)comparison.getMatchedResources().isEmpty());
        comparison.getMatchedResources().add((Object)matchedResourcesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getMatchedResources().contains((Object)matchedResourcesValue));
        Assert.assertSame((Object)comparison.getMatchedResources(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getMatchedResources(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getMatchedResources().isEmpty());
        Assert.assertSame((Object)comparison.getMatchedResources(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getMatchedResources(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eSet((EStructuralFeature)feature, listMatchedResources);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getMatchedResources().contains((Object)matchedResourcesValue));
        Assert.assertSame((Object)comparison.getMatchedResources(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getMatchedResources(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testMatches() {
        EReference feature = ComparePackage.eINSTANCE.getComparison_Matches();
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Match matchesValue = CompareFactory.eINSTANCE.createMatch();
        ArrayList<Match> listMatches = new ArrayList<Match>(1);
        listMatches.add(matchesValue);
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)comparison.getMatches().isEmpty());
        comparison.getMatches().add((Object)matchesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getMatches().contains((Object)matchesValue));
        Assert.assertSame((Object)comparison.getMatches(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getMatches(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getMatches().isEmpty());
        Assert.assertSame((Object)comparison.getMatches(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getMatches(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eSet((EStructuralFeature)feature, listMatches);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getMatches().contains((Object)matchesValue));
        Assert.assertSame((Object)comparison.getMatches(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getMatches(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testConflicts() {
        EReference feature = ComparePackage.eINSTANCE.getComparison_Conflicts();
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Conflict conflictsValue = CompareFactory.eINSTANCE.createConflict();
        ArrayList<Conflict> listConflicts = new ArrayList<Conflict>(1);
        listConflicts.add(conflictsValue);
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        comparison.getConflicts().add((Object)conflictsValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getConflicts().contains((Object)conflictsValue));
        Assert.assertSame((Object)comparison.getConflicts(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getConflicts(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        Assert.assertSame((Object)comparison.getConflicts(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getConflicts(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eSet((EStructuralFeature)feature, listConflicts);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getConflicts().contains((Object)conflictsValue));
        Assert.assertSame((Object)comparison.getConflicts(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getConflicts(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testEquivalences() {
        EReference feature = ComparePackage.eINSTANCE.getComparison_Equivalences();
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Equivalence equivalencesValue = CompareFactory.eINSTANCE.createEquivalence();
        ArrayList<Equivalence> listEquivalences = new ArrayList<Equivalence>(1);
        listEquivalences.add(equivalencesValue);
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)comparison.getEquivalences().isEmpty());
        comparison.getEquivalences().add((Object)equivalencesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getEquivalences().contains((Object)equivalencesValue));
        Assert.assertSame((Object)comparison.getEquivalences(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getEquivalences(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getEquivalences().isEmpty());
        Assert.assertSame((Object)comparison.getEquivalences(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getEquivalences(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eSet((EStructuralFeature)feature, listEquivalences);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)comparison.getEquivalences().contains((Object)equivalencesValue));
        Assert.assertSame((Object)comparison.getEquivalences(), (Object)comparison.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)comparison.getEquivalences(), (Object)comparison.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testThreeWay() {
        EAttribute feature = ComparePackage.eINSTANCE.getComparison_ThreeWay();
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        boolean threeWayValue = this.getBooleanDistinctFromDefault((EStructuralFeature)feature);
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)((Boolean)feature.getDefaultValue()), (Object)comparison.isThreeWay());
        comparison.setThreeWay(threeWayValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)threeWayValue, (Object)comparison.isThreeWay());
        Assert.assertEquals((Object)comparison.isThreeWay(), (Object)((Boolean)comparison.eGet((EStructuralFeature)feature)));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)((Boolean)feature.getDefaultValue()), (Object)comparison.isThreeWay());
        Assert.assertEquals((Object)comparison.isThreeWay(), (Object)((Boolean)comparison.eGet((EStructuralFeature)feature)));
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.eSet((EStructuralFeature)feature, (Object)threeWayValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)threeWayValue, (Object)comparison.isThreeWay());
        Assert.assertEquals((Object)comparison.isThreeWay(), (Object)((Boolean)comparison.eGet((EStructuralFeature)feature)));
        Assert.assertTrue((boolean)comparison.eIsSet((EStructuralFeature)feature));
        comparison.setThreeWay(((Boolean)feature.getDefaultValue()).booleanValue());
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)((Boolean)feature.getDefaultValue()), (Object)comparison.isThreeWay());
        Assert.assertEquals((Object)comparison.isThreeWay(), (Object)((Boolean)comparison.eGet((EStructuralFeature)feature)));
        Assert.assertFalse((boolean)comparison.eIsSet((EStructuralFeature)feature));
    }
}

