/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.tests.nodes.NodesPackage;
import org.eclipse.emf.compare.tests.nodes.util.NodesResourceFactoryImpl;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FeatureMaps3wayMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @BeforeClass
    public static void fillEMFRegistries() {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/compare", (Object)ComparePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/compare/tests/nodes", (Object)NodesPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("nodes", new NodesResourceFactoryImpl());
    }

    @Test
    public void test3wayContainmentAdd_Left_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Right_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNull((Object)rightNode2);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Left_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Right_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNull((Object)rightNode2);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Left_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Right_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).contains(eSFFirstKey, (Object)leftNode2));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Left_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentAdd_Right_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).contains(eSFFirstKey, (Object)leftNode2));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Left_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNull((Object)rightNode2);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Right_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).contains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Left_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNull((Object)rightNode2);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Right_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).contains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Left_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode2));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Right_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Left_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode2));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentDelete_Right_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentKeyChange_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentKeyChange_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentKeyChange_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object secondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(secondKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)secondKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentKeyChange_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object secondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(secondKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)secondKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMove_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMove_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMove_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        EStructuralFeature eSFFirstKey = leftMapNode2.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode2.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMove_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        EStructuralFeature eSFFirstKey = leftMapNode2.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode2.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveToInside_LtR() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource origin = this.input.getFeatureMapContainmentMoveInsideOutsideOrigin((ResourceSet)resourceSet);
        Resource left = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        Diff featureMapChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(FeatureMapChange.class), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Diff referenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), Predicates.not((Predicate)EMFComparePredicates.isEquivalentTo((Diff)featureMapChangeDiff))}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(featureMapChangeDiff), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(referenceChangeDiff), (Monitor)new BasicMonitor());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveToInside_RtL() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource origin = this.input.getFeatureMapContainmentMoveInsideOutsideOrigin((ResourceSet)resourceSet);
        Resource left = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        Diff featureMapChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(FeatureMapChange.class), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Diff referenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), Predicates.not((Predicate)EMFComparePredicates.isEquivalentTo((Diff)featureMapChangeDiff))}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(featureMapChangeDiff), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(referenceChangeDiff), (Monitor)new BasicMonitor());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)origin, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveToOutside_LtR() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        Resource origin = this.input.getFeatureMapContainmentMoveInsideOutsideOrigin((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        Diff leftFeatureMapChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(FeatureMapChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)}));
        Diff leftReferenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), Predicates.not((Predicate)EMFComparePredicates.isEquivalentTo((Diff)leftFeatureMapChangeDiff))}));
        Diff rightReferenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertEquals((long)2L, (long)leftFeatureMapChangeDiff.getEquivalence().getDifferences().size());
        Assert.assertEquals((long)2L, (long)leftReferenceChangeDiff.getEquivalence().getDifferences().size());
        Assert.assertEquals((long)2L, (long)rightReferenceChangeDiff.getEquivalence().getDifferences().size());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftFeatureMapChangeDiff), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftReferenceChangeDiff), (Monitor)new BasicMonitor());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveToOutside_RtL() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        Resource origin = this.input.getFeatureMapContainmentMoveInsideOutsideOrigin((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        Diff leftFeatureMapChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(FeatureMapChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)}));
        Diff leftReferenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), Predicates.not((Predicate)EMFComparePredicates.isEquivalentTo((Diff)leftFeatureMapChangeDiff))}));
        Diff rightReferenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertEquals((long)2L, (long)leftFeatureMapChangeDiff.getEquivalence().getDifferences().size());
        Assert.assertEquals((long)2L, (long)leftReferenceChangeDiff.getEquivalence().getDifferences().size());
        Assert.assertEquals((long)2L, (long)rightReferenceChangeDiff.getEquivalence().getDifferences().size());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftFeatureMapChangeDiff), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftReferenceChangeDiff), (Monitor)new BasicMonitor());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveOrder_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)firstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveOrder_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)firstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveOrder_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)firstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveOrder_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)firstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveKeyChange_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveKeyChange_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFSecondKey = rightMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object firstKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveKeyChange_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFSecondKey = rightMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object firstKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayContainmentMoveKeyChange_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Left_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Right_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Assert.assertFalse((boolean)((List)leftFirstKey).contains(leftNode2));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertTrue((boolean)((List)rightFirstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertFalse((boolean)((BasicFeatureMap)leftMap).contains(eSFFirstKey, (Object)leftNode2));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMap).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Left_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Right_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Assert.assertFalse((boolean)((List)leftFirstKey).contains(leftNode2));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertTrue((boolean)((List)rightFirstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertFalse((boolean)((BasicFeatureMap)leftMap).contains(eSFFirstKey, (Object)leftNode2));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMap).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Left_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)0L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Right_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode2, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode2, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode2, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode2, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Left_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)0L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentAdd_Right_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode2, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode2, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode2, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode2, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Left_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertTrue((boolean)((List)rightFirstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMap).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Right_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Left_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertTrue((boolean)((List)rightFirstKey).isEmpty());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMap).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Right_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Left_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode2, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode2, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode2, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode2, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Right_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertTrue((boolean)((List)leftFirstKey).isEmpty());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMap).isEmpty());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Left_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode2, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode2, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode2, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode2, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentDelete_Right_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertTrue((boolean)((List)leftFirstKey).isEmpty());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMap).isEmpty());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentMoveOrder_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentMoveOrder_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentMoveOrder_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test3wayNonContainmentMoveOrder_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

