/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures;

import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.swt.graphics.Color;

public class DecoratorFigure {
    private static final int DECORATOR_THICKNESS = 6;
    private static final int ALPHA = 30;
    private IFigure fMainDecoratorFigure;
    private ICompareColor fCompareColor;
    private Diff fDifference;
    private boolean fIsThreeWay;
    private boolean fIsHighlighted;
    private boolean fIsPhantom;
    private Rectangle fBounds;
    private IFigure fReference;
    private Map<String, Object> fParameters;

    public DecoratorFigure(Diff difference, boolean isThreeWay, ICompareColor compareColor, IFigure referenceFigure, Rectangle decoratorBounds, boolean isPhantom) {
        this.preFigureCreation(difference, isThreeWay, compareColor, isPhantom, decoratorBounds, referenceFigure, null);
        this.fMainDecoratorFigure = this.createFigure();
        this.postFigureCreation();
    }

    public DecoratorFigure(Diff difference, boolean isThreeWay, ICompareColor compareColor, IFigure referenceFigure, Rectangle decoratorBounds, boolean isPhantom, Map<String, Object> parameters) {
        this.preFigureCreation(difference, isThreeWay, compareColor, isPhantom, decoratorBounds, referenceFigure, parameters);
        this.fMainDecoratorFigure = this.createFigure();
        this.postFigureCreation();
    }

    public DecoratorFigure(Diff difference, boolean isThreeWay, ICompareColor compareColor, IFigure referenceFigure, IFigure decoratorFigure, boolean isPhantom) {
        this.preFigureCreation(difference, isThreeWay, compareColor, isPhantom, decoratorFigure.getBounds().getCopy(), referenceFigure, null);
        this.fMainDecoratorFigure = decoratorFigure;
        this.postFigureCreation();
    }

    public void highlight() {
        if (!this.fIsHighlighted && this.fMainDecoratorFigure != null) {
            this.highlight(this.fMainDecoratorFigure);
            this.fIsHighlighted = true;
        }
    }

    public void unhighlight() {
        if (this.fIsHighlighted && this.fMainDecoratorFigure != null) {
            this.unhighlight(this.fMainDecoratorFigure);
            this.fIsHighlighted = false;
        }
    }

    public IFigure getMainFigure() {
        return this.fMainDecoratorFigure;
    }

    private void buildFigure() {
        if (this.isPhantom()) {
            this.buildFigureForPhantom();
        } else {
            this.buildFigureForMarker();
        }
    }

    protected void buildFigureForPhantom() {
    }

    protected void buildFigureForMarker() {
    }

    protected boolean hasToEnlarge() {
        return !this.isPhantom();
    }

    private IFigure createFigure() {
        if (this.isPhantom()) {
            return this.createFigureForPhantom();
        }
        return this.createFigureForMarker();
    }

    protected IFigure createFigureForPhantom() {
        return this.createDefaultFigure();
    }

    protected IFigure createFigureForMarker() {
        return this.createDefaultFigure();
    }

    protected RectangleFigure createDefaultFigure() {
        return new RectangleFigure();
    }

    private void highlight(IFigure figure) {
        if (this.isPhantom()) {
            this.highlightForPhantom(figure);
        } else {
            this.highlightForMarker(figure);
        }
    }

    private void unhighlight(IFigure figure) {
        if (this.isPhantom()) {
            this.unhighlightForPhantom(figure);
        } else {
            this.unhighlightForMarker(figure);
        }
    }

    protected void highlightForPhantom(IFigure figure) {
        this.defaultHighlightForPhantom(figure);
    }

    protected void defaultHighlightForPhantom(IFigure figure) {
        if (figure instanceof Shape) {
            ((Shape)figure).setLineWidth(((Shape)figure).getLineWidth() + 1);
        }
        Color strokeColor = this.getStrokeColor(true);
        figure.setForegroundColor(strokeColor);
        figure.setBackgroundColor(strokeColor);
    }

    protected void highlightForMarker(IFigure figure) {
        this.defaultHighlightForMarker(figure);
    }

    protected void defaultHighlightForMarker(IFigure figure) {
        this.defaultHighlightForPhantom(figure);
        ((Shape)figure).setAlpha(this.getAlpha());
    }

    protected void unhighlightForPhantom(IFigure figure) {
        this.defaultUnhighlightForPhantom(figure);
    }

    protected void defaultUnhighlightForPhantom(IFigure figure) {
        if (figure instanceof Shape) {
            ((Shape)figure).setLineWidth(((Shape)figure).getLineWidth() - 1);
        }
        Color strokeColor = this.getStrokeColor(false);
        figure.setForegroundColor(strokeColor);
        figure.setBackgroundColor(strokeColor);
    }

    protected void unhighlightForMarker(IFigure figure) {
        this.defaultUnhighlightForMarker(figure);
    }

    protected void defaultUnhighlightForMarker(IFigure figure) {
        this.defaultUnhighlightForPhantom(figure);
    }

    protected Map<String, Object> getParameters() {
        return this.fParameters;
    }

    protected int getAlpha() {
        return 30;
    }

    protected int getDecoratorThickness() {
        return 6;
    }

    protected Rectangle getBounds() {
        return this.fBounds;
    }

    protected IFigure getReference() {
        return this.fReference;
    }

    protected boolean isPhantom() {
        return this.fIsPhantom;
    }

    protected Color getStrokeColor(boolean isHighlight) {
        if (isHighlight) {
            return this.fCompareColor.getStrokeColor(this.fDifference, this.fIsThreeWay, false, true);
        }
        return this.fCompareColor.getStrokeColor(this.fDifference, this.fIsThreeWay, false, false);
    }

    private void preFigureCreation(Diff difference, boolean isThreeWay, ICompareColor compareColor, boolean isPhantom, Rectangle bounds, IFigure reference, Map<String, Object> parameters) {
        this.fDifference = difference;
        this.fIsThreeWay = isThreeWay;
        this.fCompareColor = compareColor;
        this.fIsPhantom = isPhantom;
        this.fBounds = bounds;
        this.fReference = reference;
        this.fParameters = parameters;
    }

    protected void postFigureCreation() {
        this.buildFigure();
        this.highlight();
    }
}

