/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;

public class AbstractGitLogicalModelTest
extends CompareGitTestCase {
    protected static final String MASTER = "refs/heads/master";
    protected static final String BRANCH = "refs/heads/branch";
    protected File file1;
    protected File file2;
    protected IFile iFile1;
    protected IFile iFile2;
    protected Resource resource1;
    protected Resource resource2;
    private ResourceSet resourceSet;
    protected IProject iProject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.iProject = this.project.getProject();
        this.resourceSet = new ResourceSetImpl();
        this.file1 = this.project.getOrCreateFile(this.iProject, "file1.ecore");
        this.file2 = this.project.getOrCreateFile(this.iProject, "file2.ecore");
        this.iFile1 = this.project.getIFile(this.iProject, this.file1);
        this.iFile2 = this.project.getIFile(this.iProject, this.file2);
        this.resource1 = this.connectResource(this.iFile1, this.resourceSet);
        this.resource2 = this.connectResource(this.iFile2, this.resourceSet);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EMFModelProvider emfModelProvider = (EMFModelProvider)ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider").getModelProvider();
        emfModelProvider.clear();
        super.tearDown();
    }

    protected Resource createAndConnectResource(String fileName) throws Exception {
        File file = this.project.getOrCreateFile(this.iProject, fileName);
        IFile iFile = this.project.getIFile(this.iProject, file);
        return this.connectResource(iFile, this.resourceSet);
    }

    protected File getFile(String fileName) throws Exception {
        return this.project.getOrCreateFile(this.iProject, fileName);
    }
}

