/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ProfileNamespaceURIPatternAPI {
    private static final String REGISTRY_CLASS = "org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternRegistry";
    private static final String REGISTRY_FIELD_INSTANCE = "INSTANCE";
    private static final String REGISTRY_METHOD_REGISTER = "register";
    private static final String REGISTRY_METHOD_UNREGISTER = "unregister";
    private static final String REGISTRY_METHOD_TRY_FIND_COMPARISON = "tryFindComparison";
    private static final String PATTERN_CLASS = "org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPattern";
    private static final String COMPARISON_CLASS = "org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternComparison";
    private static final String COMPARISON_METHOD_IS_EQUAL_VERSIONLESS_NAMESPACE_URI = "isEqualVersionlessNamespaceURI";
    private static final String OPTIONAL_METHOD_IS_PRESENT = "isPresent";
    private static final String OPTIONAL_METHOD_GET = "get";
    private static Object registryInstance;
    private static Method registryRegisterMethod;
    private static Method registryUnregisterMethod;
    private static Method registryTryFindComparisonMethod;
    private static Class<?> patternClass;
    private static Method comparisonIsEqualVersionlessNamespaceURIMethod;

    static {
        try {
            Class<?> registryClass = Class.forName(REGISTRY_CLASS);
            patternClass = Class.forName(PATTERN_CLASS);
            Class<?> comparisonClass = Class.forName(COMPARISON_CLASS);
            Field registryInstanceField = registryClass.getField(REGISTRY_FIELD_INSTANCE);
            registryInstance = registryInstanceField.get(null);
            registryTryFindComparisonMethod = registryClass.getMethod(REGISTRY_METHOD_TRY_FIND_COMPARISON, String.class, String.class);
            registryRegisterMethod = registryClass.getMethod(REGISTRY_METHOD_REGISTER, patternClass);
            registryUnregisterMethod = registryClass.getMethod(REGISTRY_METHOD_UNREGISTER, patternClass);
            comparisonIsEqualVersionlessNamespaceURIMethod = comparisonClass.getMethod(COMPARISON_METHOD_IS_EQUAL_VERSIONLESS_NAMESPACE_URI, new Class[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {}
    }

    private ProfileNamespaceURIPatternAPI() {
    }

    protected static Object callMethod(Method method, Object object, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static boolean isAvailable() {
        return comparisonIsEqualVersionlessNamespaceURIMethod != null;
    }

    public static Object createPattern(String pattern) {
        if (!ProfileNamespaceURIPatternAPI.isAvailable()) {
            return null;
        }
        Object patternObject = null;
        try {
            Constructor<?> patternConstructor = patternClass.getConstructor(String.class);
            patternObject = patternConstructor.newInstance(pattern);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        return patternObject;
    }

    public static void registerPattern(Object profileNamespaceURIPattern) {
        if (!ProfileNamespaceURIPatternAPI.isAvailable() || profileNamespaceURIPattern == null) {
            return;
        }
        ProfileNamespaceURIPatternAPI.callMethod(registryRegisterMethod, registryInstance, profileNamespaceURIPattern);
    }

    public static void unregisterPattern(Object profileNamespaceURIPattern) {
        if (!ProfileNamespaceURIPatternAPI.isAvailable() || profileNamespaceURIPattern == null) {
            return;
        }
        ProfileNamespaceURIPatternAPI.callMethod(registryUnregisterMethod, registryInstance, profileNamespaceURIPattern);
    }

    public static boolean isEqualVersionlessNamespaceURI(String lhsNamespaceUri, String rhsNamespaceUri) {
        if (!ProfileNamespaceURIPatternAPI.isAvailable()) {
            return false;
        }
        Object optionalComparison = ProfileNamespaceURIPatternAPI.callMethod(registryTryFindComparisonMethod, registryInstance, lhsNamespaceUri, rhsNamespaceUri);
        if (optionalComparison == null) {
            return false;
        }
        try {
            Method isPresentMethod = optionalComparison.getClass().getMethod(OPTIONAL_METHOD_IS_PRESENT, new Class[0]);
            isPresentMethod.setAccessible(true);
            Object isPresent = isPresentMethod.invoke(optionalComparison, new Object[0]);
            if (isPresent != null && Boolean.parseBoolean(isPresent.toString())) {
                Method getMethod = optionalComparison.getClass().getMethod(OPTIONAL_METHOD_GET, new Class[0]);
                getMethod.setAccessible(true);
                Object comparison = getMethod.invoke(optionalComparison, new Object[0]);
                if (comparison != null) {
                    Object isEqual = ProfileNamespaceURIPatternAPI.callMethod(comparisonIsEqualVersionlessNamespaceURIMethod, comparison, new Object[0]);
                    return isEqual != null && new Boolean(isEqual.toString()) != false;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        return false;
    }
}

