/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.merge.MergeBlockedByConflictException;

public class ComputeDiffsToMerge {
    private final boolean rightToLeft;
    private IMergeCriterion criterion;
    private IMerger.Registry2 registry;
    private Set<Diff> result = new LinkedHashSet<Diff>();
    private Set<Diff> computing = new HashSet<Diff>();
    private Predicate<? super Conflict> conflictChecker;

    public ComputeDiffsToMerge(boolean rightToLeft, IMerger.Registry2 registry) {
        this(rightToLeft, registry, IMergeCriterion.NONE);
    }

    public ComputeDiffsToMerge(boolean rightToLeft, IMerger.Registry2 registry, IMergeCriterion criterion) {
        this.rightToLeft = rightToLeft;
        this.registry = registry;
        this.criterion = (IMergeCriterion)Preconditions.checkNotNull((Object)criterion);
    }

    public ComputeDiffsToMerge failOnRealConflictUnless(Predicate<? super Conflict> predicate) {
        this.conflictChecker = predicate;
        return this;
    }

    public Set<Diff> getAllDiffsToMerge(Diff diff) {
        this.result.clear();
        this.computing.clear();
        this.addDiff(diff);
        return this.result;
    }

    protected void addDiff(Diff diff) {
        this.addDiffs(Collections.singleton(diff));
    }

    protected void addDiffs(Collection<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        LinkedHashSet<Diff> consequences = new LinkedHashSet<Diff>();
        for (Diff diff : diffs) {
            this.addDiff(diff, consequences);
        }
        this.addDiffs((Collection<Diff>)Sets.difference(consequences, this.result));
    }

    protected void addDiff(Diff diff, Set<Diff> consequences) {
        if (!this.result.contains(diff) && this.computing.add(diff)) {
            Conflict conflict = diff.getConflict();
            if (this.conflictChecker != null && conflict != null && !this.conflictChecker.apply((Object)conflict) && diff.getConflict().getKind() == ConflictKind.REAL) {
                ArrayList<Diff> diffsThatLedToConflict = new ArrayList<Diff>(this.result);
                diffsThatLedToConflict.add(diff);
                throw new MergeBlockedByConflictException(diffsThatLedToConflict);
            }
            DelegatingMerger mergerDelegate = AbstractMerger.getMergerDelegate(diff, this.registry, this.criterion);
            IMerger merger = mergerDelegate.getMerger();
            if (merger instanceof IMerger2) {
                Set<Diff> dependencies = ((IMerger2)merger).getDirectMergeDependencies(diff, this.rightToLeft);
                for (Diff required : dependencies) {
                    this.addDiff(required, consequences);
                }
                this.result.add(diff);
                this.computing.remove(diff);
                consequences.addAll(((IMerger2)merger).getDirectResultingMerges(diff, this.rightToLeft));
            } else {
                this.result.add(diff);
            }
        }
    }
}

