/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;

public class EMFResourceMapping
extends ResourceMapping {
    private final IResource resource;
    private final ResourceMappingContext initialContext;
    private final SynchronizationModel synchronizationModel;
    private final String providerId;
    private SynchronizationModel latestModel;

    public EMFResourceMapping(IResource resource, ResourceMappingContext initialContext, SynchronizationModel synchronizationModel, String providerId) {
        this.resource = (IResource)Preconditions.checkNotNull((Object)resource);
        this.initialContext = (ResourceMappingContext)Preconditions.checkNotNull((Object)initialContext);
        this.synchronizationModel = (SynchronizationModel)Preconditions.checkNotNull((Object)synchronizationModel);
        this.providerId = (String)Preconditions.checkNotNull((Object)providerId);
    }

    public Object getModelObject() {
        return this.synchronizationModel;
    }

    public String getModelProviderId() {
        return this.providerId;
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        SynchronizationModel syncModel;
        if (context == this.initialContext || !(this.resource instanceof IFile)) {
            syncModel = this.synchronizationModel;
        } else {
            SynchronizationModel temp = null;
            try {
                temp = ((EMFModelProvider)this.getModelProvider()).getOrComputeLogicalModel((IFile)this.resource, context, monitor);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                temp = this.synchronizationModel;
            }
            syncModel = temp;
        }
        this.latestModel = syncModel;
        return this.convertToTraversal(syncModel);
    }

    private ResourceTraversal[] convertToTraversal(SynchronizationModel syncModel) {
        Set<IResource> resources = syncModel.getResources();
        IResource[] resourcesArray = resources.toArray(new IResource[resources.size()]);
        return new ResourceTraversal[]{new ResourceTraversal(resourcesArray, 0, 0)};
    }

    private static ResourceTraversal[] createSingletonTraversal(IResource aResource) {
        ResourceTraversal singletonTraversal = new ResourceTraversal(new IResource[]{aResource}, 1, 0);
        return new ResourceTraversal[]{singletonTraversal};
    }

    public final SynchronizationModel getLatestModel() {
        return this.latestModel;
    }

    public boolean equals(Object other) {
        if (other instanceof EMFResourceMapping) {
            return this.synchronizationModel.equals(((EMFResourceMapping)((Object)other)).synchronizationModel);
        }
        return false;
    }

    public int hashCode() {
        return this.synchronizationModel.hashCode();
    }

    public IProject[] getProjects() {
        LinkedHashSet projects = Sets.newLinkedHashSet();
        if (this.synchronizationModel.getDiagnostic().getSeverity() >= 4) {
            return new IProject[]{this.resource.getProject()};
        }
        for (IResource res : this.synchronizationModel.getResources()) {
            projects.add(res.getProject());
        }
        IProject[] projectArray = projects.toArray(new IProject[projects.size()]);
        return projectArray;
    }
}

