/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.match;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.AbstractItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.extension.impl.WrapperItemDescriptor;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchEngineFactoryRegistryWrapper
implements IMatchEngine.Factory.Registry {
    private static final String EMPTY_STRING = "";
    private IItemRegistry<IMatchEngine.Factory> registry;
    private final IEclipsePreferences preferences;

    public MatchEngineFactoryRegistryWrapper(IItemRegistry<IMatchEngine.Factory> registy, IEclipsePreferences preferences) {
        this.registry = registy;
        this.preferences = preferences;
    }

    private Collection<IMatchEngine.Factory> getEnabledFactories() {
        Function toFactoryFunction = AbstractItemDescriptor.getItemFunction();
        Collection enableFactories = Collections2.filter(this.registry.getItemDescriptors(), (Predicate)Predicates.not((Predicate)Predicates.in(this.getDisabledEngines())));
        return Collections2.transform((Collection)enableFactories, toFactoryFunction);
    }

    public IMatchEngine.Factory getHighestRankingMatchEngineFactory(IComparisonScope scope) {
        IMatchEngine.Factory result = null;
        for (IMatchEngine.Factory engineFactory : this.getMatchEngineFactories(scope)) {
            if (result != null && engineFactory.getRanking() <= result.getRanking()) continue;
            result = engineFactory;
        }
        return result;
    }

    public List<IMatchEngine.Factory> getMatchEngineFactories(IComparisonScope scope) {
        Iterable matchEngineFactories = Iterables.filter(this.getEnabledFactories(), MatchEngineFactoryRegistryWrapper.isMatchEngineFactoryActivable(scope));
        return Lists.newArrayList((Iterable)matchEngineFactories);
    }

    private static Predicate<IMatchEngine.Factory> isMatchEngineFactoryActivable(final IComparisonScope scope) {
        return new Predicate<IMatchEngine.Factory>(){

            public boolean apply(IMatchEngine.Factory factory) {
                return factory.isMatchEngineFactoryFor(scope);
            }
        };
    }

    public IMatchEngine.Factory add(IMatchEngine.Factory factory) {
        Preconditions.checkNotNull((Object)factory);
        IItemDescriptor<IMatchEngine.Factory> oldFactoryDescriptor = this.registry.add(new WrapperItemDescriptor<IMatchEngine.Factory>(EMPTY_STRING, EMPTY_STRING, factory.getRanking(), factory.getClass().getName(), factory));
        if (oldFactoryDescriptor != null) {
            return oldFactoryDescriptor.getItem();
        }
        return null;
    }

    public IMatchEngine.Factory remove(String className) {
        Preconditions.checkNotNull((Object)className);
        IItemDescriptor<IMatchEngine.Factory> remove = this.registry.remove(className);
        if (remove != null) {
            return remove.getItem();
        }
        return null;
    }

    public void clear() {
        this.registry.clear();
    }

    private Collection<IItemDescriptor<IMatchEngine.Factory>> getDisabledEngines() {
        List<IItemDescriptor<Object>> result = ItemUtil.getItemsDescriptor(this.registry, "org.eclipse.emf.compare.preference.match.engine", (Preferences)this.preferences);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }
}

