/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.papyrus.internal;

import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.diagram.papyrus.internal.DiffIndexer;
import org.eclipse.emf.compare.diagram.papyrus.internal.IDiffHandler;
import org.eclipse.emf.compare.diagram.papyrus.internal.PapyrusDiagram2WayDiffHandler;
import org.eclipse.emf.compare.diagram.papyrus.internal.PapyrusDiagram3WayDiffHandler;

public class PapyrusDiagramPostComparison
implements Runnable {
    private final Comparison comparison;
    private final DiffIndexer indexer;

    public PapyrusDiagramPostComparison(Comparison comparison) {
        this.comparison = comparison;
        this.indexer = new DiffIndexer();
    }

    public void run() {
        IDiffHandler handler = this.getHandler();
        for (Diff diff : this.comparison.getDifferences()) {
            handler.handle(diff);
        }
        this.linkEquivalentDiffsWithRequiresRelations();
    }

    private void linkEquivalentDiffsWithRequiresRelations() {
        for (Object key : this.indexer.getEquivalentDiffsKeySet()) {
            Set<Diff> diffs = this.indexer.getEquivalentDiffs(key);
            if (diffs.size() <= 1) continue;
            for (Diff diff : diffs) {
                for (Diff other : diffs) {
                    if (other == diff || other.getSource() != diff.getSource()) continue;
                    diff.getRequires().add((Object)other);
                }
            }
        }
    }

    protected IDiffHandler getHandler() {
        if (this.comparison.isThreeWay()) {
            return new PapyrusDiagram3WayDiffHandler(this.indexer);
        }
        return new PapyrusDiagram2WayDiffHandler(this.indexer);
    }
}

