/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.impl.GroupsInteractiveContent;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.impl.ItemDescriptorLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.emf.compare.rcp.ui.preferencePage.groups";
    private static final String SYNC_DEFAULT_VALUE = "prompt";
    private static final List<String> SYNC_VALUES = Lists.newArrayList((Object[])new String[]{"always", "never", "prompt"});
    private static final String TWO_WAY_COMPARISON_SYNC_BEHAVIOR = "org.eclipse.emf.compare.rcp.ui.groups.2way.syncbehavior";
    private static final String THREE_WAY_COMPARISON_SYNC_BEHAVIOR = "org.eclipse.emf.compare.rcp.ui.groups.3ways.syncbehavior";
    private GroupsInteractiveContent twoWayComparisonContent;
    private GroupsInteractiveContent threeWayComparisonContent;
    private DifferenceGroupManager groupManager = new DifferenceGroupManager(EMFCompareRCPUIPlugin.getDefault().getEMFCompareUIPreferences(), EMFCompareRCPUIPlugin.getDefault().getItemDifferenceGroupProviderRegistry());

    public static String getGroupSynchronizationPreferenceKey(boolean isThreeWay) {
        if (isThreeWay) {
            return THREE_WAY_COMPARISON_SYNC_BEHAVIOR;
        }
        return TWO_WAY_COMPARISON_SYNC_BEHAVIOR;
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp.ui");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, true));
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fillTwoWayComparisonTab(tabFolder);
        this.fillThreeWayComparisonTab(tabFolder);
        return container;
    }

    private void fillTwoWayComparisonTab(TabFolder tabFolder) {
        Composite tabSkeletonComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("GroupsPreferencePage.twoWayComparisonTab.label"), EMFCompareRCPUIMessages.getString("GroupsPreferencePage.viewerDescription.label"));
        List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> currentGroupRanking = this.groupManager.getCurrentGroupRanking(false);
        this.twoWayComparisonContent = this.createInteractiveContent(tabSkeletonComposite, currentGroupRanking, currentGroupRanking.get(0));
        this.twoWayComparisonContent.setComboInput(this.getCurrentSynchronizationBehavior(false));
    }

    private void fillThreeWayComparisonTab(TabFolder tabFolder) {
        Composite tabSkeletonComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("GroupsPreferencePage.threeWayComparisonTab.label"), EMFCompareRCPUIMessages.getString("GroupsPreferencePage.viewerDescription.label"));
        List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> currentGroupRanking = this.groupManager.getCurrentGroupRanking(true);
        this.threeWayComparisonContent = this.createInteractiveContent(tabSkeletonComposite, currentGroupRanking, currentGroupRanking.get(0));
        this.threeWayComparisonContent.setComboInput(this.getCurrentSynchronizationBehavior(true));
    }

    private GroupsInteractiveContent createInteractiveContent(Composite parent, List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> input, IItemDescriptor<IDifferenceGroupProvider.Descriptor> defaultSelection) {
        GroupsInteractiveContent interactiveUI = new GroupsInteractiveContent(parent);
        this.createViewer(interactiveUI);
        interactiveUI.setViewerInput(input);
        interactiveUI.select(defaultSelection);
        return interactiveUI;
    }

    private Composite createTabSkeleton(TabFolder tabFolder, String tabLabel, String introText) {
        TabItem tbtmMain = new TabItem(tabFolder, 0);
        tbtmMain.setText(tabLabel);
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tbtmMain.setControl((Control)tabComposite);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        tabComposite.setLayoutData((Object)layoutData);
        Label introductionText = new Label(tabComposite, 64);
        introductionText.setText(introText);
        return tabComposite;
    }

    private void createViewer(GroupsInteractiveContent interactiveUI) {
        int style = 68100;
        ListViewer descriptorViewer = new ListViewer(interactiveUI.getViewerComposite(), style);
        interactiveUI.setViewer(descriptorViewer);
        descriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        descriptorViewer.setLabelProvider((IBaseLabelProvider)new ItemDescriptorLabelProvider());
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        descriptorViewer.getControl().setLayoutData((Object)gd);
    }

    public boolean performOk() {
        this.groupManager.setCurrentGroupRanking(this.twoWayComparisonContent.getOrderedItems(), false);
        this.setCurrentSynchronizationBehavior(this.twoWayComparisonContent.getSynchronizationBehavior(), false);
        this.groupManager.setCurrentGroupRanking(this.threeWayComparisonContent.getOrderedItems(), true);
        this.setCurrentSynchronizationBehavior(this.threeWayComparisonContent.getSynchronizationBehavior(), true);
        return super.performOk();
    }

    protected void performDefaults() {
        this.resetGroupPreference(false, this.twoWayComparisonContent);
        this.resetGroupPreference(true, this.threeWayComparisonContent);
        super.performDefaults();
    }

    private void resetGroupPreference(boolean isThreeWay, GroupsInteractiveContent interactiveContent) {
        interactiveContent.setViewerInput(this.groupManager.getDefaultRankingConfiguration(isThreeWay));
        interactiveContent.setComboInput(SYNC_DEFAULT_VALUE);
    }

    public void setCurrentSynchronizationBehavior(String newBehavior, boolean isThreeWay) {
        Preconditions.checkArgument((boolean)SYNC_VALUES.contains(newBehavior));
        if (!SYNC_DEFAULT_VALUE.equals(newBehavior)) {
            this.getPreferenceStore().putValue(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(isThreeWay), newBehavior);
        } else {
            this.getPreferenceStore().setToDefault(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(isThreeWay));
        }
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder builder = new StringBuilder();
            builder.append("Preference ").append(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(isThreeWay)).append(":\n");
            String preferenceValue = this.getPreferenceStore().getString(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(isThreeWay));
            builder.append(preferenceValue);
            EMFCompareRCPUIPlugin.getDefault().log(1, builder.toString());
        }
    }

    public String getCurrentSynchronizationBehavior(boolean isThreeWay) {
        String prefValue = this.getPreferenceStore().getString(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(isThreeWay));
        if (SYNC_VALUES.contains(prefValue)) {
            return prefValue;
        }
        return SYNC_DEFAULT_VALUE;
    }
}

