/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.merge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.WorkingTreeFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.revision.LocalFileRevision;
import org.eclipse.egit.ui.internal.revision.LocationEditableRevision;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.emf.compare.egit.internal.merge.DirCacheResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.LogicalModels;
import org.eclipse.emf.compare.egit.ui.internal.EMFCompareEGitUIMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelGitMergeEditorInput
extends CompareEditorInput {
    private static final String LABELPATTERN = "{0} - {1}";
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image PROJECT_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final boolean useWorkspace;
    private final IPath[] locations;

    public ModelGitMergeEditorInput(boolean useWorkspace, IPath ... locations) {
        super(new CompareConfiguration());
        this.useWorkspace = useWorkspace;
        this.locations = locations;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setLeftEditable(true);
    }

    public Object getAdapter(Class adapter) {
        DiffNode diffNode;
        ITypedElement element;
        Object selectedEdition;
        if ((adapter == IFile.class || adapter == IResource.class) && ModelGitMergeEditorInput.isUIThread() && (selectedEdition = this.getSelectedEdition()) instanceof DiffNode && (element = (diffNode = (DiffNode)selectedEdition).getLeft()) instanceof ResourceEditableRevision) {
            ResourceEditableRevision resourceRevision = (ResourceEditableRevision)element;
            return resourceRevision.getFile();
        }
        return super.getAdapter(adapter);
    }

    private static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(UIText.GitMergeEditorInput_CheckingResourcesTaskName, -1);
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(this.locations));
        if (pathsByRepository.size() != 1) {
            throw new InvocationTargetException(new IllegalStateException(UIText.RepositoryAction_multiRepoSelection));
        }
        Repository repository = (Repository)pathsByRepository.keySet().iterator().next();
        ArrayList<String> filterPaths = new ArrayList<String>((Collection)pathsByRepository.get(repository));
        this.checkCanceled(monitor);
        RevWalk rw = null;
        try {
            rw = new RevWalk(repository);
            RevCommit rightCommit = this.getRightCommit(rw, repository);
            RevCommit headCommit = this.getLeftCommit(rw, repository);
            RevCommit ancestorCommit = this.getCommonAncestor(rw, rightCommit, headCommit);
            this.checkCanceled(monitor);
            this.setLabels(repository, rightCommit, headCommit, ancestorCommit);
            ICompareInput input = this.prepareCompareInput(repository, filterPaths, monitor);
            if (input != null) {
                ICompareInput iCompareInput = input;
                return iCompareInput;
            }
            this.checkCanceled(monitor);
            IDiffContainer iDiffContainer = this.buildDiffContainer(repository, headCommit, ancestorCommit, filterPaths, rw, monitor);
            return iDiffContainer;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (rw != null) {
                rw.close();
                rw.dispose();
            }
            repository.close();
            monitor.done();
        }
    }

    private void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private ICompareInput prepareCompareInput(Repository repository, List<String> filterPaths, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            DirCacheResourceVariantTreeProvider variantTreeProvider = new DirCacheResourceVariantTreeProvider(repository, this.useWorkspace);
            GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber((GitResourceVariantTreeProvider)variantTreeProvider);
            this.checkCanceled(monitor);
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
            IResource[] iResourceArray = subscriber.roots();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource root = iResourceArray[n2];
                projects.add(root.getProject());
                ++n2;
            }
            LinkedHashSet<IResource> resourcesInOperation = new LinkedHashSet<IResource>();
            boolean outOfWS = false;
            IPath[] iPathArray = this.locations;
            int n3 = this.locations.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                boolean foundMatchInWS = false;
                Iterator projectIterator = projects.iterator();
                while (!foundMatchInWS && projectIterator.hasNext()) {
                    IProject project = (IProject)projectIterator.next();
                    IPath projectLocation = project.getLocation();
                    if (projectLocation.equals((Object)path)) {
                        resourcesInOperation.addAll(this.getConflictingFilesFrom((IContainer)project));
                        foundMatchInWS = true;
                        continue;
                    }
                    if (!project.getLocation().isPrefixOf(path)) continue;
                    IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
                    if (resource instanceof IContainer) {
                        resourcesInOperation.addAll(this.getConflictingFilesFrom((IContainer)resource));
                    } else {
                        resourcesInOperation.add(resource);
                    }
                    foundMatchInWS = true;
                }
                if (!foundMatchInWS) {
                    if (!resourcesInOperation.isEmpty()) break;
                    outOfWS = true;
                } else if (outOfWS) break;
                ++n4;
            }
            this.checkCanceled(monitor);
            if (!resourcesInOperation.isEmpty() && outOfWS) {
                throw new InvocationTargetException(new IllegalStateException(EMFCompareEGitUIMessages.getString("GitMergeEditorInput_OutOfWSResources")));
            }
            if (!resourcesInOperation.isEmpty()) {
                ISynchronizationCompareAdapter compareAdapter;
                SubscriberResourceMappingContext remoteMappingContext = new SubscriberResourceMappingContext((Subscriber)subscriber, true);
                Set model = null;
                for (IResource comparedResource : resourcesInOperation) {
                    model = LogicalModels.discoverModel((IResource)comparedResource, (ResourceMappingContext)remoteMappingContext);
                    if (model.isEmpty()) continue;
                    if (model.containsAll(resourcesInOperation)) break;
                    throw new RuntimeException(EMFCompareEGitUIMessages.getString("GitMergeEditorInput_MultipleModels"));
                }
                if ((compareAdapter = (ISynchronizationCompareAdapter)LogicalModels.findAdapter(model, ISynchronizationCompareAdapter.class)) != null) {
                    Set allMappings = LogicalModels.getResourceMappings((Set)model, (ResourceMappingContext)remoteMappingContext);
                    this.checkCanceled(monitor);
                    ISynchronizationContext synchronizationContext = this.prepareSynchronizationContext(repository, (Subscriber)subscriber, allMappings, (RemoteResourceMappingContext)remoteMappingContext);
                    Object modelObject = ((ResourceMapping)allMappings.iterator().next()).getModelObject();
                    if (compareAdapter.hasCompareInput(synchronizationContext, modelObject)) {
                        return compareAdapter.asCompareInput(synchronizationContext, modelObject);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        return null;
    }

    private Set<IResource> getConflictingFilesFrom(IContainer container) throws IOException {
        LinkedHashSet<IResource> conflictingResources = new LinkedHashSet<IResource>();
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)container);
        if (mapping == null) {
            return conflictingResources;
        }
        IndexDiffCacheEntry indexDiffCacheEntry = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(mapping.getRepository());
        if (indexDiffCacheEntry == null) {
            return conflictingResources;
        }
        IndexDiffData indexDiffData = indexDiffCacheEntry.getIndexDiff();
        if (indexDiffData != null) {
            IPath containerPath = container.getLocation();
            File workTree = mapping.getWorkTree();
            if (workTree != null) {
                Path workDirPrefix = new Path(workTree.getCanonicalPath());
                for (String conflicting : indexDiffData.getConflicting()) {
                    IPath resourcePath = workDirPrefix.append(conflicting);
                    if (!containerPath.isPrefixOf(resourcePath)) continue;
                    IPath containerRelativePath = resourcePath.removeFirstSegments(containerPath.segmentCount());
                    conflictingResources.add((IResource)container.getFile(containerRelativePath));
                }
            }
        }
        return conflictingResources;
    }

    private ISynchronizationContext prepareSynchronizationContext(final Repository repository, Subscriber subscriber, Set<ResourceMapping> allModelMappings, RemoteResourceMappingContext mappingContext) throws CoreException, OperationCanceledException, InterruptedException {
        ResourceMapping[] mappings = allModelMappings.toArray(new ResourceMapping[allModelMappings.size()]);
        SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, subscriber, mappingContext, true){

            public ISchedulingRule getSchedulingRule() {
                return RuleUtil.getRule((Repository)repository);
            }
        };
        manager.initialize((IProgressMonitor)new NullProgressMonitor());
        GitSynchronizationContext context = new GitSynchronizationContext(subscriber, (ISynchronizationScopeManager)manager);
        Job.getJobManager().join((Object)context, (IProgressMonitor)new NullProgressMonitor());
        return context;
    }

    private RevCommit getRightCommit(RevWalk revWalk, Repository repository) throws InvocationTargetException {
        try {
            String target = repository.getRepositoryState().equals((Object)RepositoryState.MERGING) ? "MERGE_HEAD" : (repository.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING) ? "CHERRY_PICK_HEAD" : (repository.getRepositoryState().equals((Object)RepositoryState.REBASING_INTERACTIVE) ? this.readFile(repository.getDirectory(), "rebase-merge" + File.separatorChar + "stopped-sha") : "ORIG_HEAD"));
            ObjectId mergeHead = repository.resolve(target);
            if (mergeHead == null) {
                throw new IOException(NLS.bind((String)UIText.ValidationUtils_CanNotResolveRefMessage, (Object)target));
            }
            return revWalk.parseCommit((AnyObjectId)mergeHead);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RevCommit getLeftCommit(RevWalk revWalk, Repository repository) throws InvocationTargetException {
        try {
            ObjectId head = repository.resolve("HEAD");
            if (head == null) {
                throw new IOException(NLS.bind((String)UIText.ValidationUtils_CanNotResolveRefMessage, (Object)"HEAD"));
            }
            return revWalk.parseCommit((AnyObjectId)head);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RevCommit getCommonAncestor(RevWalk revWalk, RevCommit rightCommit, RevCommit leftCommit) {
        ArrayList<RevCommit> startPoints = new ArrayList<RevCommit>();
        revWalk.setRevFilter(RevFilter.MERGE_BASE);
        startPoints.add(rightCommit);
        startPoints.add(leftCommit);
        try {
            revWalk.markStart(startPoints);
            return revWalk.next();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setLabels(Repository repository, RevCommit rightCommit, RevCommit leftCommit, RevCommit ancestorCommit) throws InvocationTargetException {
        String fullBranch;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setRightLabel(NLS.bind((String)LABELPATTERN, (Object)rightCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision((String)rightCommit.name())));
        if (!this.useWorkspace) {
            config.setLeftLabel(NLS.bind((String)LABELPATTERN, (Object)leftCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision((String)leftCommit.name())));
        } else {
            config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceHeader);
        }
        if (ancestorCommit != null) {
            config.setAncestorLabel(NLS.bind((String)LABELPATTERN, (Object)ancestorCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision((String)ancestorCommit.name())));
        }
        try {
            fullBranch = repository.getFullBranch();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        this.setTitle(NLS.bind((String)UIText.GitMergeEditorInput_MergeEditorTitle, (Object[])new Object[]{Activator.getDefault().getRepositoryUtil().getRepositoryName(repository), rightCommit.getShortMessage(), fullBranch}));
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getNavigator().selectChange(true);
    }

    protected void handleDispose() {
        super.handleDispose();
    }

    private IDiffContainer buildDiffContainer(Repository repository, RevCommit headCommit, RevCommit ancestorCommit, List<String> filterPaths, RevWalk rw, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.setTaskName(UIText.GitMergeEditorInput_CalculatingDiffTaskName);
        DiffNode result = new DiffNode(12);
        TreeWalk tw = new TreeWalk(repository);
        try {
            int dirCacheIndex = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
            int fileTreeIndex = tw.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
            int repositoryTreeIndex = tw.addTree((AnyObjectId)rw.parseTree((AnyObjectId)repository.resolve("HEAD")));
            NotIgnoredFilter notIgnoredFilter = new NotIgnoredFilter(fileTreeIndex);
            if (filterPaths.size() > 1) {
                ArrayList<PathFilter> suffixFilters = new ArrayList<PathFilter>();
                for (String filterPath : filterPaths) {
                    suffixFilters.add(PathFilter.create((String)filterPath));
                }
                TreeFilter otf = OrTreeFilter.create(suffixFilters);
                tw.setFilter(AndTreeFilter.create((TreeFilter)otf, (TreeFilter)notIgnoredFilter));
            } else if (filterPaths.size() > 0) {
                String path = filterPaths.get(0);
                if (path.length() == 0) {
                    tw.setFilter((TreeFilter)notIgnoredFilter);
                } else {
                    tw.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)notIgnoredFilter));
                }
            } else {
                tw.setFilter((TreeFilter)notIgnoredFilter);
            }
            tw.setRecursive(true);
            while (tw.next()) {
                ITypedElement right;
                boolean modified;
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String gitPath = tw.getPathString();
                monitor.setTaskName(gitPath);
                FileTreeIterator fit = (FileTreeIterator)tw.getTree(fileTreeIndex, FileTreeIterator.class);
                if (fit == null) continue;
                DirCacheIterator dit = (DirCacheIterator)tw.getTree(dirCacheIndex, DirCacheIterator.class);
                DirCacheEntry dirCacheEntry = dit == null ? null : dit.getDirCacheEntry();
                boolean conflicting = dirCacheEntry != null && dirCacheEntry.getStage() > 0;
                AbstractTreeIterator rt = tw.getTree(repositoryTreeIndex, AbstractTreeIterator.class);
                boolean bl = modified = rt != null && !fit.getEntryObjectId().equals((AnyObjectId)rt.getEntryObjectId());
                if (!conflicting && !modified) continue;
                if (conflicting) {
                    GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)3);
                    String encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                    right = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                } else {
                    right = CompareUtils.getFileRevisionTypedElement((String)gitPath, (RevCommit)headCommit, (Repository)repository);
                }
                if (right instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) continue;
                Path repositoryPath = new Path(repository.getWorkTree().getAbsolutePath());
                IPath location = repositoryPath.append(fit.getEntryPathString());
                IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
                Object rev = !conflicting || this.useWorkspace ? (file != null ? new LocalFileRevision(file) : new WorkingTreeFileRevision(location.toFile())) : GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)2);
                ICompareContainer runnableContext = this.getContainer();
                if (runnableContext == null) {
                    runnableContext = PlatformUI.getWorkbench().getProgressService();
                }
                Object leftEditable = file != null ? new ResourceEditableRevision((IFileRevision)rev, file, (IRunnableContext)runnableContext) : new LocationEditableRevision((IFileRevision)rev, location, (IRunnableContext)runnableContext);
                try {
                    leftEditable.cacheContents(monitor);
                }
                catch (CoreException e) {
                    throw new IOException(e.getMessage());
                }
                int kind = 0;
                if (conflicting) {
                    kind = 12;
                } else if (modified) {
                    kind = 16;
                }
                IDiffContainer fileParent = this.getFileParent((IDiffContainer)result, (IPath)repositoryPath, file, location);
                ITypedElement anc = ancestorCommit != null ? CompareUtils.getFileRevisionTypedElement((String)gitPath, (RevCommit)ancestorCommit, (Repository)repository) : null;
                if (anc instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) {
                    anc = null;
                }
                new DiffNode(fileParent, kind, anc, (ITypedElement)leftEditable, right);
            }
            DiffNode diffNode = result;
            return diffNode;
        }
        finally {
            tw.close();
        }
    }

    private IDiffContainer getFileParent(IDiffContainer root, IPath repositoryPath, IFile file, IPath location) {
        IProject project;
        IPath projectLocation;
        int projectSegment = -1;
        String projectName = null;
        if (file != null && (projectLocation = (project = file.getProject()).getLocation()) != null) {
            IPath projectPath = project.getLocation().makeRelativeTo(repositoryPath);
            projectSegment = projectPath.segmentCount() - 1;
            projectName = project.getName();
        }
        IPath path = location.makeRelativeTo(repositoryPath);
        IDiffContainer child = root;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            child = i == projectSegment ? this.getOrCreateChild(child, projectName, true) : this.getOrCreateChild(child, path.segment(i), false);
            ++i;
        }
        return child;
    }

    private DiffNode getOrCreateChild(IDiffContainer parent, final String name, final boolean projectMode) {
        Object child;
        IDiffElement[] iDiffElementArray = parent.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iDiffElementArray[n2];
            if (child.getName().equals(name)) {
                return (DiffNode)child;
            }
            ++n2;
        }
        child = new DiffNode(parent, 0){

            public String getName() {
                return name;
            }

            public Image getImage() {
                if (projectMode) {
                    return PROJECT_IMAGE;
                }
                return FOLDER_IMAGE;
            }
        };
        return child;
    }

    private String readFile(File directory, String fileName) throws IOException {
        byte[] content = IO.readFully((File)new File(directory, fileName));
        int end = content.length;
        while (end > 0 && content[end - 1] == 10) {
            --end;
        }
        return RawParseUtils.decode((byte[])content, (int)0, (int)end);
    }

    private static class GitSynchronizationContext
    extends SubscriberMergeContext {
        public GitSynchronizationContext(Subscriber subscriber, ISynchronizationScopeManager scopeManager) {
            super(subscriber, scopeManager);
            this.initialize();
        }

        public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        }

        public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }

        protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }
    }
}

