/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.subversive.internal.adapter;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.svn.core.PathForURL;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SubversiveFileRevision
extends FileRevision {
    private IRepositoryResource repositoryResource;
    private ResourceCompareInput.ResourceElement resourceElement;

    public SubversiveFileRevision(IRepositoryResource repositoryResource, ResourceCompareInput.ResourceElement resourceElement) {
        this.repositoryResource = (IRepositoryResource)Preconditions.checkNotNull((Object)repositoryResource);
        this.resourceElement = (ResourceCompareInput.ResourceElement)Preconditions.checkNotNull((Object)resourceElement);
    }

    public URI getURI() {
        try {
            URI uri = new URI(this.repositoryResource.getUrl());
            return uri;
        }
        catch (URISyntaxException e) {
            Bundle bundle = FrameworkUtil.getBundle(SubversiveFileRevision.class);
            ILog log = Platform.getLog((Bundle)bundle);
            Status status = new Status(4, bundle.getSymbolicName(), e.getMessage(), (Throwable)e);
            log.log((IStatus)status);
            return null;
        }
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return this;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public String getName() {
        return this.resourceElement.getName();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return !SubversiveFileRevision.this.resourceElement.isEditable();
            }

            public String getName() {
                return SubversiveFileRevision.this.resourceElement.getName();
            }

            public IPath getFullPath() {
                String url = SubversiveFileRevision.this.repositoryResource.getUrl();
                PathForURL path = new PathForURL(url, true);
                return path;
            }

            public InputStream getContents() throws CoreException {
                return SubversiveFileRevision.this.resourceElement.getContents();
            }
        };
    }
}

