/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.compare.ide.ui.internal.logical.FileRevisionStorageProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.ResourceVariantStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;

public final class SubscriberStorageAccessor
implements IStorageProviderAccessor {
    private final Subscriber subscriber;
    private final IResourceVariantTree originTree;
    private final IResourceVariantTree remoteTree;
    private final IResourceVariantTree sourceTree;

    public SubscriberStorageAccessor(Subscriber subscriber) {
        this.subscriber = subscriber;
        this.originTree = SubscriberStorageAccessor.initTree(subscriber, "getBaseTree");
        this.remoteTree = SubscriberStorageAccessor.initTree(subscriber, "getRemoteTree");
        this.sourceTree = SubscriberStorageAccessor.initTree(subscriber, "getSourceTree");
    }

    public IStorageProvider getStorageProvider(IResource resource, IStorageProviderAccessor.DiffSide side) throws CoreException {
        IStorageProvider provider;
        switch (side) {
            case SOURCE: {
                provider = this.getSourceVariant(resource);
                break;
            }
            case REMOTE: {
                provider = this.getRemoteVariant(resource);
                break;
            }
            case ORIGIN: {
                provider = this.getOriginVariant(resource);
                break;
            }
            default: {
                provider = null;
            }
        }
        return provider;
    }

    public boolean isInSync(IResource resource) throws CoreException {
        return this.subscriber.getDiff(resource) == null;
    }

    private IStorageProvider getOriginVariant(IResource resource) throws CoreException {
        if (this.originTree != null) {
            return SubscriberStorageAccessor.wrapStorageProvider(this.originTree.getResourceVariant(resource));
        }
        IDiff diff = this.subscriber.getDiff(resource);
        return SubscriberStorageAccessor.wrapStorageProvider(SubscriberStorageAccessor.getOrigin(diff));
    }

    private IStorageProvider getSourceVariant(IResource resource) throws CoreException {
        if (this.sourceTree != null) {
            return SubscriberStorageAccessor.wrapStorageProvider(this.sourceTree.getResourceVariant(resource));
        }
        IDiff diff = this.subscriber.getDiff(resource);
        return SubscriberStorageAccessor.wrapStorageProvider(SubscriberStorageAccessor.getSource(diff));
    }

    private IStorageProvider getRemoteVariant(IResource resource) throws CoreException {
        if (this.remoteTree != null) {
            return SubscriberStorageAccessor.wrapStorageProvider(this.remoteTree.getResourceVariant(resource));
        }
        IDiff diff = this.subscriber.getDiff(resource);
        return SubscriberStorageAccessor.wrapStorageProvider(SubscriberStorageAccessor.getRemote(diff));
    }

    private static IStorageProvider wrapStorageProvider(IFileRevision revision) {
        if (revision != null) {
            return new FileRevisionStorageProvider(revision);
        }
        return null;
    }

    private static IStorageProvider wrapStorageProvider(IResourceVariant variant) {
        if (variant != null) {
            return new ResourceVariantStorageProvider(variant);
        }
        return null;
    }

    private static IFileRevision getOrigin(IDiff diff) throws CoreException {
        IFileRevision revision = null;
        if (diff instanceof IThreeWayDiff) {
            ITwoWayDiff localChange = ((IThreeWayDiff)diff).getLocalChange();
            ITwoWayDiff remoteChange = ((IThreeWayDiff)diff).getRemoteChange();
            if (localChange instanceof ResourceDiff) {
                revision = ((ResourceDiff)localChange).getBeforeState();
            } else if (remoteChange instanceof ResourceDiff) {
                revision = ((ResourceDiff)remoteChange).getBeforeState();
            }
        }
        return revision;
    }

    private static IFileRevision getSource(IDiff diff) throws CoreException {
        IFileRevision revision = null;
        if (diff instanceof IThreeWayDiff) {
            ITwoWayDiff localChange = ((IThreeWayDiff)diff).getLocalChange();
            if (localChange instanceof ResourceDiff) {
                revision = ((ResourceDiff)localChange).getAfterState();
            }
        } else if (diff instanceof ResourceDiff) {
            revision = ((ResourceDiff)diff).getAfterState();
        }
        return revision;
    }

    private static IFileRevision getRemote(IDiff diff) throws CoreException {
        IFileRevision revision = null;
        if (diff instanceof IThreeWayDiff) {
            ITwoWayDiff remoteChange = ((IThreeWayDiff)diff).getRemoteChange();
            if (remoteChange instanceof ResourceDiff) {
                revision = ((ResourceDiff)remoteChange).getAfterState();
            }
        } else if (diff instanceof ResourceDiff) {
            revision = ((ResourceDiff)diff).getBeforeState();
        }
        return revision;
    }

    private static IResourceVariantTree initTree(final Subscriber teamSubscriber, final String methodName) {
        Object tree;
        if (teamSubscriber instanceof ResourceVariantTreeSubscriber && (tree = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = methodName.contains("Source") ? teamSubscriber.getClass().getDeclaredMethod(methodName, new Class[0]) : ResourceVariantTreeSubscriber.class.getDeclaredMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    return method.invoke((Object)teamSubscriber, new Object[0]);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                return null;
            }
        })) instanceof IResourceVariantTree) {
            return (IResourceVariantTree)tree;
        }
        return null;
    }
}

