/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor.AbstractMergeRenamingMatchResources;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.ecore.resource.Resource;

public class MergeRenamingMatchResources3Ways
extends AbstractMergeRenamingMatchResources {
    public MergeRenamingMatchResources3Ways(Comparison comparison, Monitor monitor) {
        super(comparison, monitor);
    }

    protected Resource getBaseResource(MatchResource mr) {
        return mr.getOrigin();
    }

    protected IStorageProviderAccessor.DiffSide getBaseSide() {
        return IStorageProviderAccessor.DiffSide.ORIGIN;
    }

    protected void checkComparison() {
        Preconditions.checkState((boolean)this.comparison.isThreeWay());
    }

    protected void indexPapyrusMatchResource(MatchResource matchResource, URI baseURI) {
        Resource left = matchResource.getLeft();
        if (left != null && this.handles(left.getURI()) && !left.getURI().equals(baseURI)) {
            this.index.put((Object)left.getURI().trimFileExtension(), (Object)matchResource);
            if (baseURI != null) {
                this.renamingMatches.put(baseURI.trimFileExtension(), matchResource);
            }
        }
        super.indexPapyrusMatchResource(matchResource, baseURI);
    }

    protected void handleRenamingMatchResource(MatchResource matchResource) {
        URI originURI = this.getBaseResource(matchResource).getURI();
        Resource left = matchResource.getLeft();
        if (left != null && left.getURI() != null && !originURI.equals(left.getURI())) {
            URI leftTrimmedURI = left.getURI().trimFileExtension();
            for (MatchResource similarMatchResource : this.findSimilarMatchResources(matchResource)) {
                String fileExtension;
                URI candidateURI;
                Iterator<MatchResource> iterator = this.findMatchResources(similarMatchResource, candidateURI = leftTrimmedURI.appendFileExtension(fileExtension = this.getBaseResource(similarMatchResource).getURI().fileExtension()), true).iterator();
                if (!iterator.hasNext()) continue;
                MatchResource renamedMatchResource = iterator.next();
                similarMatchResource.setLeft(renamedMatchResource.getLeft());
                similarMatchResource.setLeftURI(renamedMatchResource.getLeftURI());
                this.comparison.getMatchedResources().remove((Object)renamedMatchResource);
            }
        }
        super.handleRenamingMatchResource(matchResource);
    }
}

