/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.DisposableResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.INamespaceDeclarationListener;
import org.eclipse.emf.compare.ide.internal.utils.IProxyCreationListener;
import org.eclipse.emf.compare.ide.internal.utils.NoNotificationParserPool;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RevisionedURIConverter;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedResourceSet
extends ResourceSetImpl
implements DisposableResourceSet {
    private static final Logger LOGGER = Logger.getLogger(SynchronizedResourceSet.class);
    private final ConcurrentHashMap<URI, Resource> uriCache = new ConcurrentHashMap();
    private final Set<URI> namespaceURIs;
    private final Set<Resource> loadedPackages;
    private final ReentrantLock packageLoadingLock;

    public SynchronizedResourceSet(IProxyCreationListener proxyListener) {
        this.resources = new SynchronizedResourcesEList();
        this.namespaceURIs = Sets.newSetFromMap(new ConcurrentHashMap());
        this.loadedPackages = Sets.newSetFromMap(new ConcurrentHashMap());
        this.packageLoadingLock = new ReentrantLock(true);
        this.loadOptions = super.getLoadOptions();
        NoNotificationParserPool parserPool = new NoNotificationParserPool(true);
        parserPool.addProxyListener(proxyListener);
        parserPool.addNamespaceDeclarationListener(new INamespaceDeclarationListener(){

            public void schemaLocationDeclared(String key, URI uri) {
                SynchronizedResourceSet.this.namespaceURIs.add(uri.trimFragment());
            }
        });
        this.loadOptions.put("USE_PARSER_POOL", parserPool);
        this.loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
    }

    public Resource loadResource(URI uri) {
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        Resource result = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".loadResource for " + normalizedURI));
        }
        if ((result = this.uriCache.get(normalizedURI)) == null) {
            result = this.delegatedGetResource(uri, true);
            if (result != null) {
                Resource former;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".loadResource - caching " + normalizedURI));
                }
                if ((former = this.uriCache.putIfAbsent(normalizedURI, result)) != null) {
                    result = former;
                }
            } else if (this.namespaceURIs.contains(uri)) {
                result = this.demandPackageLoad(uri);
            }
        }
        if (result == null) {
            result = this.demandCreateResource(uri);
            if (this.getURIConverter() instanceof RevisionedURIConverter) {
                try {
                    if (!((RevisionedURIConverter)this.getURIConverter()).prefetchStream(uri, this.getLoadOptions())) {
                        return result;
                    }
                }
                catch (IOException iOException) {}
            }
            if (result == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".loadResource - No caching for " + normalizedURI));
            }
            this.demandLoadHelper(result);
        }
        return result;
    }

    private Resource loadPackage(URI uri) {
        Resource resource;
        block15: {
            URI trimmed = uri.trimFragment();
            resource = this.createResource(trimmed, "");
            if (resource == null) {
                return null;
            }
            InputStream stream = null;
            try {
                try {
                    stream = this.getURIConverter().createInputStream(trimmed, null);
                    resource.load(stream, Collections.emptyMap());
                }
                catch (IOException e) {
                    this.handleDemandLoadException(resource, e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.loadedPackages.add(resource);
        return resource;
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) {
        try {
            super.handleDemandLoadException(resource, exception);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void unload(Resource resource, IProgressMonitor monitor) {
        URI uri = resource.getURI();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".unload " + uri));
        }
        this.uriCache.remove(uri);
        this.getResources().remove((Object)resource);
        resource.eAdapters().clear();
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        URI normalized;
        Resource demanded;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".getResource for " + uri));
        }
        if ((demanded = this.uriCache.get(normalized = this.getURIConverter().normalize(uri))) == null) {
            EPackage ePackage = this.getPackageRegistry().getEPackage(uri.toString());
            if (ePackage != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".getResource - found in package registry : " + uri));
                }
                if ((demanded = ePackage.eResource()) != null) {
                    Resource former;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".getResource - caching " + uri));
                    }
                    if ((former = this.uriCache.putIfAbsent(normalized, demanded)) != null) {
                        demanded = former;
                    }
                }
            } else if (this.namespaceURIs.contains(uri)) {
                demanded = this.demandPackageLoad(uri);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".getResource - FOUND in cache " + uri));
        }
        return demanded;
    }

    private Resource demandPackageLoad(URI uri) {
        URI normalized = this.getURIConverter().normalize(uri);
        this.packageLoadingLock.lock();
        try {
            Resource demanded = this.uriCache.get(normalized);
            if (demanded == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".getResource - loaded package normally : " + uri));
                }
                if ((demanded = this.loadPackage(uri)) != null) {
                    Resource former;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".getResource - caching package " + uri));
                    }
                    if ((former = this.uriCache.putIfAbsent(normalized, demanded)) != null) {
                        demanded = former;
                    }
                }
            }
            Resource resource = demanded;
            return resource;
        }
        finally {
            this.packageLoadingLock.unlock();
        }
    }

    public synchronized Resource createResource(URI uri) {
        return super.createResource(uri);
    }

    public synchronized Resource createResource(URI uri, String contentType) {
        return super.createResource(uri, contentType);
    }

    public EList<Resource> getResources() {
        return this.resources;
    }

    public Map<Object, Object> getLoadOptions() {
        return this.loadOptions;
    }

    public void dispose() {
        for (Resource resource : this.loadedPackages) {
            URI uri = resource.getURI();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("SRS@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ".unload " + uri));
            }
            this.uriCache.remove(uri);
            resource.unload();
            this.getResources().remove((Object)resource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SynchronizedResourcesEList<E extends Resource>
    extends ResourceSetImpl.ResourcesEList<E> {
        private static final long serialVersionUID = 7371376112881960414L;
        private final Object lock;

        private SynchronizedResourcesEList() {
            super((ResourceSetImpl)SynchronizedResourceSet.this);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return super.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E set(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return (E)((Resource)super.set(index, object));
            }
        }

        protected void dispatchNotification(Notification notification) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.add(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAll(index, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.move(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return super.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return super.toString();
            }
        }

        public Iterator<E> iterator() {
            return new SynchronizedEIterator();
        }

        public ListIterator<E> listIterator() {
            return new SynchronizedEListIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator<E> listIterator(int index) {
            Object object = this.lock;
            synchronized (object) {
                int curSize = this.size();
                if (index < 0 || index > curSize) {
                    throw new BasicEList.BasicIndexOutOfBoundsException(index, curSize);
                }
                return new SynchronizedEListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T[] toArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return super.toArray((Object[])array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setData(int size, Object[] data) {
            Object object = this.lock;
            synchronized (object) {
                super.setData(size, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E get(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.get(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E basicGet(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.basicGet(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shrink() {
            Object object = this.lock;
            synchronized (object) {
                super.shrink();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void grow(int minimumCapacity) {
            Object object = this.lock;
            synchronized (object) {
                super.grow(minimumCapacity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() {
            Object object = this.lock;
            synchronized (object) {
                return super.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.addUnique(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.addUnique(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(index, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Object[] objects, int start, int end) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(objects, start, end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Object[] objects, int start, int end) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(index, objects, start, end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicAdd(E object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicAdd(object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E remove(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.remove(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicRemove(object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E setUnique(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return (E)((Resource)super.setUnique(index, object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicSet(int index, E object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicSet(index, object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E move(int targetIndex, int sourceIndex) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.move(targetIndex, sourceIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> basicList() {
            Object object = this.lock;
            synchronized (object) {
                return super.basicList();
            }
        }

        public Iterator<E> basicIterator() {
            return new SynchronizedNonResolvingEIterator();
        }

        public ListIterator<E> basicListIterator() {
            return new SynchronizedNonResolvingEListIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator<E> basicListIterator(int index) {
            Object object = this.lock;
            synchronized (object) {
                int curSize = this.size();
                if (index < 0 || index > curSize) {
                    throw new BasicEList.BasicIndexOutOfBoundsException(index, curSize);
                }
                return new SynchronizedNonResolvingEListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean basicContains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicContains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean basicContainsAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.basicContainsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int basicIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int basicLastIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicLastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] basicToArray() {
            Object object = this.lock;
            synchronized (object) {
                return super.basicToArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T[] basicToArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return super.basicToArray((Object[])array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] data() {
            Object object = this.lock;
            synchronized (object) {
                return super.data();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFeature() {
            Object object = this.lock;
            synchronized (object) {
                return super.getFeature();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFeatureID() {
            Object object = this.lock;
            synchronized (object) {
                return super.getFeatureID();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNotifier() {
            Object object = this.lock;
            synchronized (object) {
                return super.getNotifier();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return super.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return super.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.lock;
            synchronized (object) {
                return super.subList(fromIndex, toIndex);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedEIterator
        extends AbstractEList.EIterator<E> {
            private SynchronizedEIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedEListIterator
        extends AbstractEList.EListIterator<E> {
            public SynchronizedEListIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            public SynchronizedEListIterator(int index) {
                super((AbstractEList)SynchronizedResourcesEList.this, index);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.add(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasPrevious() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasPrevious();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E previous() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.previous();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int previousIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previousIndex();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.set(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.nextIndex();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedNonResolvingEIterator
        extends AbstractEList.NonResolvingEIterator<E> {
            private SynchronizedNonResolvingEIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedNonResolvingEListIterator
        extends AbstractEList.NonResolvingEListIterator<E> {
            public SynchronizedNonResolvingEListIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            public SynchronizedNonResolvingEListIterator(int index) {
                super((AbstractEList)SynchronizedResourcesEList.this, index);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.add(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasPrevious() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasPrevious();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E previous() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.previous();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int previousIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previousIndex();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.set(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.nextIndex();
                }
            }
        }
    }
}

