/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.dependency;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.dependency.DependencyProviderDescriptor;
import org.eclipse.emf.compare.ide.ui.dependency.IDependencyProvider;
import org.eclipse.emf.ecore.resource.URIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelDependencyProviderRegistry {
    private final Map<String, DependencyProviderDescriptor> registeredDescriptors = new LinkedHashMap<String, DependencyProviderDescriptor>();

    public Set<URI> getDependencies(URI uri, URIConverter uriConverter) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (DependencyProviderDescriptor descriptor : this.registeredDescriptors.values()) {
            Set<URI> dependencies;
            IDependencyProvider provider = descriptor.getDependencyProvider();
            if (provider == null || !provider.apply(uri) || (dependencies = provider.getDependencies(uri, uriConverter)) == null) continue;
            Iterables.addAll(uris, (Iterable)Iterables.filter(dependencies, (Predicate)Predicates.notNull()));
        }
        return uris;
    }

    public void addProvider(String className, DependencyProviderDescriptor descriptor) {
        this.registeredDescriptors.put(className, descriptor);
    }

    public DependencyProviderDescriptor removeProvider(String className) {
        return this.registeredDescriptors.remove(className);
    }

    public void clear() {
        this.registeredDescriptors.clear();
    }
}

