/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.preferences.EMFComparePreferences;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterFactoriesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int DESCRIPTION_LABEL_HEIGHT_HINT = 50;
    private static final int DESCRIPTION_LABEL_WIDTH_HINT = 400;
    private CheckboxTableViewer adapterFactoryDescriptorViewer;

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setLayout((Layout)new GridLayout(1, false));
        containerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createViewer(containerComposite);
        this.createDescriptionText(parent);
        this.fillViewer();
        return containerComposite;
    }

    private void fillViewer() {
        ArrayList descriptors = Lists.newArrayList((Iterable)EMFCompareRCPPlugin.getDefault().getAdapterFactoryRegistry().getDescriptors());
        Collections.sort(descriptors, new Comparator<RankedAdapterFactoryDescriptor>(){

            @Override
            public int compare(RankedAdapterFactoryDescriptor o1, RankedAdapterFactoryDescriptor o2) {
                return ComparisonChain.start().compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())).result();
            }
        });
        this.adapterFactoryDescriptorViewer.setInput((Object)descriptors);
        List disabledDescriptors = EMFComparePreferences.getDisabledAdapterFacotryDescriptorIds((IEclipsePreferences)EMFCompareRCPPlugin.getDefault().getEMFComparePreferences());
        this.initViewer(disabledDescriptors);
    }

    private void createDescriptionText(Composite parent) {
        Group descriptionComposite = new Group(parent, 0);
        descriptionComposite.setText(EMFCompareRCPUIMessages.getString("AdapterFactoryPreferencePage.descriptionGroup.text"));
        descriptionComposite.setLayout((Layout)new GridLayout(1, false));
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        final Label engineDescriptionLabel = new Label((Composite)descriptionComposite, 64);
        engineDescriptionLabel.setBackground(Display.getCurrent().getSystemColor(22));
        GridData layoutData = new GridData(4, 4, true, false, 2, 1);
        layoutData.heightHint = 50;
        layoutData.widthHint = 400;
        engineDescriptionLabel.setLayoutData((Object)layoutData);
        this.adapterFactoryDescriptorViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structSelection;
                Object first;
                ISelection selection;
                if (AdapterFactoriesPreferencePage.this.adapterFactoryDescriptorViewer.equals(event.getSource()) && (selection = event.getSelection()) instanceof IStructuredSelection && (first = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof RankedAdapterFactoryDescriptor) {
                    String description = ((RankedAdapterFactoryDescriptor)first).getDescription();
                    if (description != null) {
                        engineDescriptionLabel.setText(description);
                    } else {
                        engineDescriptionLabel.setText("");
                    }
                }
            }
        });
    }

    private void createViewer(Composite containerComposite) {
        Group interactiveGroup = new Group(containerComposite, 2048);
        interactiveGroup.setText(EMFCompareRCPUIMessages.getString("AdapterFactoryPreferencePage.itemProviderGroup.text"));
        interactiveGroup.setLayout((Layout)new GridLayout(1, false));
        interactiveGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.adapterFactoryDescriptorViewer = CheckboxTableViewer.newCheckList((Composite)interactiveGroup, (int)68096);
        this.adapterFactoryDescriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.adapterFactoryDescriptorViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof RankedAdapterFactoryDescriptor) {
                    return ((RankedAdapterFactoryDescriptor)element).getLabel();
                }
                return super.getText(element);
            }
        });
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.adapterFactoryDescriptorViewer.getControl().setLayoutData((Object)gd);
        this.adapterFactoryDescriptorViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RankedAdapterFactoryDescriptor provider;
                Object element = event.getElement();
                if (element instanceof RankedAdapterFactoryDescriptor && !(provider = (RankedAdapterFactoryDescriptor)element).isOptional()) {
                    event.getCheckable().setChecked(element, true);
                }
            }
        });
    }

    private void initViewer(List<String> disabledDescriptors) {
        TableItem[] tableItemArray = this.adapterFactoryDescriptorViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            RankedAdapterFactoryDescriptor descriptor = (RankedAdapterFactoryDescriptor)item.getData();
            if (!descriptor.isOptional()) {
                item.setForeground(item.getDisplay().getSystemColor(15));
                item.setChecked(true);
            } else {
                item.setChecked(!disabledDescriptors.contains(descriptor.getId()));
            }
            ++n2;
        }
    }

    protected void performDefaults() {
        this.initViewer(Collections.<String>emptyList());
        super.performDefaults();
    }

    public boolean performOk() {
        Object[] checkedDescriptors = this.adapterFactoryDescriptorViewer.getCheckedElements();
        Sets.SetView descriptorsToDisable = Sets.difference((Set)Sets.newHashSet((Iterable)EMFCompareRCPPlugin.getDefault().getAdapterFactoryRegistry().getDescriptors()), (Set)Sets.newHashSet((Object[])checkedDescriptors));
        Iterable descriptorsToDisableIds = Iterables.transform((Iterable)Iterables.filter((Iterable)descriptorsToDisable, RankedAdapterFactoryDescriptor.class), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return ((RankedAdapterFactoryDescriptor)input).getId();
            }
        });
        this.getPreferenceStore().putValue("org.eclipse.emf.compare.preference.disabled.adapter.factories", Joiner.on((char)';').join(descriptorsToDisableIds));
        return super.performOk();
    }
}

