/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.WrapperItemDescriptor;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceGroupRegistryImpl
implements IDifferenceGroupProvider.Descriptor.Registry {
    private final IItemRegistry<IDifferenceGroupProvider.Descriptor> registry;
    private DifferenceGroupManager groupManager;

    public DifferenceGroupRegistryImpl(DifferenceGroupManager groupManager, IItemRegistry<IDifferenceGroupProvider.Descriptor> registry) {
        this.groupManager = groupManager;
        this.registry = registry;
    }

    public List<IDifferenceGroupProvider.Descriptor> getGroupProviders(IComparisonScope scope, Comparison comparison) {
        if (comparison != null) {
            ArrayList providers = Lists.newArrayList();
            List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> groupProviderDescriptors = this.groupManager.getCurrentGroupRanking(comparison.isThreeWay());
            ListIterator<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> groupIterator = groupProviderDescriptors.listIterator();
            while (groupIterator.hasNext()) {
                IItemDescriptor<IDifferenceGroupProvider.Descriptor> desc = groupIterator.next();
                IDifferenceGroupProvider.Descriptor groupProviderDescriptor = (IDifferenceGroupProvider.Descriptor)desc.getItem();
                IDifferenceGroupProvider gp = groupProviderDescriptor.createGroupProvider();
                if (gp == null || !DifferenceGroupRegistryImpl.isGroupProviderActivable(gp, scope, comparison)) continue;
                providers.add(groupProviderDescriptor);
            }
            return ImmutableList.copyOf((Collection)providers);
        }
        return Collections.emptyList();
    }

    @Override
    public IDifferenceGroupProvider.Descriptor getDefaultGroupProvider(IComparisonScope scope, Comparison comparison) {
        Collection descriptors = this.getGroupProviders(scope, comparison);
        if (!descriptors.isEmpty()) {
            return (IDifferenceGroupProvider.Descriptor)descriptors.get(0);
        }
        return null;
    }

    static final boolean isGroupProviderActivable(IDifferenceGroupProvider dgp, IComparisonScope scope, Comparison comparison) {
        return dgp.isEnabled(scope, comparison);
    }

    @Override
    public IDifferenceGroupProvider.Descriptor add(IDifferenceGroupProvider.Descriptor providerDescriptor, String className) {
        Preconditions.checkNotNull((Object)providerDescriptor);
        IDifferenceGroupProvider groupProvider = providerDescriptor.createGroupProvider();
        WrapperItemDescriptor descriptor = new WrapperItemDescriptor(providerDescriptor.getLabel(), providerDescriptor.getDescription(), providerDescriptor.getRank(), groupProvider.getClass().getName(), (Object)providerDescriptor);
        IItemDescriptor oldValue = this.registry.add((IItemDescriptor)descriptor);
        if (oldValue != null) {
            return (IDifferenceGroupProvider.Descriptor)oldValue.getItem();
        }
        return null;
    }

    @Override
    public IDifferenceGroupProvider.Descriptor remove(String className) {
        IItemDescriptor oldValue = this.registry.remove(className);
        if (oldValue != null) {
            return (IDifferenceGroupProvider.Descriptor)oldValue.getItem();
        }
        return null;
    }

    @Override
    public void clear() {
        this.registry.clear();
    }
}

