/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeRunnableImpl
implements IMergeRunnable {
    private final boolean isLeftEditable;
    private final boolean isRightEditable;
    private final MergeMode mergeMode;

    public MergeRunnableImpl(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        this.isLeftEditable = isLeftEditable;
        this.isRightEditable = isRightEditable;
        this.mergeMode = mergeMode;
    }

    public void merge(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Preconditions.checkState((this.mergeMode.isLeftToRight(this.isLeftEditable, this.isRightEditable) == leftToRight ? 1 : 0) != 0);
        if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
            this.mergeAll(differences, leftToRight, mergerRegistry);
        } else if (this.mergeMode == MergeMode.ACCEPT || this.mergeMode == MergeMode.REJECT) {
            ArrayList diffToMarkAsMerged = Lists.newArrayList();
            ArrayList diffToCopyFromLeftToRight = Lists.newArrayList();
            ArrayList diffToCopyFromRightToLeft = Lists.newArrayList();
            for (Diff diff : differences) {
                MergeOperation mergeAction = this.mergeMode.getMergeAction(diff, this.isLeftEditable, this.isRightEditable);
                if (mergeAction == MergeOperation.MARK_AS_MERGE) {
                    diffToMarkAsMerged.add(diff);
                    continue;
                }
                if (this.isLeftEditable && leftToRight) {
                    diffToCopyFromRightToLeft.add(diff);
                    continue;
                }
                diffToCopyFromLeftToRight.add(diff);
            }
            this.mergeAll(diffToCopyFromLeftToRight, leftToRight, mergerRegistry);
            this.mergeAll(diffToCopyFromRightToLeft, !leftToRight, mergerRegistry);
            this.markAllAsMerged(diffToMarkAsMerged, this.mergeMode);
        } else {
            throw new IllegalStateException();
        }
    }

    private void markAllAsMerged(Collection<Diff> diffToMarkAsMerged, MergeMode mode) {
        for (Diff diff : diffToMarkAsMerged) {
            boolean isLeftToRight = mode.isLeftToRight(diff, this.isLeftEditable, this.isRightEditable);
            this.markAsMerged(diff, mode, isLeftToRight);
        }
    }

    private void markAsMerged(Diff diff, MergeMode mode, boolean leftToRight) {
        if (diff.getState() == DifferenceState.MERGED) {
            return;
        }
        diff.setState(DifferenceState.MERGED);
        this.addOrUpdateMergeData(diff, mode);
        for (Diff req : DiffUtil.getRequires((Diff)diff, (boolean)leftToRight)) {
            req.setState(DifferenceState.MERGED);
            this.addOrUpdateMergeData(req, mode);
        }
        for (Diff unm : DiffUtil.getUnmergeables((Diff)diff, (boolean)leftToRight)) {
            unm.setState(DifferenceState.MERGED);
            if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
                this.addOrUpdateMergeData(unm, mode);
                continue;
            }
            this.addOrUpdateMergeData(unm, mode.inverse());
        }
    }

    private void addOrUpdateMergeData(Collection<Diff> differences, MergeMode mode) {
        for (Diff difference : differences) {
            this.addOrUpdateMergeData(difference, mode);
        }
    }

    private void addOrUpdateMergeData(Diff diff, MergeMode mode) {
        IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
        if (mergeData != null) {
            mergeData.setMergeMode(mode);
            mergeData.setLeftEditable(this.isLeftEditable);
            mergeData.setRightEditable(this.isRightEditable);
        } else {
            mergeData = new MergeDataImpl(mode, this.isLeftEditable, this.isRightEditable);
            diff.eAdapters().add((Object)mergeData);
        }
    }

    private void mergeAll(Collection<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        BatchMerger merger = new BatchMerger(mergerRegistry);
        if (leftToRight) {
            merger.copyAllLeftToRight(differences, (Monitor)new BasicMonitor());
        } else {
            merger.copyAllRightToLeft(differences, (Monitor)new BasicMonitor());
        }
        for (Diff diff : differences) {
            this.addOrUpdateMergeData(diff, this.mergeMode);
            this.addOrUpdateMergeData(DiffUtil.getRequires((Diff)diff, (boolean)leftToRight), this.mergeMode);
            if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
                this.addOrUpdateMergeData(DiffUtil.getUnmergeables((Diff)diff, (boolean)leftToRight), this.mergeMode);
                continue;
            }
            this.addOrUpdateMergeData(DiffUtil.getUnmergeables((Diff)diff, (boolean)leftToRight), this.mergeMode.inverse());
        }
    }
}

