/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Graph<E> {
    private final Map<E, Node<E>> nodes = new LinkedHashMap<E, Node<E>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(E element) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            return this.nodes.containsKey(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            this.nodes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E element) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            block4: {
                Node<E> node = this.nodes.get(element);
                if (node != null) break block4;
                node = new Node<E>(element);
                this.nodes.put(element, node);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E element) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.remove(element);
            if (node != null) {
                node.breakConnections();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<E> elements) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            for (E e : elements) {
                this.remove(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(E element, Set<E> newChildren) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(element);
            if (node == null) {
                node = new Node<E>(element);
                this.nodes.put(element, node);
            }
            for (E newChild : newChildren) {
                Node<E> childNode = this.nodes.get(newChild);
                if (childNode == null) {
                    childNode = new Node<E>(newChild);
                    this.nodes.put(newChild, childNode);
                }
                node.connectChild(childNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChild(E parent, E potentialChild) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(potentialChild);
            if (node != null) {
                return Iterables.any(node.getAllParents(), this.is(parent));
            }
            return false;
        }
    }

    private Predicate<? super Node<E>> is(final E element) {
        return new Predicate<Node<E>>(){

            public boolean apply(Node<E> input) {
                return input != null && input.getElement() == element;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> getDirectParents(E element) {
        LinkedHashSet<E> parents = new LinkedHashSet<E>();
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(element);
            if (node != null) {
                for (Node<E> parent : node.getParents()) {
                    parents.add(parent.getElement());
                }
            }
        }
        return parents;
    }

    public Set<E> getTreeFrom(E root) {
        return this.getTreeFrom(root, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> getTreeFrom(E root, Set<E> endPoints) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(root);
            if (node != null) {
                Set<Object> boundaries = endPoints;
                if (boundaries == null) {
                    boundaries = Collections.emptySet();
                }
                return new SubgraphBuilder<E>(node, boundaries).buildTree();
            }
        }
        return Collections.emptySet();
    }

    public Set<E> getSubgraphContaining(E element) {
        return this.getSubgraphContaining(element, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> getSubgraphContaining(E element, Set<E> endPoints) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(element);
            if (node != null) {
                Set<Object> boundaries = endPoints;
                if (boundaries == null) {
                    boundaries = Collections.emptySet();
                }
                return new SubgraphBuilder<E>(node, boundaries).buildSubgraph();
            }
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<K> {
        private final K element;
        private final Set<Node<K>> children;
        private final Set<Node<K>> parents;

        public Node(K element) {
            this.element = element;
            this.parents = new LinkedHashSet<Node<K>>();
            this.children = new LinkedHashSet<Node<K>>();
        }

        public Set<Node<K>> getChildren() {
            return Collections.unmodifiableSet(this.children);
        }

        public Set<Node<K>> getParents() {
            return Collections.unmodifiableSet(this.parents);
        }

        public Iterable<Node<K>> getAllParents() {
            return new ParentsIterable(this);
        }

        public void connectChild(Node<K> child) {
            this.children.add(child);
            child.parents.add(this);
        }

        public void breakConnections() {
            for (Node<K> parent : this.parents) {
                parent.children.remove(this);
            }
            for (Node<K> child : this.children) {
                child.parents.remove(this);
            }
            this.parents.clear();
            this.children.clear();
        }

        public K getElement() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentsIterable<O>
    implements Iterable<Node<O>> {
        private final Node<O> start;

        public ParentsIterable(Node<O> start) {
            this.start = start;
        }

        @Override
        public Iterator<Node<O>> iterator() {
            return new ParentsIterator<O>(this.start);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentsIterator<P>
    extends AbstractTreeIterator<Node<P>> {
        private static final long serialVersionUID = -4476850344598138970L;

        public ParentsIterator(Node<P> start) {
            super(start, false);
        }

        protected Iterator<? extends Node<P>> getChildren(Object obj) {
            return ((Node)obj).getParents().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubgraphBuilder<L> {
        private final Node<L> start;
        protected final Set<L> set;
        protected final Set<L> endPoints;

        public SubgraphBuilder(Node<L> start, Set<L> endPoints) {
            this.start = start;
            this.set = new LinkedHashSet<L>();
            this.set.add(start.getElement());
            this.endPoints = (Set)Preconditions.checkNotNull(endPoints);
        }

        public Set<L> buildSubgraph() {
            return ImmutableSet.copyOf((Iterator)new NodeIterator(this.start));
        }

        public Set<L> buildTree() {
            NodeIterator iterator = new NodeIterator(this, this.start){

                @Override
                protected Iterator<Node<L>> createConnectedNodesIterator(Node<L> node) {
                    return node.getChildren().iterator();
                }
            };
            return ImmutableSet.copyOf((Iterator)iterator);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NodeIterator
        implements Iterator<L> {
            private final Iterator<Node<L>> nodesIterator;
            private Iterator<L> nextNodeIterator;
            private L next;

            public NodeIterator(Node<L> node) {
                this.next = node.getElement();
                this.nodesIterator = this.createConnectedNodesIterator(node);
                this.prepareNextIterator();
            }

            protected Iterator<Node<L>> createConnectedNodesIterator(Node<L> node) {
                return Iterators.concat(node.getParents().iterator(), node.getChildren().iterator());
            }

            @Override
            public boolean hasNext() {
                return this.next != null || this.nextNodeIterator.hasNext() || this.nodesIterator.hasNext();
            }

            @Override
            public L next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.prepareNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void prepareNext() {
                if (!this.nextNodeIterator.hasNext()) {
                    this.prepareNextIterator();
                }
                this.next = this.nextNodeIterator.hasNext() ? this.nextNodeIterator.next() : null;
            }

            private void prepareNextIterator() {
                if (this.nodesIterator.hasNext()) {
                    Node nextNode = this.nodesIterator.next();
                    while (SubgraphBuilder.this.set.contains(nextNode.getElement()) && !SubgraphBuilder.this.endPoints.contains(nextNode.getElement()) && this.nodesIterator.hasNext()) {
                        nextNode = this.nodesIterator.next();
                    }
                    this.nextNodeIterator = !SubgraphBuilder.this.endPoints.contains(nextNode.getElement()) && SubgraphBuilder.this.set.add(nextNode.getElement()) ? new NodeIterator(nextNode) : Iterators.emptyIterator();
                } else {
                    this.nextNodeIterator = Iterators.emptyIterator();
                }
            }
        }
    }
}

