/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdenticalResourceMinimizer
implements IModelMinimizer {
    @Override
    public void minimize(SynchronizationModel syncModel, IProgressMonitor monitor) {
        SubMonitor progess = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progess.subTask(EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.minimizing"));
        StorageTraversal leftTraversal = syncModel.getLeftTraversal();
        StorageTraversal rightTraversal = syncModel.getRightTraversal();
        StorageTraversal originTraversal = syncModel.getOriginTraversal();
        boolean threeWay = !originTraversal.getStorages().isEmpty();
        LinkedHashSet leftCopy = Sets.newLinkedHashSet((Iterable)leftTraversal.getStorages());
        LinkedHashSet rightCopy = Sets.newLinkedHashSet((Iterable)rightTraversal.getStorages());
        LinkedHashSet originCopy = Sets.newLinkedHashSet((Iterable)originTraversal.getStorages());
        SubMonitor subMonitor = progess.newChild(98).setWorkRemaining(leftCopy.size());
        for (IStorage left : leftCopy) {
            IStorage right = this.removeLikeNamedStorageFrom(left, rightCopy);
            if (right != null && threeWay) {
                IStorage origin = this.removeLikeNamedStorageFrom(left, originCopy);
                if (origin != null && this.equals(left, right, origin)) {
                    leftTraversal.removeStorage(left);
                    rightTraversal.removeStorage(right);
                    originTraversal.removeStorage(origin);
                }
            } else if (right != null && this.equals(left, right)) {
                leftTraversal.removeStorage(left);
                rightTraversal.removeStorage(right);
            } else if (right == null && left.isReadOnly() && !this.isInWorkspace(left)) {
                leftTraversal.getStorages().remove(left);
            }
            subMonitor.worked(1);
        }
        subMonitor = progess.newChild(1).setWorkRemaining(rightCopy.size());
        for (IStorage right : rightCopy) {
            if (right.isReadOnly() && !this.isInWorkspace(right)) {
                rightTraversal.removeStorage(right);
            }
            subMonitor.worked(1);
        }
        subMonitor = progess.newChild(1).setWorkRemaining(rightCopy.size());
        for (IStorage origin : originCopy) {
            if (origin.isReadOnly() && !this.isInWorkspace(origin)) {
                originTraversal.removeStorage(origin);
            }
            subMonitor.worked(1);
        }
    }

    protected boolean equals(IStorage left, IStorage right, IStorage origin) {
        return ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right, (IStorage)origin);
    }

    protected boolean equals(IStorage left, IStorage right) {
        return ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right);
    }

    protected IStorage removeLikeNamedStorageFrom(IStorage reference, Set<IStorage> candidates) {
        String referenceName = reference.getName();
        Iterator<IStorage> candidatesIterator = candidates.iterator();
        while (candidatesIterator.hasNext()) {
            IStorage candidate = candidatesIterator.next();
            String candidateName = candidate.getName();
            if (!referenceName.equals(candidateName)) continue;
            candidatesIterator.remove();
            return candidate;
        }
        return null;
    }

    boolean isInWorkspace(IStorage storage) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null) {
            return root.getFile(storage.getFullPath()).isAccessible();
        }
        return false;
    }
}

