/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.editor;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.AccessorAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.legacy.impl.TypedNotifier;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.swt.graphics.Image;

public class ComparisonScopeInput
implements ICompareInput {
    private final int kind;
    private final IComparisonScope scope;
    private final AdapterFactory adapterFactory;
    private final ListenerList listeners;

    public ComparisonScopeInput(IComparisonScope scope, AdapterFactory adapterFactory) {
        this.scope = scope;
        this.adapterFactory = adapterFactory;
        this.kind = scope.getOrigin() == null ? 3 : 12;
        this.listeners = new ListenerList(1);
    }

    public IComparisonScope getComparisonScope() {
        return this.scope;
    }

    public String getName() {
        return this.getMainElement().getName();
    }

    public Image getImage() {
        return this.getMainElement().getImage();
    }

    private ITypedElement getMainElement() {
        if (this.getLeft() != null) {
            return this.getLeft();
        }
        if (this.getRight() != null) {
            return this.getRight();
        }
        return this.getAncestor();
    }

    public int getKind() {
        return this.kind;
    }

    public ITypedElement getAncestor() {
        if (this.scope.getOrigin() == null) {
            return null;
        }
        return AccessorAdapter.adapt(new TypedNotifier(this.adapterFactory, this.scope.getOrigin()));
    }

    public ITypedElement getLeft() {
        if (this.scope.getLeft() == null) {
            return null;
        }
        return AccessorAdapter.adapt(new TypedNotifier(this.adapterFactory, this.scope.getLeft()));
    }

    public ITypedElement getRight() {
        if (this.scope.getRight() == null) {
            return null;
        }
        return AccessorAdapter.adapt(new TypedNotifier(this.adapterFactory, this.scope.getRight()));
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireChange() {
        if (!this.listeners.isEmpty()) {
            Object[] allListeners = this.listeners.getListeners();
            int i = 0;
            while (i < allListeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)allListeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)ComparisonScopeInput.this);
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++i;
            }
        }
    }

    public void copy(boolean leftToRight) {
        throw new UnsupportedOperationException(String.valueOf(ComparisonScopeInput.class.getName()) + "#copy(boolean)");
    }
}

