/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByResourceGroupProvider
extends AbstractDifferenceGroupProvider {
    private IDifferenceGroup group;
    private Comparison comp;

    @Override
    public Collection<? extends IDifferenceGroup> getGroups(Comparison comparison) {
        if (this.group == null || !comparison.equals(this.comp)) {
            this.dispose();
            this.comp = comparison;
            this.group = new ResourceGroup(comparison, this.getCrossReferenceAdapter());
        }
        return ImmutableList.of((Object)this.group);
    }

    @Override
    public void dispose() {
        this.comp = null;
        if (this.group != null) {
            this.group.dispose();
            this.group = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceGroup
    extends BasicDifferenceGroupImpl {
        public ResourceGroup(Comparison comparison, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, (Predicate<? super Diff>)Predicates.alwaysTrue(), crossReferenceAdapter);
        }

        @Override
        public List<? extends TreeNode> getChildren() {
            if (this.children == null) {
                this.children = Lists.newArrayList();
                this.extensionDiffProcessed = Sets.newLinkedHashSet();
                for (MatchResource matchResource : this.getComparison().getMatchedResources()) {
                    this.children.add(this.buildSubTree(matchResource));
                }
                this.registerCrossReferenceAdapter(this.children);
            }
            return this.children;
        }

        @Override
        protected TreeNode buildSubTree(MatchResource matchResource) {
            TreeNode ret = this.wrap((EObject)matchResource);
            for (Match match : this.getComparison().getMatches()) {
                ret.getChildren().addAll(this.buildSubTree(matchResource, match));
            }
            return ret;
        }

        @Override
        protected List<TreeNode> buildSubTree(MatchResource matchResource, Match match) {
            ArrayList ret = Lists.newArrayList();
            if (this.isRootOfResourceURI(match.getLeft(), matchResource.getLeftURI()) || this.isRootOfResourceURI(match.getRight(), matchResource.getRightURI()) || this.isRootOfResourceURI(match.getOrigin(), matchResource.getOriginURI())) {
                ret.addAll(this.buildSubTree((Match)null, match));
            } else {
                for (Match subMatch : match.getSubmatches()) {
                    ret.addAll(this.buildSubTree(matchResource, subMatch));
                }
            }
            return ret;
        }

        @Override
        public List<TreeNode> buildSubTree(Match parentMatch, Match match) {
            ArrayList ret = Lists.newArrayList();
            Collection resourceAttachmentChanges = Collections2.filter((Collection)match.getDifferences(), ResourceGroup.resourceAttachmentChange());
            if (!resourceAttachmentChanges.isEmpty()) {
                for (Diff diff : resourceAttachmentChanges) {
                    ret.add(this.wrap((EObject)diff));
                }
            }
            if (ret.isEmpty()) {
                ret.add(this.wrap((EObject)match));
            }
            for (TreeNode treeNode : ret) {
                treeNode.getChildren().addAll(this.buildSubTree(match, false, BasicDifferenceGroupImpl.ChildrenSide.BOTH));
            }
            return ret;
        }
    }
}

