/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.extensions.provider.spec;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.DiagramDiffItemProvider;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.ForwardingItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.gmf.runtime.notation.View;

public class ForwardingDiagramDiffItemProvider
extends ForwardingItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    protected static final String HAS_BEEN = " has been ";
    protected static final String UNSUPPORTED = "Unsupported ";
    protected static final String VALUE = " value: ";
    private static final int ELIDE_LENGTH = 50;
    private OverlayImageProvider overlayProvider;

    public ForwardingDiagramDiffItemProvider(ItemProviderAdapter delegate) {
        super(delegate);
        if (delegate instanceof DiagramDiffItemProvider) {
            this.overlayProvider = new OverlayImageProvider(((DiagramDiffItemProvider)this.delegate()).getResourceLocator());
        }
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public Object getImage(Object object) {
        DiagramDiff diagramDiff = (DiagramDiff)object;
        Object image = null;
        image = diagramDiff.getView() instanceof View ? ForwardingDiagramDiffItemProvider.getImage(this.getRootAdapterFactory(), diagramDiff.getView()) : super.getImage(object);
        if (this.overlayProvider != null && image != null) {
            Object diffImage = this.overlayProvider.getComposedImage((Diff)diagramDiff, image);
            return ((DiagramDiffItemProvider)this.delegate()).getOverlayImage(object, diffImage);
        }
        return image;
    }

    private static Object getImage(AdapterFactory adapterFactory, Object object) {
        Object adapter;
        Preconditions.checkNotNull((Object)adapterFactory);
        if (object != null && (adapter = adapterFactory.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getImage(object);
        }
        return null;
    }

    protected String getValueText(DiagramDiff diagramDiff) {
        return this.getValueText(diagramDiff.getView());
    }

    protected String getValueText(EObject view) {
        String value;
        EObject reference = null;
        if (view instanceof View) {
            reference = view;
        }
        value = (value = AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)reference)) == null ? "<null>" : Strings.elide((String)value, (int)50, (String)"...");
        return value;
    }

    protected String getReferenceText(DiagramDiff diagramDiff) {
        return " ";
    }

    public Object getForeground(Object object) {
        DiagramDiff referenceChange = (DiagramDiff)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    public String getDescription(Object object) {
        DiagramDiff diagramDiff = (DiagramDiff)object;
        String valueText = this.getValueText(diagramDiff);
        String referenceText = this.getReferenceText(diagramDiff);
        String remotely = "";
        if (diagramDiff.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (diagramDiff.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "added to " + referenceText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "deleted from " + referenceText;
                break;
            }
            case CHANGE: {
                ret = String.valueOf(referenceText) + " " + valueText + HAS_BEEN + remotely + "change";
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "moved in " + referenceText;
                break;
            }
            default: {
                throw new IllegalStateException(UNSUPPORTED + DifferenceKind.class.getSimpleName() + VALUE + diagramDiff.getKind());
            }
        }
        return ret;
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        DiagramDiff diagramDiff = (DiagramDiff)object;
        String valueText = this.getValueText(diagramDiff);
        String referenceText = this.getReferenceText(diagramDiff);
        ComposedStyledString ret = new ComposedStyledString(valueText);
        ret.append(" [" + referenceText, IStyledString.Style.DECORATIONS_STYLER);
        this.buildStyledText(diagramDiff.getKind(), ret);
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    protected void buildStyledText(DifferenceKind kind, ComposedStyledString ret) {
        switch (kind) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" change", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException(UNSUPPORTED + DifferenceKind.class.getSimpleName() + VALUE + kind);
            }
        }
    }
}

