/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.ui.IEditorInput;

public class StreamAccessorStorage
implements IStorage {
    private final IStreamContentAccessor accessor;
    private final String fullPath;

    public StreamAccessorStorage(IStreamContentAccessor accessor, String fullPath) {
        this.accessor = accessor;
        this.fullPath = fullPath;
    }

    public static StreamAccessorStorage fromTypedElement(ITypedElement element) throws IllegalArgumentException {
        return StreamAccessorStorage.fromTypedElement(null, element);
    }

    public static StreamAccessorStorage fromTypedElement(String storagePath, ITypedElement element) throws IllegalArgumentException {
        if (!(element instanceof IStreamContentAccessor)) {
            throw new IllegalArgumentException();
        }
        String fullPath = storagePath != null ? storagePath : StreamAccessorStorage.findPath(element);
        return new StreamAccessorStorage((IStreamContentAccessor)element, fullPath);
    }

    private static String findPath(ITypedElement element) {
        String fullPath;
        IFile file = PlatformElementUtil.findFile(element);
        if (file != null) {
            fullPath = file.getFullPath().toString();
        } else {
            IFileRevision revision = StreamAccessorStorage.findFileRevision(element);
            String tmp = null;
            if (revision != null) {
                IResourceVariant variant;
                java.net.URI uri = revision.getURI();
                if (uri != null) {
                    tmp = URI.decode((String)uri.toString());
                } else if (revision instanceof IAdaptable && (variant = (IResourceVariant)((IAdaptable)revision).getAdapter(IResourceVariant.class)) instanceof CachedResourceVariant) {
                    tmp = ((CachedResourceVariant)variant).getDisplayPath().toString();
                }
            }
            fullPath = tmp != null ? tmp : element.getName();
        }
        return fullPath;
    }

    public Object getAdapter(Class adapter) {
        StreamAccessorStorage adapted = null;
        if (adapter.isInstance(this)) {
            adapted = this;
        } else if (adapter == IStreamContentAccessor.class) {
            adapted = this.accessor;
        } else if (this.accessor instanceof ITypedElement) {
            if (adapter == ITypedElement.class) {
                adapted = this.accessor;
            } else if (adapter.isAssignableFrom(IFile.class)) {
                adapted = PlatformElementUtil.findFile((ITypedElement)this.accessor);
            }
        }
        return adapted;
    }

    public InputStream getContents() throws CoreException {
        return this.accessor.getContents();
    }

    public IPath getFullPath() {
        return new Path(this.fullPath);
    }

    public String getName() {
        if (this.accessor instanceof ITypedElement) {
            return ((ITypedElement)this.accessor).getName();
        }
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        File file;
        if (this.accessor instanceof ITypedElement && (file = PlatformElementUtil.findFile((ITypedElement)this.accessor)) != null) {
            return file.isReadOnly();
        }
        file = this.getFullPath().toFile();
        return !file.exists() || !file.canWrite();
    }

    private static IFileRevision findFileRevision(ITypedElement element) {
        IEditorInput editorInput;
        ISharedDocumentAdapter documentAdapter;
        if (element == null) {
            return null;
        }
        IFileRevision revision = PlatformElementUtil.adaptAs(element, IFileRevision.class);
        if (revision == null && (documentAdapter = PlatformElementUtil.adaptAs(element, ISharedDocumentAdapter.class)) != null && (editorInput = documentAdapter.getDocumentKey((Object)element)) != null) {
            revision = PlatformElementUtil.adaptAs(editorInput, IFileRevision.class);
        }
        if (revision == null) {
            try {
                Method method = element.getClass().getMethod("getFileRevision", new Class[0]);
                Object value = method.invoke((Object)element, new Object[0]);
                if (value instanceof IFileRevision) {
                    revision = (IFileRevision)value;
                }
            }
            catch (Exception exception) {}
        }
        return revision;
    }
}

